/*
 * Decompiled with CFR 0.152.
 */
package jtides;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.GregorianCalendar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jtides.HelpBrowser;
import jtides.JTides;
import jtides.SiteSet;
import jtides.SiteTree;
import jtides.TideConstants;
import jtides.TidePanel;

public final class TidesDoc
extends JPanel {
    TidePanel panel = null;
    Component clientPanel = null;
    JScrollPane scrollPane;
    JTides main;
    public SiteSet siteSet;
    boolean needInit = true;
    String title;
    int type;

    public TidesDoc(JTides jTides, int n, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.main = jTides;
        boolean bl5 = this.main.configValues.maximized;
        this.setLayout(new BorderLayout());
        this.type = n;
        this.title = string;
        this.siteSet = new SiteSet();
        this.siteSet.fullName = string;
        this.siteSet.name = string;
        this.init();
        if (this.type == 0) {
            this.processSiteData(string);
        }
        this.setVisible(true);
    }

    private void init() {
        this.initComponents();
        if (this.type == 0) {
            this.panel = new TidePanel(this.main, this);
            this.add((Component)this.panel, "Center");
            this.clientPanel = this.panel;
        } else if (this.type == 1) {
            SiteTree siteTree = new SiteTree(this.main);
            this.add((Component)siteTree, "Center");
            siteTree.getTree().expandRow(0);
            this.siteSet.shortName = "Sites";
            if (siteTree.isVisible()) {
                siteTree.repaint();
            }
            this.main.currentFinder = this;
            this.clientPanel = siteTree;
        } else if (this.type == 2) {
            HelpBrowser helpBrowser = new HelpBrowser(this.main);
            this.add((Component)helpBrowser, "Center");
            this.siteSet.shortName = "Help";
            this.main.currentHelpBrowser = this;
            this.clientPanel = helpBrowser;
        }
    }

    private void processSiteData(String string) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        this.main.tideComp.readSite(this.siteSet, string, gregorianCalendar.get(1));
        this.resetTitle();
    }

    void resetTitle() {
        if (this.type == 0) {
            this.main.tabbedPaneManager.refreshTitle();
        }
    }

    private String formatTitleDate(GregorianCalendar gregorianCalendar) {
        String string = TideConstants.dowNames[gregorianCalendar.get(7) - 1] + " " + this.main.tideComp.padChar(gregorianCalendar.get(2) + 1, 2, "0") + "/" + this.main.tideComp.padChar(gregorianCalendar.get(5), 2, "0") + "/" + gregorianCalendar.get(1);
        return string;
    }

    public String getTitleString() {
        return this.siteSet.name + " " + this.formatTitleDate(this.panel.chartCal);
    }

    private void initComponents() {
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                TidesDoc.this.formFocusGained(focusEvent);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                TidesDoc.this.formFocusLost(focusEvent);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                TidesDoc.this.formKeyReleased(keyEvent);
            }
        });
        this.setLayout(new BorderLayout());
    }

    private void formFocusGained(FocusEvent focusEvent) {
        this.main.currentSelectedFrame = this;
    }

    private void formFocusLost(FocusEvent focusEvent) {
    }

    private void formKeyReleased(KeyEvent keyEvent) {
        this.handleKey(keyEvent);
    }

    public void handleKey(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 9) {
            keyEvent.consume();
            this.main.tabbedPaneManager.moveToNextWindow();
        } else if (n == 112) {
            this.main.openFile("Help Browser", true);
        } else if (this.type == 0) {
            ((TidePanel)this.clientPanel).keyHandler(keyEvent);
        }
    }

    public void newDisplay() {
        this.resetTitle();
        if (this.isVisible()) {
            this.repaint();
        }
    }
}

