/*
 * Decompiled with CFR 0.152.
 */
package jtides;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.Timer;
import javax.swing.UIManager;
import jtides.ConfigValues;
import jtides.HTMLDatabase;
import jtides.JTides;
import jtides.MyJButton;
import jtides.TidesDatabase;

public final class TideConfiguration
extends JDialog {
    ConfigValues configValues;
    TidesDatabase dataBase;
    HTMLDatabase htmlBase;
    JTides main;
    Timer timer;
    boolean allowWrites = false;
    private JRadioButton AMPMButton;
    private JCheckBox BackgroundCheckBox;
    private JCheckBox BoldFontCheckBox;
    private JButton CloseButton;
    private JCheckBox DarkColorCheckBox;
    private JPanel DataOptions;
    private JComboBox DaylightHandling;
    private JPanel DispayOptions;
    private JRadioButton FeetButton;
    private JCheckBox GridCheckBox;
    private JCheckBox GridNumbersCheckBox;
    private JCheckBox LabelCheckBox;
    private JComboBox LookAndFeel;
    private JRadioButton MetersButton;
    private JRadioButton MilitaryTimeButton;
    private JCheckBox RiseSetDataCheckbox;
    private JCheckBox SunTwilightCheckBox;
    private JCheckBox ThickLineCheckBox;
    private JCheckBox TideCurrentListCheckBox;
    private JCheckBox TimeTideCheckBox;
    private JComboBox TimeZoneBox;
    private JPanel htmlPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel9;
    private JTabbedPane jTabbedPane1;

    public TideConfiguration(JTides jTides, boolean bl) {
        super((Frame)jTides, bl);
        this.setDefaultCloseOperation(0);
        this.main = jTides;
        this.configValues = this.main.configValues;
        this.initComponents();
        this.dataBase = new TidesDatabase(this.main);
        this.DataOptions.add((Component)this.dataBase, "Center");
        this.htmlBase = new HTMLDatabase(this.main);
        this.htmlPanel.add((Component)this.htmlBase, "Center");
        this.setupComponentData();
        this.setupComponentValues();
        this.pack();
        this.setVisible(true);
        this.allowWrites = true;
    }

    private void setupComponentData() {
        int n;
        this.setTitle("JTides 5.3" + " Configuration/Database Dialog");
        this.jTabbedPane1.setTitleAt(0, "Configuration");
        this.jTabbedPane1.setTitleAt(1, "Text Database");
        this.jTabbedPane1.setTitleAt(2, "HTML Pages");
        String[] stringArray = new String[]{"Always use standard time", "Compute daylight time", "Always use daylight time"};
        for (n = 0; n < stringArray.length; ++n) {
            this.DaylightHandling.addItem(stringArray[n]);
        }
        this.TimeZoneBox.addItem("Use System Time Zone");
        this.TimeZoneBox.addItem("Use Site   Time Zone");
        for (n = -12; n <= 12; ++n) {
            String string = "GMT";
            if (n >= 0) {
                string = string + "+";
            }
            string = string + n;
            this.TimeZoneBox.addItem(string);
        }
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        for (int i = 0; i < lookAndFeelInfoArray.length; ++i) {
            this.LookAndFeel.addItem(lookAndFeelInfoArray[i].getName());
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.MetersButton);
        buttonGroup.add(this.FeetButton);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.AMPMButton);
        buttonGroup2.add(this.MilitaryTimeButton);
    }

    private void setupComponentValues() {
        this.setupComponent(this.AMPMButton, this.main.configValues.ampmFlag);
        this.setupComponent(this.MilitaryTimeButton, !this.main.configValues.ampmFlag);
        this.setupComponent(this.MetersButton, this.main.configValues.displayUnits != 1);
        this.setupComponent(this.FeetButton, this.main.configValues.displayUnits == 1);
        this.DaylightHandling.setSelectedIndex(this.main.configValues.daylightTime);
        this.TimeZoneBox.setSelectedIndex((int)(this.main.configValues.timeZone + 14.0));
        if (this.main.configValues.LookAndFeel == -1) {
            int n;
            for (n = 0; n < this.LookAndFeel.getComponentCount() && this.LookAndFeel.getItemAt(n).toString().indexOf("Metal") == -1; ++n) {
            }
            if (n < this.LookAndFeel.getComponentCount()) {
                this.LookAndFeel.setSelectedIndex(n);
            }
        } else {
            this.LookAndFeel.setSelectedIndex(this.main.configValues.LookAndFeel);
        }
        this.setupComponent(this.TimeTideCheckBox, this.main.configValues.timeLine);
        this.setupComponent(this.GridCheckBox, this.main.configValues.chartGrid);
        this.setupComponent(this.GridNumbersCheckBox, this.main.configValues.gridNums);
        this.setupComponent(this.BackgroundCheckBox, this.main.configValues.listBackground);
        this.setupComponent(this.SunTwilightCheckBox, this.main.configValues.sunGraphic);
        this.setupComponent(this.DarkColorCheckBox, this.main.configValues.sunGraphicDark);
        this.setupComponent(this.LabelCheckBox, this.main.configValues.siteLabel);
        this.setupComponent(this.RiseSetDataCheckbox, this.main.configValues.sunText);
        this.setupComponent(this.TideCurrentListCheckBox, this.main.configValues.tideList);
        this.setupComponent(this.ThickLineCheckBox, this.main.configValues.thickLine);
        this.setupComponent(this.BoldFontCheckBox, this.main.configValues.boldFont);
    }

    private void setupComponent(JRadioButton jRadioButton, boolean bl) {
        jRadioButton.setSelected(bl);
        jRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TideConfiguration.this.dataActionPerformed(actionEvent);
            }
        });
    }

    private void setupComponent(JCheckBox jCheckBox, boolean bl) {
        jCheckBox.setSelected(bl);
        jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TideConfiguration.this.dataActionPerformed(actionEvent);
            }
        });
    }

    private void changeTimeZone() {
        int n = this.TimeZoneBox.getSelectedIndex();
        this.main.configValues.timeZone = n - 14;
    }

    private void dataActionPerformed(ActionEvent actionEvent) {
        if (this.allowWrites) {
            Object object = actionEvent.getSource();
            if (object == this.AMPMButton) {
                this.main.configValues.ampmFlag = true;
            } else if (object == this.MilitaryTimeButton) {
                this.main.configValues.ampmFlag = false;
            } else if (object == this.FeetButton) {
                this.main.configValues.displayUnits = 1;
            } else if (object == this.MetersButton) {
                this.main.configValues.displayUnits = 0;
            } else if (object == this.TimeTideCheckBox) {
                this.main.configValues.timeLine = ((JCheckBox)object).isSelected();
            } else if (object == this.GridCheckBox) {
                this.main.configValues.chartGrid = ((JCheckBox)object).isSelected();
            } else if (object == this.GridNumbersCheckBox) {
                this.main.configValues.gridNums = ((JCheckBox)object).isSelected();
            } else if (object == this.BackgroundCheckBox) {
                this.main.configValues.listBackground = ((JCheckBox)object).isSelected();
            } else if (object == this.SunTwilightCheckBox) {
                this.main.configValues.sunGraphic = ((JCheckBox)object).isSelected();
            } else if (object == this.DarkColorCheckBox) {
                this.main.configValues.sunGraphicDark = ((JCheckBox)object).isSelected();
            } else if (object == this.LabelCheckBox) {
                this.main.configValues.siteLabel = ((JCheckBox)object).isSelected();
            } else if (object == this.RiseSetDataCheckbox) {
                this.main.configValues.sunText = ((JCheckBox)object).isSelected();
            } else if (object == this.TideCurrentListCheckBox) {
                this.main.configValues.tideList = ((JCheckBox)object).isSelected();
            } else if (object == this.ThickLineCheckBox) {
                this.main.configValues.thickLine = ((JCheckBox)object).isSelected();
            } else if (object == this.BoldFontCheckBox) {
                this.main.configValues.boldFont = ((JCheckBox)object).isSelected();
            }
            this.main.repaint();
        }
    }

    private void initComponents() {
        this.jPanel9 = new JPanel();
        this.CloseButton = new MyJButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.DispayOptions = new JPanel();
        this.jLabel1 = new JLabel();
        this.AMPMButton = new JRadioButton();
        this.MilitaryTimeButton = new JRadioButton();
        this.jLabel2 = new JLabel();
        this.DaylightHandling = new JComboBox();
        this.jLabel3 = new JLabel();
        this.MetersButton = new JRadioButton();
        this.FeetButton = new JRadioButton();
        this.TimeTideCheckBox = new JCheckBox();
        this.GridCheckBox = new JCheckBox();
        this.GridNumbersCheckBox = new JCheckBox();
        this.BackgroundCheckBox = new JCheckBox();
        this.SunTwilightCheckBox = new JCheckBox();
        this.LabelCheckBox = new JCheckBox();
        this.RiseSetDataCheckbox = new JCheckBox();
        this.TideCurrentListCheckBox = new JCheckBox();
        this.jLabel5 = new JLabel();
        this.jLabel4 = new JLabel();
        this.LookAndFeel = new JComboBox();
        this.DarkColorCheckBox = new JCheckBox();
        this.ThickLineCheckBox = new JCheckBox();
        this.BoldFontCheckBox = new JCheckBox();
        this.jLabel6 = new JLabel();
        this.TimeZoneBox = new JComboBox();
        this.DataOptions = new JPanel();
        this.htmlPanel = new JPanel();
        this.setTitle("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                TideConfiguration.this.closeDialog(windowEvent);
            }
        });
        this.CloseButton.setText("Close Options Dialog");
        this.CloseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TideConfiguration.this.OKButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel9.add(this.CloseButton);
        this.getContentPane().add((Component)this.jPanel9, "South");
        this.DispayOptions.setToolTipText("Chosen options take effect immediately");
        this.DispayOptions.setName("");
        this.DispayOptions.setLayout(new GridBagLayout());
        this.jLabel1.setText("Display Units");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.DispayOptions.add((Component)this.jLabel1, gridBagConstraints);
        this.AMPMButton.setText("AM/PM");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.DispayOptions.add((Component)this.AMPMButton, gridBagConstraints);
        this.MilitaryTimeButton.setText("24 Hour");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.DispayOptions.add((Component)this.MilitaryTimeButton, gridBagConstraints);
        this.jLabel2.setText("Display Time");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.DispayOptions.add((Component)this.jLabel2, gridBagConstraints);
        this.DaylightHandling.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                TideConfiguration.this.DaylightHandlingItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.DispayOptions.add((Component)this.DaylightHandling, gridBagConstraints);
        this.jLabel3.setText("Daylight Time Handling");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.DispayOptions.add((Component)this.jLabel3, gridBagConstraints);
        this.MetersButton.setText("Meters");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.DispayOptions.add((Component)this.MetersButton, gridBagConstraints);
        this.FeetButton.setText("Feet");
        this.FeetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TideConfiguration.this.jRadioButton4ActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.DispayOptions.add((Component)this.FeetButton, gridBagConstraints);
        this.TimeTideCheckBox.setText("Current Time/Tide Line");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.DispayOptions.add((Component)this.TimeTideCheckBox, gridBagConstraints);
        this.GridCheckBox.setText("Overlay Time/Height Grid");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.DispayOptions.add((Component)this.GridCheckBox, gridBagConstraints);
        this.GridNumbersCheckBox.setText("Grid Numbers");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.DispayOptions.add((Component)this.GridNumbersCheckBox, gridBagConstraints);
        this.BackgroundCheckBox.setText("White Background for Data ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.DispayOptions.add((Component)this.BackgroundCheckBox, gridBagConstraints);
        this.SunTwilightCheckBox.setText("Sun/Twilight Color Fill");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.DispayOptions.add((Component)this.SunTwilightCheckBox, gridBagConstraints);
        this.LabelCheckBox.setText("Site Data ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.DispayOptions.add((Component)this.LabelCheckBox, gridBagConstraints);
        this.RiseSetDataCheckbox.setText("Sunrise/set Data");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.DispayOptions.add((Component)this.RiseSetDataCheckbox, gridBagConstraints);
        this.TideCurrentListCheckBox.setText("Tide/Current Event List");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.DispayOptions.add((Component)this.TideCurrentListCheckBox, gridBagConstraints);
        this.jLabel5.setText("Other Options");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.DispayOptions.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel4.setText("Application Look & Feel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.DispayOptions.add((Component)this.jLabel4, gridBagConstraints);
        this.LookAndFeel.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                TideConfiguration.this.LookAndFeelItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.DispayOptions.add((Component)this.LookAndFeel, gridBagConstraints);
        this.DarkColorCheckBox.setText("Darker Sun Data Colors");
        this.DarkColorCheckBox.setToolTipText("Choose color shade for sun data");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.DispayOptions.add((Component)this.DarkColorCheckBox, gridBagConstraints);
        this.ThickLineCheckBox.setText("Thick Graphic Line");
        this.ThickLineCheckBox.setToolTipText("Thich tide/current curve line");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.DispayOptions.add((Component)this.ThickLineCheckBox, gridBagConstraints);
        this.BoldFontCheckBox.setText("Bold Chart Text");
        this.BoldFontCheckBox.setToolTipText("For more contrast in display and printing");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.DispayOptions.add((Component)this.BoldFontCheckBox, gridBagConstraints);
        this.jLabel6.setText("Time Zone");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.DispayOptions.add((Component)this.jLabel6, gridBagConstraints);
        this.TimeZoneBox.setMaximumRowCount(14);
        this.TimeZoneBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                TideConfiguration.this.TimeZoneBoxItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.DispayOptions.add((Component)this.TimeZoneBox, gridBagConstraints);
        this.jTabbedPane1.addTab("jPanel4", null, this.DispayOptions, "");
        this.DataOptions.setLayout(new BorderLayout());
        this.jTabbedPane1.addTab("jPanel6", null, this.DataOptions, "");
        this.htmlPanel.setLayout(new BorderLayout());
        this.jTabbedPane1.addTab("tab3", this.htmlPanel);
        this.getContentPane().add((Component)this.jTabbedPane1, "Center");
    }

    private void TimeZoneBoxItemStateChanged(ItemEvent itemEvent) {
        if (this.allowWrites) {
            this.changeTimeZone();
            this.main.repaint();
        }
    }

    private void LookAndFeelItemStateChanged(ItemEvent itemEvent) {
        if (this.allowWrites) {
            this.main.tideComp.setupLookAndFeel(this.LookAndFeel.getSelectedIndex());
        }
    }

    private void OKButtonActionPerformed(ActionEvent actionEvent) {
        this.testCloseDialog();
    }

    private void DaylightHandlingItemStateChanged(ItemEvent itemEvent) {
        if (this.allowWrites) {
            this.main.configValues.daylightTime = this.DaylightHandling.getSelectedIndex();
            this.main.repaint();
        }
    }

    private void jRadioButton4ActionPerformed(ActionEvent actionEvent) {
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.testCloseDialog();
    }

    private void testCloseDialog() {
        if (!this.dataBase.writingDatabase) {
            this.setVisible(false);
            this.dispose();
        } else {
            Toolkit.getDefaultToolkit().beep();
            JOptionPane.showMessageDialog(null, "Cannot close this dialog while\nwriting database. You must\ncancel the operation first.", "Cannot Close Dialog", 0);
            this.jTabbedPane1.setSelectedIndex(1);
        }
    }
}

