/*
 * Decompiled with CFR 0.152.
 */
package jtides;

import java.awt.event.KeyEvent;
import java.util.Date;
import java.util.Vector;
import javax.swing.JTabbedPane;
import jtides.JTides;
import jtides.TidesDoc;

public class TabbedPaneManager {
    JTabbedPane tabbedPane;
    JTides main;

    public TabbedPaneManager(JTabbedPane jTabbedPane, JTides jTides) {
        this.tabbedPane = jTabbedPane;
        this.main = jTides;
    }

    public void addTab(String string, boolean bl) {
        int n;
        TidesDoc tidesDoc = null;
        boolean bl2 = false;
        int n2 = this.tabbedPane.getTabCount();
        for (n = 0; n < n2; ++n) {
            TidesDoc tidesDoc2 = (TidesDoc)this.tabbedPane.getComponentAt(n);
            if (!string.equals(tidesDoc2.siteSet.fullName)) continue;
            bl2 = true;
            break;
        }
        if (bl2) {
            tidesDoc = (TidesDoc)this.tabbedPane.getComponentAt(n);
        } else {
            tidesDoc = string.equals("Site Explorer") ? this.main.openSiteExplorer() : (string.equals("Help Browser") ? this.main.openHelpBrowser() : new TidesDoc(this.main, 0, string, true, true, true, true));
            this.tabbedPane.addTab(tidesDoc.siteSet.shortName, tidesDoc);
            n = this.tabbedPane.indexOfComponent(tidesDoc);
            if (n != -1) {
                this.tabbedPane.setToolTipTextAt(n, tidesDoc.siteSet.name);
            }
        }
        if (bl) {
            this.tabbedPane.setSelectedComponent(tidesDoc);
            tidesDoc.requestFocusInWindow();
        }
        this.refreshTitle();
        this.main.recentFileList.put(new Date().getTime() / 1000L, tidesDoc.siteSet.name, tidesDoc.siteSet.fullName);
    }

    public void refocus() {
        TidesDoc tidesDoc = (TidesDoc)this.tabbedPane.getSelectedComponent();
        if (tidesDoc != null) {
            this.refreshTitle();
            this.tabbedPane.setSelectedComponent(tidesDoc);
            tidesDoc.requestFocusInWindow();
        }
    }

    public void moveToNextWindow() {
        this.main.setActiveMenu(null);
        int n = this.tabbedPane.getTabCount();
        int n2 = this.tabbedPane.getSelectedIndex();
        if (n > 0 && n2 >= 0) {
            n2 = (n2 + 1) % n;
            this.tabbedPane.setSelectedIndex(n2);
            this.refocus();
        }
    }

    public void close() {
        TidesDoc tidesDoc = (TidesDoc)this.tabbedPane.getSelectedComponent();
        if (tidesDoc != null) {
            this.tabbedPane.remove(tidesDoc);
        }
        this.refreshTitle();
    }

    public void closeAll() {
        int n = this.tabbedPane.getTabCount();
        for (int i = n - 1; i >= 0; --i) {
            TidesDoc tidesDoc = (TidesDoc)this.tabbedPane.getComponentAt(i);
            if (tidesDoc == null) continue;
            this.tabbedPane.remove(tidesDoc);
        }
        this.refreshTitle();
    }

    public Vector getList() {
        Vector<String> vector = new Vector<String>();
        int n = this.tabbedPane.getTabCount();
        for (int i = 0; i < n; ++i) {
            TidesDoc tidesDoc = (TidesDoc)this.tabbedPane.getComponentAt(i);
            String string = tidesDoc.siteSet.fullName;
            vector.add(string);
        }
        return vector;
    }

    public TidesDoc getSelectedDoc() {
        return (TidesDoc)this.tabbedPane.getSelectedComponent();
    }

    public int getSelectedIndex() {
        return this.tabbedPane.getSelectedIndex();
    }

    public void setSelectedIndex(int n) {
        if (n >= 0 && n < this.tabbedPane.getTabCount()) {
            this.tabbedPane.setSelectedIndex(n);
        }
    }

    public void handleKey(KeyEvent keyEvent) {
        TidesDoc tidesDoc = this.getSelectedDoc();
        if (tidesDoc != null) {
            tidesDoc.handleKey(keyEvent);
        }
    }

    public int getTabCount() {
        return this.tabbedPane.getTabCount();
    }

    public void refreshTitle() {
        String string = "JTides 5.3";
        TidesDoc tidesDoc = this.getSelectedDoc();
        if (tidesDoc != null && tidesDoc.type == 0) {
            string = string + " / " + tidesDoc.getTitleString();
        }
        this.main.setTitle(string);
    }
}

