/*
 * Decompiled with CFR 0.152.
 */
package jtides;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import jtides.JTides;

public final class RecentFileList {
    public TreeMap list = new TreeMap();
    private int max;
    private int insertPoint;
    private JTides main;
    JPopupMenu menu;

    public RecentFileList(JTides jTides, int n, JPopupMenu jPopupMenu) {
        this.main = jTides;
        this.max = n;
        this.menu = jPopupMenu;
        this.insertPoint = jPopupMenu.getComponentCount();
    }

    public void clear() {
        this.list.clear();
        while (this.menu.getComponentCount() - this.insertPoint > 0) {
            this.menu.remove(this.insertPoint);
        }
    }

    public void put(long l, String string, String string2) {
        Object object;
        if (this.list.containsKey(string)) {
            object = (SiteDat)this.list.get(string);
            ((SiteDat)object).time = l;
        } else {
            this.list.put(string, new SiteDat(l, string, string2));
        }
        object = this.list.keySet().iterator();
        for (int i = 0; i < this.list.size(); ++i) {
            JMenuItem jMenuItem;
            SiteDat siteDat = (SiteDat)this.list.get(object.next());
            if (i < this.menu.getComponentCount() - this.insertPoint) {
                jMenuItem = (JMenuItem)this.menu.getComponent(i + this.insertPoint);
                jMenuItem.setText(siteDat.name);
                continue;
            }
            jMenuItem = new JMenuItem(siteDat.name);
            this.menu.add(jMenuItem);
            this.addListener(jMenuItem);
        }
        if (this.list.size() > this.max) {
            this.deleteOldestMember();
        }
    }

    public Vector getVec() {
        Vector<String> vector = new Vector<String>();
        Iterator iterator = this.list.keySet().iterator();
        while (iterator.hasNext()) {
            SiteDat siteDat = (SiteDat)this.list.get(iterator.next());
            String string = siteDat.fullName + "\t" + siteDat.time;
            vector.add(string);
        }
        return vector;
    }

    public String getString() {
        Vector vector = this.getVec();
        String string = this.main.tideComp.mergeDelimLine(vector, "|");
        return string;
    }

    public void putAll(String string) {
        Vector vector = this.main.tideComp.parseDelimLine(string, "|");
        for (int i = 0; i < vector.size(); ++i) {
            Vector vector2 = this.main.tideComp.parseDelimLine((String)vector.elementAt(i), "\t");
            if (vector2.size() <= 9) continue;
            long l = Long.parseLong((String)vector2.elementAt(9));
            vector2.removeElementAt(9);
            String string2 = this.main.tideComp.mergeDelimLine(vector2, "\t");
            String string3 = (String)vector2.elementAt(3);
            this.put(l, string3, string2);
        }
    }

    private void deleteOldestMember() {
        Iterator iterator = this.list.keySet().iterator();
        String string = null;
        long l = Long.MAX_VALUE;
        while (iterator.hasNext()) {
            SiteDat siteDat = (SiteDat)this.list.get(iterator.next());
            if (siteDat.time >= l) continue;
            l = siteDat.time;
            string = siteDat.name;
        }
        if (string != null) {
            this.list.remove(string);
        }
    }

    private void addListener(JMenuItem jMenuItem) {
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RecentFileList.this.menuActionPerformed(actionEvent);
            }
        });
    }

    private void menuActionPerformed(ActionEvent actionEvent) {
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        SiteDat siteDat = (SiteDat)this.list.get(jMenuItem.getText());
        this.main.openFile(siteDat.fullName, true);
    }

    final class SiteDat {
        public long time;
        public String name;
        public String fullName;

        SiteDat(long l, String string, String string2) {
            this.time = l;
            this.name = string;
            this.fullName = string2;
        }
    }
}

