/*
 * Decompiled with CFR 0.152.
 */
package jtides;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.SortedSet;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import jtides.ConfigValues;
import jtides.InitFileHandler;
import jtides.MyJButton;
import jtides.NonModalDialog;
import jtides.RecentFileList;
import jtides.SunComp;
import jtides.TabbedPaneManager;
import jtides.TideComp;
import jtides.TideConfiguration;
import jtides.TideConstants;
import jtides.TidesDoc;
import jtides.TidesFindNearest;

public final class JTides
extends JFrame {
    boolean appInstalled = false;
    public static final String programName = "JTides 5.4";
    public static final String buildNumber = "382";
    private static final String requiredJavaVersion = "1.6.0";
    public static final String indexName = "JTidesData.index";
    public static final String dataDirName = "JTidesData";
    public static final String userDirName = ".JTides";
    public static final String helpBrowserName = "Help Browser";
    public static final String siteExplorerName = "Site Explorer";
    public static int updateIntervalMillis = 15000;
    public static int returnToCurrentTimeDelayMillis = 600000;
    String configPath;
    Dimension screenSize;
    Dimension appSize;
    Timer timer;
    public ConfigValues configValues;
    public InitFileHandler initFileHandler;
    public String appDir;
    public String userHome;
    public String basePath;
    public ImageIcon frameIcon;
    public TidesDoc currentFinder = null;
    public TidesDoc currentHelpBrowser = null;
    public TidesDoc currentSelectedFrame = null;
    public JPopupMenu activeMenu = null;
    TideComp tideComp;
    SunComp sunComp;
    RecentFileList recentFileList;
    Clipboard clipboard;
    TabbedPaneManager tabbedPaneManager;
    NonModalDialog installDialog = null;
    private JButton BackDayButton;
    private JButton BackMonthButton;
    private JButton BackYearButton;
    private JPanel Bottom_Panel;
    private JButton CalendarButton;
    private JMenuItem ClearSiteList;
    private JMenuItem Close;
    private JMenuItem CloseAll;
    private JButton Configure;
    private JMenuItem ConfigureMenuItem;
    private JButton Decrease;
    private JMenuItem Exit;
    private JButton FindNearestButton;
    private JButton ForwardDayButton;
    private JButton ForwardMonthButton;
    private JButton ForwardYearButton;
    private JButton HelpButton;
    private JButton HomeButton;
    private JButton Increase;
    private JMenuItem NearestSitesMenuItem;
    private JButton OneDay;
    private JButton OneMonth;
    private JButton OneMonthSmooth;
    private JMenuItem OpenMenuItem;
    private JButton OpenSelector;
    private JButton Print;
    private JMenuItem PrintMenuItem;
    private JToolBar Toolbar;
    private JButton aboutButton;
    private JMenuItem aboutMenuItem;
    private JPopupMenu filePopupMenu;
    private JMenuItem helpMenuItem1;
    private JProgressBar jProgressBar1;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JSeparator jSeparator6;
    public JSeparator jSeparator7;
    private JSeparator jSeparator9;
    private JButton siteMenuButton;
    private JLabel statusBar;
    private JTabbedPane tabbedPane;

    public JTides() {
        this.testJavaVersion();
        this.userHome = System.getProperty("user.home");
        this.basePath = this.userHome + TideConstants.SYSTEM_FILESEP + userDirName;
        this.screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.tideComp = new TideComp(this);
        this.appDir = this.locateAppDir();
        this.sunComp = new SunComp(this);
        this.configValues = new ConfigValues();
        this.configPath = this.basePath + TideConstants.SYSTEM_FILESEP + "JTides.ini";
        this.initFileHandler = new InitFileHandler(this.configPath);
        this.initFileHandler.read(this.configValues);
        this.setTitle(programName);
        this.initComponents();
        this.tabbedPaneManager = new TabbedPaneManager(this.tabbedPane, this);
        String string = TideConstants.barPositions[this.configValues.toolBarPosition];
        this.getContentPane().add((Component)this.Toolbar, string);
        this.Toolbar.setOrientation(this.configValues.toolBarPosition % 2 == 0 ? 0 : 1);
        this.pack();
        this.setSize(this.screenSize.width * 3 / 4, this.screenSize.height * 3 / 4);
        this.setLocation(this.screenSize.width / 8, this.screenSize.height / 8);
        this.setVisible(true);
        this.frameIcon = new ImageIcon(this.getClass().getResource("icons/JTides.png"));
        this.setIconImage(this.frameIcon.getImage());
        this.recentFileList = new RecentFileList(this, this.configValues.recentListSize, this.filePopupMenu);
        this.tideComp.setupLookAndFeel(this.configValues.LookAndFeel);
        this.statusBar.setFont(new Font("Monospaced", 0, this.statusBar.getFont().getSize()));
        this.unpackJarTest(this.appDir, "JTides.jar", dataDirName, this.basePath);
        this.initPhase2();
    }

    public void initPhase2() {
        if (this.installDialog != null) {
            this.installDialog.setVisible(false);
            this.installDialog.dispose();
        }
        this.recentFileList.putAll(this.configValues.recentSiteList);
        if (this.tideComp.indexValid) {
            this.openFileList(this.configValues.openSites, true);
            this.tabbedPaneManager.setSelectedIndex(this.configValues.selectedSite);
            this.tabbedPaneManager.refocus();
        } else {
            this.regenerateIndex(true);
        }
        this.setupTimer();
    }

    private void testJavaVersion() {
        boolean bl;
        String string = System.getProperty("java.version");
        boolean bl2 = bl = this.convertVersionString(string) >= this.convertVersionString(requiredJavaVersion);
        if (!bl) {
            JOptionPane.showMessageDialog(this, "Very Sorry!\n\nJTides 5.4 requires a Java runtime engine (JRE)\nwith a version of 1.6.0 or better.\nThis machine has a version " + string + " JRE.\nPlease acquire the correct JRE at http://java.com.", "Wrong Java Runtime Version", 2);
            System.exit(0);
        }
    }

    private int convertVersionString(String string) {
        try {
            int n;
            int n2;
            int n3 = string.length();
            for (n2 = 0; n2 < n3 && !Character.isDigit(string.charAt(n2)); ++n2) {
            }
            StringBuffer stringBuffer = new StringBuffer();
            char c = ' ';
            while (true) {
                block10: {
                    block9: {
                        if (n2 >= n3) break block9;
                        char c2 = string.charAt(n2);
                        c = c2;
                        if (Character.isDigit(c2)) break block10;
                    }
                    if (c != 46) break;
                }
                if (Character.isDigit(c)) {
                    stringBuffer.append(c);
                }
                ++n2;
            }
            for (n = Integer.parseInt(stringBuffer.toString()); n > 0 && n < 100; n *= 10) {
            }
            return n;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public void setActiveMenu(JPopupMenu jPopupMenu) {
        if (this.activeMenu != null) {
            this.activeMenu.setVisible(false);
        }
        this.activeMenu = jPopupMenu;
    }

    private void giveBackFocus(String string) {
        this.tabbedPaneManager.refocus();
    }

    private void giveBackFocus() {
        this.giveBackFocus("default");
    }

    private String locateAppDir() {
        String string;
        URL uRL = this.getClass().getResource("JTides.class");
        File file = new File(uRL.getPath());
        String string2 = file.getPath();
        int n = string2.lastIndexOf(TideConstants.SYSTEM_FILESEP);
        if (n != -1 && (n = (string2 = string2.substring(0, n)).lastIndexOf(".jar")) != -1 && (n = string2.lastIndexOf(TideConstants.SYSTEM_FILESEP, n)) != -1) {
            string2 = string2.substring(0, n);
        }
        if ((n = string2.indexOf(string = "file:")) != -1) {
            string2 = string2.substring(n + string.length());
        }
        string2 = this.tideComp.srchRplc(string2, "%20", " ");
        return string2;
    }

    public void regenerateIndex(boolean bl) {
        this.indexInit(this.configValues.openSites, bl);
    }

    private void setupTimer() {
        this.timer = new Timer(updateIntervalMillis, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (JTides.this.isVisible()) {
                    JTides.this.repaint();
                }
                if (JTides.this.appInstalled) {
                    if (JTides.this.installDialog != null) {
                        JTides.this.installDialog.dispose();
                    }
                    JTides.this.appInstalled = false;
                }
            }
        });
        this.timer.start();
    }

    public void unpackJarTest(final String string, final String string2, final String string3, final String string4) {
        this.appInstalled = false;
        Thread thread = new Thread(){

            @Override
            public void run() {
                JTides.this.unpackJarTestThread(string, string2, string3, string4);
            }
        };
        thread.start();
        try {
            thread.join();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.initPhase2();
    }

    public void unpackJarTestThread(String string, String string2, String string3, String string4) {
        try {
            File file = new File(string4);
            if (!file.exists()) {
                this.installDialog = new NonModalDialog((Frame)this, "Preparing JTides 5.4 for use on\nyour system. Please stand by.", "JTides 5.4 Data File Preparation", false);
                Dimension dimension = this.installDialog.getSize();
                this.installDialog.setLocation((this.screenSize.width - dimension.width) / 2, (this.screenSize.height - dimension.height) / 2);
                this.installDialog.setVisible(true);
                file.mkdir();
                String string5 = string + TideConstants.SYSTEM_FILESEP + string2;
                ZipFile zipFile = new ZipFile(string5);
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                while (enumeration.hasMoreElements()) {
                    ZipEntry zipEntry = enumeration.nextElement();
                    String string6 = zipEntry.toString();
                    if (!string6.endsWith(".txt") && !string6.endsWith(".xxx") || !string6.startsWith(dataDirName)) continue;
                    int n = string6.lastIndexOf("/");
                    string6 = string6.substring(n + 1);
                    String string7 = string4 + TideConstants.SYSTEM_FILESEP + string6;
                    this.copyFile(zipFile, zipEntry, string7);
                }
                zipFile.close();
                this.appInstalled = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void copyFile(ZipFile zipFile, ZipEntry zipEntry, String string) {
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
            int n = bufferedInputStream.available();
            this.startProgressBar("Program Installation: processing " + string, 0L, n, 0L);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(new File(string)));
            int n2 = 2048;
            byte[] byArray = new byte[n2];
            int n3 = 0;
            while ((n = bufferedInputStream.read(byArray, 0, n2)) != -1) {
                this.updateProgressBar(n3);
                bufferedOutputStream.write(byArray, 0, n);
                n3 += n;
            }
            bufferedInputStream.close();
            bufferedOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.stopProgressBar();
    }

    public void openFileList(String string, boolean bl) {
        string = string.trim();
        if (!this.tideComp.indexReplaced) {
            if (string.length() > 0) {
                Vector vector = this.tideComp.parseDelimLine(string, "|");
                for (int i = 0; i < vector.size(); ++i) {
                    String string2 = (String)vector.elementAt(i);
                    this.openFile(string2, false);
                }
            } else if (bl) {
                this.openFileOnPartialPath(this.configValues.defaultOpenSite);
            }
        } else {
            this.recentFileList.clear();
            this.configValues.openSites = "";
            this.openFileOnPartialPath(this.configValues.defaultOpenSite);
        }
        this.tideComp.indexReplaced = false;
    }

    public void openFileOnPartialPath(String string) {
        SortedSet<String> sortedSet = this.tideComp.siteIndex.tailSet(string);
        if (sortedSet != null) {
            String string2 = sortedSet.first();
            this.openFile(string2, true);
        }
    }

    public void updateStatusBar(String string) {
        this.statusBar.setText(string);
        if (this.statusBar.isVisible()) {
            this.statusBar.validate();
        }
    }

    public void startProgressBar(String string, long l, long l2, long l3) {
        this.updateStatusBar(string);
        this.jProgressBar1.setStringPainted(true);
        this.jProgressBar1.setMinimum((int)l);
        this.jProgressBar1.setMaximum((int)l2);
        this.jProgressBar1.setValue((int)l2);
    }

    public void updateProgressBar(long l) {
        if (l % 10L == 0L) {
            this.jProgressBar1.setValue((int)l);
        }
    }

    public void stopProgressBar() {
        this.jProgressBar1.setValue(this.jProgressBar1.getMinimum());
        this.jProgressBar1.setStringPainted(false);
        this.updateStatusBar("Done (F1 = Help)");
    }

    private void lfActionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        try {
            UIManager.setLookAndFeel(string);
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void showAboutDialog() {
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("icons/Me_nautical_tiny.jpg"));
        String string = "<HTML><BODY><FONT color=\"#000000\">JTides 5.4 build 382<p>is copyright 2024, P. Lutus.<p>Please visit the JTides Home Page<p>at <font color=#0000ff>www.arachnoid.com/JTides</font>.<p>Please read about CareWare<p>at <font color=#0000ff>www.arachnoid.com/careware</font>.</FONT></BODY></HTML>";
        JOptionPane.showMessageDialog(this, string, "About JTides 5.4", 1, imageIcon);
    }

    private void initComponents() {
        this.filePopupMenu = new JPopupMenu();
        this.OpenMenuItem = new JMenuItem();
        this.Close = new JMenuItem();
        this.CloseAll = new JMenuItem();
        this.PrintMenuItem = new JMenuItem();
        this.NearestSitesMenuItem = new JMenuItem();
        this.ConfigureMenuItem = new JMenuItem();
        this.jSeparator9 = new JSeparator();
        this.helpMenuItem1 = new JMenuItem();
        this.aboutMenuItem = new JMenuItem();
        this.Exit = new JMenuItem();
        this.ClearSiteList = new JMenuItem();
        this.jSeparator7 = new JSeparator();
        this.Toolbar = new JToolBar();
        this.siteMenuButton = new MyJButton();
        this.jSeparator6 = new JSeparator();
        this.OpenSelector = new MyJButton();
        this.Print = new MyJButton();
        this.Configure = new MyJButton();
        this.FindNearestButton = new MyJButton();
        this.jSeparator3 = new JSeparator();
        this.BackYearButton = new MyJButton();
        this.BackMonthButton = new MyJButton();
        this.BackDayButton = new MyJButton();
        this.HomeButton = new MyJButton();
        this.ForwardDayButton = new MyJButton();
        this.ForwardMonthButton = new MyJButton();
        this.ForwardYearButton = new MyJButton();
        this.jSeparator4 = new JSeparator();
        this.OneDay = new MyJButton();
        this.Decrease = new MyJButton();
        this.Increase = new MyJButton();
        this.OneMonth = new MyJButton();
        this.OneMonthSmooth = new MyJButton();
        this.CalendarButton = new MyJButton();
        this.jSeparator5 = new JSeparator();
        this.HelpButton = new MyJButton();
        this.aboutButton = new MyJButton();
        this.Bottom_Panel = new JPanel();
        this.statusBar = new JLabel();
        this.jProgressBar1 = new JProgressBar();
        this.tabbedPane = new JTabbedPane();
        this.OpenMenuItem.setText("Open...");
        this.OpenMenuItem.setToolTipText("Open Site Explorer");
        this.OpenMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTides.this.OpenMenuItemActionPerformed(actionEvent);
            }
        });
        this.filePopupMenu.add(this.OpenMenuItem);
        this.Close.setText("Close");
        this.Close.setToolTipText("Close Displayed Site");
        this.Close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTides.this.CloseActionPerformed(actionEvent);
            }
        });
        this.filePopupMenu.add(this.Close);
        this.CloseAll.setText("Close All");
        this.CloseAll.setToolTipText("Close All Open Sites");
        this.CloseAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTides.this.CloseAllActionPerformed(actionEvent);
            }
        });
        this.filePopupMenu.add(this.CloseAll);
        this.PrintMenuItem.setText("Print...");
        this.PrintMenuItem.setToolTipText("Print Displayed Site");
        this.PrintMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTides.this.PrintMenuItemActionPerformed(actionEvent);
            }
        });
        this.filePopupMenu.add(this.PrintMenuItem);
        this.NearestSitesMenuItem.setText("Nearest Sites...");
        this.NearestSitesMenuItem.setToolTipText("Launch nearest sites dialog");
        this.NearestSitesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTides.this.NearestSitesMenuItemActionPerformed(actionEvent);
            }
        });
        this.filePopupMenu.add(this.NearestSitesMenuItem);
        this.ConfigureMenuItem.setText("Configure/Data...");
        this.ConfigureMenuItem.setToolTipText("Launch configuration dialog");
        this.ConfigureMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTides.this.ConfigureMenuItemActionPerformed(actionEvent);
            }
        });
        this.filePopupMenu.add(this.ConfigureMenuItem);
        this.filePopupMenu.add(this.jSeparator9);
        this.helpMenuItem1.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.helpMenuItem1.setText("Help");
        this.helpMenuItem1.setToolTipText("Launch help browser");
        this.helpMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTides.this.helpMenuItem1ActionPerformed(actionEvent);
            }
        });
        this.filePopupMenu.add(this.helpMenuItem1);
        this.aboutMenuItem.setText("About...");
        this.aboutMenuItem.setToolTipText("Information about JTides");
        this.aboutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTides.this.aboutMenuItemActionPerformed(actionEvent);
            }
        });
        this.filePopupMenu.add(this.aboutMenuItem);
        this.Exit.setText("Exit");
        this.Exit.setToolTipText("Exit this program");
        this.Exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTides.this.ExitActionPerformed(actionEvent);
            }
        });
        this.filePopupMenu.add(this.Exit);
        this.ClearSiteList.setText("Clear Site List");
        this.ClearSiteList.setToolTipText("Erase previously visited site list");
        this.ClearSiteList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTides.this.ClearSiteListActionPerformed(actionEvent);
            }
        });
        this.filePopupMenu.add(this.ClearSiteList);
        this.filePopupMenu.add(this.jSeparator7);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                JTides.this.formWindowActivated(windowEvent);
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                JTides.this.exitForm(windowEvent);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                JTides.this.formComponentResized(componentEvent);
            }
        });
        this.addContainerListener(new ContainerAdapter(){

            @Override
            public void componentRemoved(ContainerEvent containerEvent) {
                JTides.this.formComponentRemoved(containerEvent);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                JTides.this.formKeyPressed(keyEvent);
            }
        });
        this.Toolbar.setToolTipText("This toolbar can be floated and/or redocked");
        this.siteMenuButton.setText("Site Menu");
        this.siteMenuButton.setToolTipText("Site-related functions");
        this.siteMenuButton.setMargin(new Insets(2, 4, 2, 4));
        this.siteMenuButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                JTides.this.menuButtonMouseClicked(mouseEvent);
            }
        });
        this.Toolbar.add(this.siteMenuButton);
        this.jSeparator6.setOrientation(1);
        this.Toolbar.add(this.jSeparator6);
        this.OpenSelector.setIcon(new ImageIcon(this.getClass().getResource("/jtides/icons/Folder.png")));
        this.OpenSelector.setToolTipText("Open site explorer");
        this.OpenSelector.setActionCommand("Open");
        this.OpenSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTides.this.OpenSelectorActionPerformed(actionEvent);
            }
        });
        this.Toolbar.add(this.OpenSelector);
        this.Print.setIcon(new ImageIcon(this.getClass().getResource("/jtides/icons/Print.png")));
        this.Print.setToolTipText("Print displayed chart");
        this.Print.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTides.this.PrintActionPerformed(actionEvent);
            }
        });
        this.Toolbar.add(this.Print);
        this.Configure.setIcon(new ImageIcon(this.getClass().getResource("/jtides/icons/DocumentMag.png")));
        this.Configure.setToolTipText("Configuration/Database dialog");
        this.Configure.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTides.this.ConfigureActionPerformed(actionEvent);
            }
        });
        this.Toolbar.add(this.Configure);
        this.FindNearestButton.setIcon(new ImageIcon(this.getClass().getResource("/jtides/icons/World2.png")));
        this.FindNearestButton.setToolTipText("Find nearest sites");
        this.FindNearestButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTides.this.FindNearestButtonActionPerformed(actionEvent);
            }
        });
        this.Toolbar.add(this.FindNearestButton);
        this.jSeparator3.setOrientation(1);
        this.Toolbar.add(this.jSeparator3);
        this.BackYearButton.setIcon(new ImageIcon(this.getClass().getResource("/jtides/icons/Left.png")));
        this.BackYearButton.setToolTipText("Back 1 year (Page Up key)");
        this.BackYearButton.setFocusable(false);
        this.BackYearButton.setHorizontalTextPosition(0);
        this.BackYearButton.setVerticalTextPosition(3);
        this.BackYearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTides.this.BackYearButtonActionPerformed(actionEvent);
            }
        });
        this.Toolbar.add(this.BackYearButton);
        this.BackMonthButton.setIcon(new ImageIcon(this.getClass().getResource("/jtides/icons/VCRRewind.png")));
        this.BackMonthButton.setToolTipText("Back 1 month (Up Arrow key)");
        this.BackMonthButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTides.this.BackMonthButtonActionPerformed(actionEvent);
            }
        });
        this.Toolbar.add(this.BackMonthButton);
        this.BackDayButton.setIcon(new ImageIcon(this.getClass().getResource("/jtides/icons/VCRBack.png")));
        this.BackDayButton.setToolTipText("Back 1 day (Left Arrow key)");
        this.BackDayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTides.this.BackDayButtonActionPerformed(actionEvent);
            }
        });
        this.Toolbar.add(this.BackDayButton);
        this.HomeButton.setIcon(new ImageIcon(this.getClass().getResource("/jtides/icons/VCRStop.png")));
        this.HomeButton.setToolTipText("Today (Home key)");
        this.HomeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTides.this.HomeButtonActionPerformed(actionEvent);
            }
        });
        this.Toolbar.add(this.HomeButton);
        this.ForwardDayButton.setIcon(new ImageIcon(this.getClass().getResource("/jtides/icons/VCRForward.png")));
        this.ForwardDayButton.setToolTipText("Forward 1 day (Right Arrow key)");
        this.ForwardDayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTides.this.ForwardDayButtonActionPerformed(actionEvent);
            }
        });
        this.Toolbar.add(this.ForwardDayButton);
        this.ForwardMonthButton.setIcon(new ImageIcon(this.getClass().getResource("/jtides/icons/VCRFastForward.png")));
        this.ForwardMonthButton.setToolTipText("Forward 1 month (Down Arrow key)");
        this.ForwardMonthButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTides.this.ForwardMonthButtonActionPerformed(actionEvent);
            }
        });
        this.Toolbar.add(this.ForwardMonthButton);
        this.ForwardYearButton.setIcon(new ImageIcon(this.getClass().getResource("/jtides/icons/Right.png")));
        this.ForwardYearButton.setToolTipText("Forward 1 year (Page Down key)");
        this.ForwardYearButton.setFocusable(false);
        this.ForwardYearButton.setHorizontalTextPosition(0);
        this.ForwardYearButton.setVerticalTextPosition(3);
        this.ForwardYearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTides.this.ForwardYearButtonActionPerformed(actionEvent);
            }
        });
        this.Toolbar.add(this.ForwardYearButton);
        this.jSeparator4.setOrientation(1);
        this.Toolbar.add(this.jSeparator4);
        this.OneDay.setIcon(new ImageIcon(this.getClass().getResource("/jtides/icons/Magnify.png")));
        this.OneDay.setToolTipText("1 Day chart");
        this.OneDay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTides.this.OneDayActionPerformed(actionEvent);
            }
        });
        this.Toolbar.add(this.OneDay);
        this.Decrease.setIcon(new ImageIcon(this.getClass().getResource("/jtides/icons/MagnifyMinus.png")));
        this.Decrease.setToolTipText("Decrease chart time");
        this.Decrease.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTides.this.DecreaseActionPerformed(actionEvent);
            }
        });
        this.Toolbar.add(this.Decrease);
        this.Increase.setIcon(new ImageIcon(this.getClass().getResource("/jtides/icons/MagnifyPlus.png")));
        this.Increase.setToolTipText("Increase chart time");
        this.Increase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTides.this.IncreaseActionPerformed(actionEvent);
            }
        });
        this.Toolbar.add(this.Increase);
        this.OneMonth.setIcon(new ImageIcon(this.getClass().getResource("/jtides/icons/InitProject.png")));
        this.OneMonth.setToolTipText("Clickable 30/60 day color chart");
        this.OneMonth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTides.this.OneMonthActionPerformed(actionEvent);
            }
        });
        this.Toolbar.add(this.OneMonth);
        this.OneMonthSmooth.setIcon(new ImageIcon(this.getClass().getResource("/jtides/icons/Palette.png")));
        this.OneMonthSmooth.setToolTipText("Clickable smooth 30/60 day chart (draws slower)");
        this.OneMonthSmooth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTides.this.OneMonthSmoothActionPerformed(actionEvent);
            }
        });
        this.Toolbar.add(this.OneMonthSmooth);
        this.CalendarButton.setIcon(new ImageIcon(this.getClass().getResource("/jtides/icons/Document.png")));
        this.CalendarButton.setToolTipText("Calendar for current month");
        this.CalendarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTides.this.CalendarActionPerformed(actionEvent);
            }
        });
        this.Toolbar.add(this.CalendarButton);
        this.jSeparator5.setOrientation(1);
        this.Toolbar.add(this.jSeparator5);
        this.HelpButton.setIcon(new ImageIcon(this.getClass().getResource("/jtides/icons/Help.png")));
        this.HelpButton.setToolTipText(helpBrowserName);
        this.HelpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTides.this.HelpButtonActionPerformed(actionEvent);
            }
        });
        this.Toolbar.add(this.HelpButton);
        this.aboutButton.setIcon(new ImageIcon(this.getClass().getResource("/jtides/icons/Options.png")));
        this.aboutButton.setToolTipText("About JTides");
        this.aboutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTides.this.aboutButtonActionPerformed(actionEvent);
            }
        });
        this.Toolbar.add(this.aboutButton);
        this.getContentPane().add((Component)this.Toolbar, "North");
        this.Bottom_Panel.setFocusable(false);
        this.Bottom_Panel.setLayout(new BorderLayout());
        this.statusBar.setHorizontalAlignment(2);
        this.statusBar.setText("Status Area");
        this.statusBar.setToolTipText("Operation Status");
        this.Bottom_Panel.add((Component)this.statusBar, "Center");
        this.jProgressBar1.setToolTipText("Event Progress");
        this.jProgressBar1.setMinimumSize(new Dimension(10, 22));
        this.jProgressBar1.setName("Progress Bar");
        this.jProgressBar1.setPreferredSize(new Dimension(148, 22));
        this.jProgressBar1.setStringPainted(true);
        this.Bottom_Panel.add((Component)this.jProgressBar1, "East");
        this.getContentPane().add((Component)this.Bottom_Panel, "South");
        this.tabbedPane.setTabPlacement(3);
        this.tabbedPane.setToolTipText("Click here for Site Explorer");
        this.tabbedPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                JTides.this.tabbedPaneMouseClicked(mouseEvent);
            }
        });
        this.tabbedPane.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                JTides.this.tabbedPaneFocusGained(focusEvent);
            }
        });
        this.getContentPane().add((Component)this.tabbedPane, "Center");
    }

    private void aboutButtonActionPerformed(ActionEvent actionEvent) {
        this.showAboutDialog();
    }

    private void tabbedPaneMouseClicked(MouseEvent mouseEvent) {
        if (this.tabbedPaneManager.getTabCount() == 0) {
            this.openFile(siteExplorerName, true);
        } else {
            this.tabbedPaneManager.refocus();
        }
    }

    private void tabbedPaneFocusGained(FocusEvent focusEvent) {
        this.tabbedPaneManager.refocus();
    }

    private void formKeyPressed(KeyEvent keyEvent) {
    }

    private void helpMenuItem1ActionPerformed(ActionEvent actionEvent) {
        this.openFile(helpBrowserName, true);
        this.giveBackFocus();
    }

    private void formComponentRemoved(ContainerEvent containerEvent) {
        this.myExit();
    }

    private void aboutMenuItemActionPerformed(ActionEvent actionEvent) {
        this.showAboutDialog();
    }

    private void NearestSitesMenuItemActionPerformed(ActionEvent actionEvent) {
        TidesFindNearest tidesFindNearest = new TidesFindNearest((Frame)this, false);
        this.giveBackFocus();
    }

    private void ConfigureMenuItemActionPerformed(ActionEvent actionEvent) {
        this.launchConfiguration();
        this.giveBackFocus();
    }

    private void OpenMenuItemActionPerformed(ActionEvent actionEvent) {
        this.openFile(siteExplorerName, true);
        this.giveBackFocus();
    }

    private void menuButtonMouseClicked(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        Point point = component.getLocation();
        this.filePopupMenu.show(this.Toolbar, point.x, point.y + component.getSize().height);
        this.giveBackFocus();
    }

    private void PrintMenuItemActionPerformed(ActionEvent actionEvent) {
        TidesDoc tidesDoc = this.currentSelectedFrame;
        if (tidesDoc != null) {
            tidesDoc.panel.doPrint();
        }
        this.giveBackFocus();
    }

    private void OneMonthSmoothActionPerformed(ActionEvent actionEvent) {
        if (this.isChartType(false) || this.getChartWidth() != 30) {
            this.setChartWidth(30, true);
        } else {
            this.setChartWidth(60, true);
        }
    }

    private void HelpButtonActionPerformed(ActionEvent actionEvent) {
        this.openFile(helpBrowserName, true);
        this.giveBackFocus();
    }

    private void FindNearestButtonActionPerformed(ActionEvent actionEvent) {
        TidesFindNearest tidesFindNearest = new TidesFindNearest((Frame)this, false);
        this.giveBackFocus();
    }

    private void CalendarActionPerformed(ActionEvent actionEvent) {
        this.setChartWidth(-2);
    }

    private int getChartWidth() {
        TidesDoc tidesDoc = this.currentSelectedFrame;
        if (tidesDoc != null && tidesDoc.type == 0) {
            return tidesDoc.panel.graphWidth;
        }
        return 0;
    }

    private boolean isChartType(boolean bl) {
        TidesDoc tidesDoc = this.currentSelectedFrame;
        if (tidesDoc != null && tidesDoc.type == 0) {
            return tidesDoc.panel.smoothGraph == bl;
        }
        return false;
    }

    private void setChartWidth(int n) {
        TidesDoc tidesDoc = this.currentSelectedFrame;
        if (tidesDoc != null && tidesDoc.type == 0) {
            tidesDoc.panel.setChartWidth(n);
            tidesDoc.newDisplay();
        }
        this.giveBackFocus();
    }

    private void setChartWidth(int n, boolean bl) {
        TidesDoc tidesDoc = this.currentSelectedFrame;
        if (tidesDoc != null && tidesDoc.type == 0) {
            tidesDoc.panel.setChartWidth(n);
            tidesDoc.panel.smoothGraph = bl;
            tidesDoc.newDisplay();
        }
        this.giveBackFocus();
    }

    private void OneMonthActionPerformed(ActionEvent actionEvent) {
        if (this.isChartType(true) || this.getChartWidth() != 30) {
            this.setChartWidth(30, false);
        } else {
            this.setChartWidth(60, false);
        }
    }

    private void IncreaseActionPerformed(ActionEvent actionEvent) {
        this.setChartWidth(1);
    }

    private void DecreaseActionPerformed(ActionEvent actionEvent) {
        this.setChartWidth(-1);
    }

    private void OneDayActionPerformed(ActionEvent actionEvent) {
        this.setChartWidth(0);
    }

    private void ExitActionPerformed(ActionEvent actionEvent) {
        this.myExit();
    }

    private void ClearSiteListActionPerformed(ActionEvent actionEvent) {
        this.recentFileList.clear();
        this.giveBackFocus();
    }

    private void ForwardMonthButtonActionPerformed(ActionEvent actionEvent) {
        this.moveTime(2, 1);
    }

    private void ForwardDayButtonActionPerformed(ActionEvent actionEvent) {
        this.moveTime(5, 1);
    }

    private void HomeButtonActionPerformed(ActionEvent actionEvent) {
        this.moveTime(0, 0);
    }

    private void BackDayButtonActionPerformed(ActionEvent actionEvent) {
        this.moveTime(5, -1);
    }

    private void BackMonthButtonActionPerformed(ActionEvent actionEvent) {
        this.moveTime(2, -1);
    }

    private void moveTime(int n, int n2) {
        TidesDoc tidesDoc = this.currentSelectedFrame;
        if (tidesDoc != null && tidesDoc.type == 0) {
            tidesDoc.panel.moveTime(n, n2);
        }
        this.giveBackFocus();
    }

    private void PrintActionPerformed(ActionEvent actionEvent) {
        TidesDoc tidesDoc = this.currentSelectedFrame;
        if (tidesDoc != null && tidesDoc.type == 0) {
            tidesDoc.panel.doPrint();
        }
        this.giveBackFocus();
    }

    private void ConfigureActionPerformed(ActionEvent actionEvent) {
        this.launchConfiguration();
        this.giveBackFocus();
    }

    public void launchConfiguration() {
        TideConfiguration tideConfiguration = new TideConfiguration(this, false);
    }

    private void CloseAllActionPerformed(ActionEvent actionEvent) {
        this.tabbedPaneManager.closeAll();
    }

    private void OpenSelectorActionPerformed(ActionEvent actionEvent) {
        this.openFile(siteExplorerName, true);
        this.giveBackFocus();
    }

    private void OpenSiteActionPerformed(ActionEvent actionEvent) {
        this.openFile(siteExplorerName, true);
        this.giveBackFocus();
    }

    private void CloseActionPerformed(ActionEvent actionEvent) {
        this.tabbedPaneManager.close();
        this.giveBackFocus();
    }

    private void formComponentResized(ComponentEvent componentEvent) {
        this.appSize = this.getSize();
    }

    public void openFile(String string, boolean bl) {
        this.tabbedPaneManager.addTab(string, bl);
    }

    private void indexInit(String string, boolean bl) {
        if (!this.tideComp.indexValid) {
            this.tideComp.verifyIndex(indexName, this.basePath, string, bl);
        }
    }

    public TidesDoc openSiteExplorer() {
        TidesDoc tidesDoc = null;
        boolean bl = false;
        if (this.tideComp.indexValid) {
            if (this.currentFinder != null) {
                tidesDoc = this.currentFinder;
                bl = true;
            } else {
                this.currentFinder = tidesDoc = new TidesDoc(this, 1, siteExplorerName, true, true, true, true);
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
        return tidesDoc;
    }

    public TidesDoc openHelpBrowser() {
        TidesDoc tidesDoc = null;
        boolean bl = false;
        if (this.currentHelpBrowser != null) {
            tidesDoc = this.currentHelpBrowser;
            bl = true;
        } else {
            this.currentHelpBrowser = tidesDoc = new TidesDoc(this, 2, helpBrowserName, true, true, true, true);
        }
        return tidesDoc;
    }

    private void exitForm(WindowEvent windowEvent) {
        this.myExit();
    }

    private void formWindowActivated(WindowEvent windowEvent) {
        this.giveBackFocus();
    }

    private void BackYearButtonActionPerformed(ActionEvent actionEvent) {
        this.moveTime(1, -1);
    }

    private void ForwardYearButtonActionPerformed(ActionEvent actionEvent) {
        this.moveTime(1, 1);
    }

    public void myExit() {
        Dimension dimension = this.Toolbar.getSize();
        Point point = this.Toolbar.getLocation();
        this.configValues.toolBarPosition = dimension.width > dimension.height ? 0 : (point.x > 0 ? 1 : 3);
        Vector vector = this.tabbedPaneManager.getList();
        this.configValues.openSites = this.tideComp.mergeDelimLine(vector, "|");
        this.configValues.selectedSite = this.tabbedPaneManager.getSelectedIndex();
        this.configValues.recentSiteList = this.recentFileList.getString();
        this.initFileHandler.write(this.configValues);
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                System.setProperty("awt.useSystemAAFontSettings", "on");
                System.setProperty("swing.aatext", "true");
                new JTides().setVisible(true);
            }
        });
    }
}

