/*
 * Decompiled with CFR 0.152.
 */
package jtides;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Arrays;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jtides.HTMLPageBuilder;
import jtides.JTides;
import jtides.MyJButton;
import jtides.TidesDoc;

public class HTMLDatabase
extends JPanel {
    boolean writingDatabase = false;
    Thread workThread = null;
    String copynote;
    HTMLPageBuilder pageBuilder;
    String javaScriptBlock = "<script type=\"text/javascript\" language=\"JavaScript\">\n<!-- ;\nmon = new Array(\"January\",\"February\",\"March\",\"April\",\"May\",\n\"June\",\"July\",\"August\",\"September\",\"October\",\"November\",\"December\");\nfunction today(path)\n{\n   path = \"./\" + path + \"/\";\n   date = new Date();\n   yr = date.getYear();\n   if(yr < 50) { // JavaScript isn't Y2K compatible, so this hack is necessary\n      yr += 2000;\n   }\n   else if(yr < 1900) {\n      yr += 1900;\n   }\n   month = date.getMonth();\n   mday = date.getDate();\n   location.href = path + yr + \"/\" + mon[month] + \".html#\" + mday;\n}\n//-->\n</script>\n";
    String todayTag = "<li><a href=\"javascript:today('')\">Today</a></li>";
    JTides main;
    TidesDoc theDoc;
    private JPanel TimePanel;
    private JButton createButton;
    private JComboBox endYearComboBox;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JTextArea messageTextArea;
    private JProgressBar progressBar;
    private JComboBox startYearComboBox;
    private JLabel titleLabel;

    public HTMLDatabase(JTides jTides) {
        this.main = jTides;
        this.theDoc = this.getCurrentDoc();
        this.initComponents();
        this.pageBuilder = new HTMLPageBuilder(jTides);
        this.progressBar.setStringPainted(true);
        this.titleLabel.setText("Create HTML page set for " + this.theDoc.siteSet.name);
        this.setup();
        this.copynote = "<p></p><font size=\"-2\">Copyright &copy; 2011, P. Lutus " + this.pageBuilder.wrapTag("http://www.arachnoid.com/JTides", "a", "href=\"http://www.arachnoid.com/JTides\"") + "</font>";
    }

    private void setup() {
        String string;
        int n;
        for (n = this.theDoc.siteSet.startYear; n < this.theDoc.siteSet.endYear; ++n) {
            string = "" + n;
            this.startYearComboBox.addItem(string);
            this.endYearComboBox.addItem(string);
        }
        n = Calendar.getInstance().get(1);
        this.startYearComboBox.setSelectedItem("" + n);
        this.endYearComboBox.setSelectedItem("" + n);
        string = "This dialog will create a set of Web pages for the currently displayed site (" + this.theDoc.siteSet.name + " ). The pages will be placed on your system under the directory \"" + this.main.basePath + "/HTMLPages\".\n\nYou may choose to move the pages from that location onto your Web site or elsewhere. Any number of site data sets may be created this way and they will be indexed for you under this directory.\n\n1. Select the desired site in the main JTides display.\n2. Open this dialog.\n3. Choose the desired years above.\n4. Click \"Create HTML page set\" below.\n\nNote: If you want to change the appearance of the generated Web pages, feel free to edit the values in \"" + this.main.configPath + "\", in particular those values beginning with \"html\".";
        this.messageTextArea.setText(string);
    }

    public TidesDoc getCurrentDoc() {
        return this.main.tabbedPaneManager.getSelectedDoc();
    }

    private void createPages() {
        if (!this.writingDatabase) {
            this.writingDatabase = true;
            this.createButton.setEnabled(false);
            this.workThread = new Thread(){

                @Override
                public void run() {
                    HTMLDatabase.this.createPagesThread();
                }
            };
            this.workThread.start();
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private void createPagesThread() {
        String string;
        String string2 = this.main.basePath + "/HTMLPages";
        File file = new File(string2);
        String string3 = this.theDoc.siteSet.name;
        String string4 = string3.replaceAll("[^\\w]", "_");
        File file2 = new File(file, string4);
        file2.mkdirs();
        int n = Integer.parseInt((String)this.startYearComboBox.getSelectedItem());
        int n2 = Integer.parseInt((String)this.endYearComboBox.getSelectedItem());
        int n3 = (n2 + 1 - n) * 12;
        int n4 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.todayTag);
        for (int i = n; i <= n2; ++i) {
            n4 = this.createYearPage(file2, i, string3 + ", " + i, n4, n3);
            string = this.pageBuilder.wrapTag("" + i, "a", "href=\"" + i + "/index.html\"");
            stringBuffer.append(this.pageBuilder.wrapTag(string, "li"));
        }
        String string5 = this.pageBuilder.wrapTag(stringBuffer.toString(), "ul");
        string5 = this.pageBuilder.wrapTag(string3, "b") + "<p></p>" + string5 + this.copynote;
        string5 = this.pageBuilder.wrapTag(string5, "body");
        string = this.pageBuilder.wrapTag(string3, "title");
        String string6 = string + this.pageBuilder.metaTags + this.javaScriptBlock;
        string5 = this.pageBuilder.wrapTag(string6, "head") + string5;
        string5 = this.pageBuilder.wrapTag(string5, "html");
        string5 = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">" + "\n\n" + string5;
        File file3 = new File(file2, "index.html");
        try {
            FileWriter fileWriter = new FileWriter(file3);
            fileWriter.write(string5);
            fileWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.refreshMasterIndex(file);
        this.writingDatabase = false;
        this.createButton.setEnabled(true);
    }

    private void refreshMasterIndex(File file) {
        String string;
        String string2;
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        Object[] objectArray = file.listFiles();
        Arrays.sort(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            if (!((File)objectArray[i]).isDirectory()) continue;
            object = new File((File)objectArray[i], "index.html");
            string2 = this.readFile((File)object);
            string2 = string2.replaceFirst("([\\w|\\W]+<title>\\s*)([^<|\\n]+)(\\s*</title>[\\w|\\W]+)", "$2");
            string = this.pageBuilder.wrapTag(string2, "a", "href=\"" + ((File)objectArray[i]).getName() + "/index.html\"");
            string = string + "&nbsp;" + this.pageBuilder.wrapTag("Today", "a", "href=\"javascript:today('" + ((File)objectArray[i]).getName() + "')\"");
            stringBuffer.append(this.pageBuilder.wrapTag(string, "li"));
        }
        String string3 = this.pageBuilder.wrapTag(stringBuffer.toString(), "ul");
        object = "JTides Tide/Current Data Pages";
        string2 = this.pageBuilder.wrapTag(string3 + this.copynote, "body");
        string = this.pageBuilder.wrapTag((String)object, "title") + this.pageBuilder.metaTags + this.javaScriptBlock;
        string2 = this.pageBuilder.wrapTag(string, "head") + string2;
        string2 = this.pageBuilder.wrapTag(string2, "html");
        string2 = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">" + "\n\n" + string2;
        File file2 = new File(file, "index.html");
        try {
            FileWriter fileWriter = new FileWriter(file2);
            fileWriter.write(string2);
            fileWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int createYearPage(File file, int n, String string, int n2, int n3) {
        Object object;
        String string2;
        File file2 = new File(file, "" + n);
        file2.mkdirs();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 12; ++i) {
            this.updateProgressBar(0, ++n2, n3);
            this.pageBuilder.createMonthPage(this.theDoc, this.copynote, file2, n, i, 0, 12);
            string2 = HTMLPageBuilder.monthLongName[i];
            object = this.pageBuilder.wrapTag(string2, "a", "href=\"" + HTMLPageBuilder.monthLongName[i] + ".html\"");
            stringBuffer.append(this.pageBuilder.wrapTag((String)object, "li"));
        }
        String string3 = this.pageBuilder.wrapTag(stringBuffer.toString(), "ul");
        string3 = this.pageBuilder.wrapTag(string3 + this.copynote, "body");
        string2 = this.pageBuilder.wrapTag(string, "title") + this.pageBuilder.metaTags;
        string3 = this.pageBuilder.wrapTag(string2, "head") + string3;
        string3 = this.pageBuilder.wrapTag(string3, "html");
        string3 = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">" + "\n\n" + string3;
        object = new File(file2, "index.html");
        try {
            FileWriter fileWriter = new FileWriter((File)object);
            fileWriter.write(string3);
            fileWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n2;
    }

    private String readFile(File file) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            char[] cArray = new char[16384];
            while ((n = bufferedReader.read(cArray)) > 0) {
                stringBuffer.append(cArray, 0, n);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringBuffer.toString();
    }

    private void updateProgressBar(int n, int n2, int n3) {
        if (n3 > n) {
            this.progressBar.setMinimum(n);
            this.progressBar.setMaximum(n3);
            this.progressBar.setValue(n2);
        }
    }

    private void initComponents() {
        this.titleLabel = new JLabel();
        this.TimePanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.startYearComboBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.endYearComboBox = new JComboBox();
        this.createButton = new MyJButton();
        this.jScrollPane1 = new JScrollPane();
        this.messageTextArea = new JTextArea();
        this.progressBar = new JProgressBar();
        this.setLayout(new GridBagLayout());
        this.titleLabel.setHorizontalAlignment(0);
        this.titleLabel.setText("***");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.titleLabel, gridBagConstraints);
        this.TimePanel.setBorder(BorderFactory.createTitledBorder("Time Interval"));
        this.TimePanel.setLayout(new GridBagLayout());
        this.jLabel1.setText("Start");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.TimePanel.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.TimePanel.add((Component)this.startYearComboBox, gridBagConstraints);
        this.jLabel2.setText("End");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.TimePanel.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.TimePanel.add((Component)this.endYearComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.TimePanel, gridBagConstraints);
        this.createButton.setText("Create HTML page set");
        this.createButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HTMLDatabase.this.createButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 15;
        this.add((Component)this.createButton, gridBagConstraints);
        this.messageTextArea.setEditable(false);
        this.messageTextArea.setLineWrap(true);
        this.messageTextArea.setRows(16);
        this.messageTextArea.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.messageTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.progressBar, gridBagConstraints);
    }

    private void createButtonActionPerformed(ActionEvent actionEvent) {
        this.createPages();
    }
}

