/*
 * Decompiled with CFR 0.152.
 */
package jsiggen;

import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Line;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jsiggen.ComboBoxController;
import jsiggen.ConfigManager;
import jsiggen.JSigGen;
import jsiggen.SignalGenerator;
import jsiggen.TextFieldController;
import jsiggen.ToggleButtonController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSigGenPanel
extends JPanel {
    JSigGen parent = null;
    String user_dir = null;
    String file_sep;
    String ini_path = null;
    ConfigManager config_mgr;
    ToggleButtonController controller_enabled;
    ToggleButtonController left_channel_enabled;
    ToggleButtonController right_channel_enabled;
    ToggleButtonController modulation_enabled;
    ToggleButtonController noise_enabled;
    ToggleButtonController signal_enabled;
    ComboBoxController modulation_waveform;
    ComboBoxController data_rate;
    ComboBoxController output_channel;
    ComboBoxController signal_waveform;
    ComboBoxController am_fm_mode;
    TextFieldController frequency;
    TextFieldController modulation_frequency;
    TextFieldController modulation_level;
    TextFieldController signal_level;
    TextFieldController noise_level;
    Line.Info sourceLineInfo;
    ArrayList<Mixer> source_mixers;
    SignalGenerator generator = null;
    Timer periodic_timer;
    int timer_period_ms = 500;
    private JComboBox am_fm_combobox;
    private JCheckBox controller_enable_checkbutton;
    private JPanel controller_panel;
    private JComboBox data_rate_combobox;
    private JTextField frequency_textfield;
    private JButton help_button;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JCheckBox left_checkbox;
    private JCheckBox modulation_enable_checkbox;
    private JTextField modulation_frequency_textfield;
    private JTextField modulation_level_textfield;
    private JPanel modulation_panel;
    private JComboBox modulation_waveform_combobox;
    private JCheckBox noise_enable_checkbox;
    private JTextField noise_level_textfield;
    private JPanel noise_panel;
    private JComboBox output_channel_combobox;
    private JButton quit_button;
    private JCheckBox right_checkbox;
    private JCheckBox signal_enable_checkbox;
    private JTextField signal_level_textfield;
    private JPanel signal_panel;
    private JComboBox signal_waveform_combobox;

    public JSigGenPanel(String[] args) {
        this.setup(args);
    }

    public JSigGenPanel(JSigGen p, String[] args) {
        this.parent = p;
        this.setup(args);
    }

    private void setup(String[] args) {
        int len;
        List<String> data_rates = Arrays.asList("192000", "96000", "48000", "32000", "24000", "16000", "12000", "8000", "6000");
        String default_rate = "48000";
        double freqStep = 1.0;
        this.initComponents();
        this.file_sep = System.getProperty("file.separator");
        if (this.parent != null) {
            this.user_dir = System.getProperty("user.home");
            this.ini_path = this.user_dir + this.file_sep + "." + this.parent.app_name + ".ini";
        }
        if (args.length > 0) {
            try {
                String ss = args[0].replaceFirst("--fstep=(.*)", "$1");
                freqStep = Double.parseDouble(ss);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.controller_enabled = new ToggleButtonController(this.controller_enable_checkbutton, true);
        this.left_channel_enabled = new ToggleButtonController(this.left_checkbox, true);
        this.right_channel_enabled = new ToggleButtonController(this.right_checkbox, true);
        this.modulation_enabled = new ToggleButtonController(this.modulation_enable_checkbox, false);
        this.noise_enabled = new ToggleButtonController(this.noise_enable_checkbox, false);
        this.signal_enabled = new ToggleButtonController(this.signal_enable_checkbox, true);
        List<String> waveforms = Arrays.asList("Sine", "Triangle", "Square", "Sawtooth");
        this.modulation_waveform = new ComboBoxController(this.modulation_waveform_combobox, waveforms, "Sine");
        this.signal_waveform = new ComboBoxController(this.signal_waveform_combobox, waveforms, "Sine");
        this.data_rate = new ComboBoxController(this.data_rate_combobox, data_rates, default_rate);
        List<String> modes = Arrays.asList("AM", "FM");
        this.am_fm_mode = new ComboBoxController(this.am_fm_combobox, modes, "AM");
        this.find_source_mixers();
        ArrayList<String> data = new ArrayList<String>();
        for (int i = len = this.source_mixers.size(); i > 0; --i) {
            data.add("" + i);
        }
        this.output_channel = new ComboBoxController(this.output_channel_combobox, data, "1");
        this.frequency = new TextFieldController(this.frequency_textfield, freqStep, "440");
        this.modulation_frequency = new TextFieldController(this.modulation_frequency_textfield, 1.0, "1");
        this.modulation_level = new TextFieldController(this.modulation_level_textfield, 1.0, "50");
        this.signal_level = new TextFieldController(this.signal_level_textfield, 1.0, "20");
        this.noise_level = new TextFieldController(this.noise_level_textfield, 1.0, "30");
        if (this.ini_path != null) {
            this.config_mgr = new ConfigManager(this, this.ini_path);
        } else {
            this.controller_enabled.set_value(false);
            this.quit_button.setEnabled(false);
        }
        this.periodic_timer = new Timer();
        this.periodic_timer.scheduleAtFixedRate((TimerTask)new PeriodicEvents(this), 500L, (long)this.timer_period_ms);
    }

    private void stop_generator() {
        if (this.generator != null) {
            this.generator.running = false;
            try {
                this.generator.join();
            }
            catch (Exception e) {
                System.out.println(e);
            }
            this.generator = null;
        }
    }

    private void find_source_mixers() {
        this.sourceLineInfo = new Line.Info(SourceDataLine.class);
        Mixer.Info[] mi = AudioSystem.getMixerInfo();
        this.source_mixers = new ArrayList();
        for (Mixer.Info m : mi) {
            Mixer mixer = AudioSystem.getMixer(m);
            if (!mixer.isLineSupported(this.sourceLineInfo)) continue;
            this.source_mixers.add(mixer);
        }
    }

    public void close() {
        this.stop_generator();
        if (this.config_mgr != null) {
            this.config_mgr.write_config_file();
        }
        System.exit(0);
    }

    public void help() {
        try {
            Desktop.getDesktop().browse(URI.create("http://arachnoid.com/JSigGen"));
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public <T> void p(T s) {
        System.out.println(s);
    }

    private void initComponents() {
        this.controller_panel = new JPanel();
        this.jLabel1 = new JLabel();
        this.controller_enable_checkbutton = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.data_rate_combobox = new JComboBox();
        this.left_checkbox = new JCheckBox();
        this.right_checkbox = new JCheckBox();
        this.help_button = new JButton();
        this.quit_button = new JButton();
        this.jLabel11 = new JLabel();
        this.output_channel_combobox = new JComboBox();
        this.signal_panel = new JPanel();
        this.jLabel3 = new JLabel();
        this.signal_enable_checkbox = new JCheckBox();
        this.jLabel12 = new JLabel();
        this.jLabel4 = new JLabel();
        this.frequency_textfield = new JTextField();
        this.signal_waveform_combobox = new JComboBox();
        this.jLabel5 = new JLabel();
        this.signal_level_textfield = new JTextField();
        this.modulation_panel = new JPanel();
        this.jLabel6 = new JLabel();
        this.modulation_enable_checkbox = new JCheckBox();
        this.am_fm_combobox = new JComboBox();
        this.jLabel7 = new JLabel();
        this.modulation_frequency_textfield = new JTextField();
        this.modulation_waveform_combobox = new JComboBox();
        this.jLabel8 = new JLabel();
        this.modulation_level_textfield = new JTextField();
        this.noise_panel = new JPanel();
        this.jLabel9 = new JLabel();
        this.noise_enable_checkbox = new JCheckBox();
        this.jLabel13 = new JLabel();
        this.jLabel10 = new JLabel();
        this.noise_level_textfield = new JTextField();
        this.setMinimumSize(new Dimension(0, 0));
        this.setPreferredSize(new Dimension(0, 0));
        this.setLayout(new GridBagLayout());
        this.controller_panel.setBorder(BorderFactory.createLineBorder(new Color(204, 0, 51), 2));
        this.controller_panel.setLayout(new GridBagLayout());
        this.jLabel1.setFont(new Font("Dialog", 1, 16));
        this.jLabel1.setForeground(new Color(204, 0, 51));
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("Controller");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.controller_panel.add((Component)this.jLabel1, gridBagConstraints);
        this.controller_enable_checkbutton.setText("Enable");
        this.controller_enable_checkbutton.setToolTipText("Enable output data stream");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.controller_panel.add((Component)this.controller_enable_checkbutton, gridBagConstraints);
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText("Sample Rate: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.controller_panel.add((Component)this.jLabel2, gridBagConstraints);
        this.data_rate_combobox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.data_rate_combobox.setToolTipText("<html>Select data sampling rate in samples/second<br/>\n(while output is disabled)\n</html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.controller_panel.add((Component)this.data_rate_combobox, gridBagConstraints);
        this.left_checkbox.setText("Left");
        this.left_checkbox.setToolTipText("Enable left channel audio");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.controller_panel.add((Component)this.left_checkbox, gridBagConstraints);
        this.right_checkbox.setText("Right");
        this.right_checkbox.setToolTipText("Enable right channel audio");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.controller_panel.add((Component)this.right_checkbox, gridBagConstraints);
        this.help_button.setText("Help");
        this.help_button.setToolTipText("Visit the JSigGen web page");
        this.help_button.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                JSigGenPanel.this.help_buttonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.controller_panel.add((Component)this.help_button, gridBagConstraints);
        this.quit_button.setText("Quit");
        this.quit_button.setToolTipText("Quit JSigGen");
        this.quit_button.setPreferredSize(null);
        this.quit_button.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                JSigGenPanel.this.quit_buttonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.controller_panel.add((Component)this.quit_button, gridBagConstraints);
        this.jLabel11.setHorizontalAlignment(4);
        this.jLabel11.setText("Output channel: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.controller_panel.add((Component)this.jLabel11, gridBagConstraints);
        this.output_channel_combobox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.output_channel_combobox.setToolTipText("<html>Select audio output channel<br/>\n(while output is disabled)\n</html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.controller_panel.add((Component)this.output_channel_combobox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 126;
        gridBagConstraints.ipady = -2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)this.controller_panel, gridBagConstraints);
        this.signal_panel.setBorder(BorderFactory.createLineBorder(new Color(51, 153, 0), 2));
        this.signal_panel.setLayout(new GridBagLayout());
        this.jLabel3.setFont(new Font("Dialog", 1, 16));
        this.jLabel3.setForeground(new Color(51, 153, 0));
        this.jLabel3.setHorizontalAlignment(0);
        this.jLabel3.setText("Signal");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.signal_panel.add((Component)this.jLabel3, gridBagConstraints);
        this.signal_enable_checkbox.setText("Enable");
        this.signal_enable_checkbox.setToolTipText("Enable signal");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.signal_panel.add((Component)this.signal_enable_checkbox, gridBagConstraints);
        this.jLabel12.setMinimumSize(new Dimension(52, 24));
        this.jLabel12.setPreferredSize(new Dimension(52, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.signal_panel.add((Component)this.jLabel12, gridBagConstraints);
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText("Freq. Hz: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.signal_panel.add((Component)this.jLabel4, gridBagConstraints);
        this.frequency_textfield.setHorizontalAlignment(4);
        this.frequency_textfield.setText("000000.0");
        this.frequency_textfield.setMinimumSize(new Dimension(80, 20));
        this.frequency_textfield.setPreferredSize(new Dimension(80, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.signal_panel.add((Component)this.frequency_textfield, gridBagConstraints);
        this.signal_waveform_combobox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.signal_waveform_combobox.setToolTipText("Select signal waveform");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.signal_panel.add((Component)this.signal_waveform_combobox, gridBagConstraints);
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setText("Level %: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.signal_panel.add((Component)this.jLabel5, gridBagConstraints);
        this.signal_level_textfield.setHorizontalAlignment(4);
        this.signal_level_textfield.setText("000000.0");
        this.signal_level_textfield.setMinimumSize(new Dimension(80, 20));
        this.signal_level_textfield.setPreferredSize(new Dimension(80, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.signal_panel.add((Component)this.signal_level_textfield, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)this.signal_panel, gridBagConstraints);
        this.modulation_panel.setBorder(BorderFactory.createLineBorder(new Color(51, 51, 255), 2));
        this.modulation_panel.setLayout(new GridBagLayout());
        this.jLabel6.setFont(new Font("Dialog", 1, 16));
        this.jLabel6.setForeground(new Color(0, 51, 204));
        this.jLabel6.setHorizontalAlignment(0);
        this.jLabel6.setText("Modul");
        this.jLabel6.setToolTipText("Modulation");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.modulation_panel.add((Component)this.jLabel6, gridBagConstraints);
        this.modulation_enable_checkbox.setText("Enable");
        this.modulation_enable_checkbox.setToolTipText("Enable modulation");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.modulation_panel.add((Component)this.modulation_enable_checkbox, gridBagConstraints);
        this.am_fm_combobox.setModel(new DefaultComboBoxModel<String>(new String[]{"AM", "FM", " "}));
        this.am_fm_combobox.setToolTipText("Select AM or FM modulation mode");
        this.am_fm_combobox.setMinimumSize(new Dimension(50, 24));
        this.am_fm_combobox.setPreferredSize(new Dimension(50, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.modulation_panel.add((Component)this.am_fm_combobox, gridBagConstraints);
        this.jLabel7.setHorizontalAlignment(4);
        this.jLabel7.setText("Freq. Hz: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.modulation_panel.add((Component)this.jLabel7, gridBagConstraints);
        this.modulation_frequency_textfield.setHorizontalAlignment(4);
        this.modulation_frequency_textfield.setText("000000.0");
        this.modulation_frequency_textfield.setMinimumSize(new Dimension(80, 20));
        this.modulation_frequency_textfield.setPreferredSize(new Dimension(80, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.modulation_panel.add((Component)this.modulation_frequency_textfield, gridBagConstraints);
        this.modulation_waveform_combobox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.modulation_waveform_combobox.setToolTipText("Select modulation waveform");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.modulation_panel.add((Component)this.modulation_waveform_combobox, gridBagConstraints);
        this.jLabel8.setHorizontalAlignment(4);
        this.jLabel8.setText("Level %: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.modulation_panel.add((Component)this.jLabel8, gridBagConstraints);
        this.modulation_level_textfield.setHorizontalAlignment(4);
        this.modulation_level_textfield.setText("000000.0");
        this.modulation_level_textfield.setMinimumSize(new Dimension(80, 20));
        this.modulation_level_textfield.setPreferredSize(new Dimension(80, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.modulation_panel.add((Component)this.modulation_level_textfield, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)this.modulation_panel, gridBagConstraints);
        this.noise_panel.setBorder(BorderFactory.createLineBorder(new Color(153, 0, 153), 2));
        this.noise_panel.setLayout(new GridBagLayout());
        this.jLabel9.setFont(new Font("Dialog", 1, 16));
        this.jLabel9.setForeground(new Color(153, 0, 153));
        this.jLabel9.setHorizontalAlignment(0);
        this.jLabel9.setText("Noise ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(1, 1, 1, 3);
        this.noise_panel.add((Component)this.jLabel9, gridBagConstraints);
        this.noise_enable_checkbox.setText("Enable");
        this.noise_enable_checkbox.setToolTipText("Enable white noise generator");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.noise_panel.add((Component)this.noise_enable_checkbox, gridBagConstraints);
        this.jLabel13.setMinimumSize(new Dimension(282, 20));
        this.jLabel13.setPreferredSize(new Dimension(282, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.noise_panel.add((Component)this.jLabel13, gridBagConstraints);
        this.jLabel10.setHorizontalAlignment(4);
        this.jLabel10.setText("Level %: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.noise_panel.add((Component)this.jLabel10, gridBagConstraints);
        this.noise_level_textfield.setHorizontalAlignment(4);
        this.noise_level_textfield.setText("000000.0");
        this.noise_level_textfield.setMaximumSize(new Dimension(40, 20));
        this.noise_level_textfield.setMinimumSize(new Dimension(80, 20));
        this.noise_level_textfield.setPreferredSize(new Dimension(80, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.noise_panel.add((Component)this.noise_level_textfield, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = -12;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)this.noise_panel, gridBagConstraints);
    }

    private void help_buttonMouseClicked(MouseEvent evt) {
        this.help();
    }

    private void quit_buttonMouseClicked(MouseEvent evt) {
        this.close();
    }

    class PeriodicEvents
    extends TimerTask {
        JSigGenPanel parent;

        public PeriodicEvents(JSigGenPanel p) {
            this.parent = p;
        }

        public void run() {
            if (JSigGenPanel.this.controller_enabled.get_value()) {
                if (JSigGenPanel.this.generator == null) {
                    JSigGenPanel.this.generator = new SignalGenerator(this.parent);
                    JSigGenPanel.this.generator.start();
                }
            } else {
                JSigGenPanel.this.stop_generator();
            }
            this.parent.data_rate_combobox.setEnabled(JSigGenPanel.this.generator == null);
            this.parent.output_channel_combobox.setEnabled(JSigGenPanel.this.generator == null);
        }
    }
}

