// ***************************************************************************
// *   Copyright (C) 2017 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************
package jsqliteclient;

import java.io.File;
import java.util.ArrayList;

/**
 *
 * @author lutusp
 */
final public class ParseComLine {

    String server = null;
    String user = null;
    ArrayList<String> dblist = null;
    String table = null;
    String password = null;
    String baseFont = null;
    boolean query = false;
    JSQLiteClient parent;

    public ParseComLine(JSQLiteClient p, String[] args) {
        parent = p;
        int state = 0;
        dblist = new ArrayList<>();
        for (String arg : args) {
            switch (state) {
                case (1):
                    baseFont = arg;
                    state = 0;
                    break;
                case (2):
                    dblist.add(0,arg);
                    state = 0;
                    break;
                case (5):
                    table = arg;
                    query = true;
                    state = 0;
                    break;
                case (0):
                    switch (arg) {
                        case "-f":
                            state = 1;
                            break;
                        case "-d":
                            state = 2;
                            break;
                        case "-t":
                            state = 5;
                            break;
                        case "-r":
                            query = true;
                            break;
                        case "-b":
                            parent.debug = true;
                            break;
                        case "-h":
                            comHelp();
                            break;
                        default:
                            File f = new File(arg);
                            if (f.exists()) {
                                dblist.add(0,f.getAbsolutePath());
                            }
                            break;
                    }
                    break;
            }
        }
    }

    protected void process1() {
        //parent.inhibit = true;
        if (dblist.size() > 0) {
            parent.createDatabaseList(dblist, true);
        }
        if (table != null) {
            parent.sv_tableComboBox.setSelectedItem(table);
        }
        if (query) {
            parent.formatRunQuery();
        }
        //parent.inhibit = false;
    }

    private void comHelp() {
        String help = "Usage: -f \"name of font\"\n"
                + "       -d database   -t table\n"
                + "       -r read table -b debug\n"
                + "       -h help\n";
        System.out.println(help);
        System.exit(0);
    }
}
