/*
 * Decompiled with CFR 0.152.
 */
package jsqliteclient;

import java.awt.Component;
import java.awt.Font;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableCellRenderer;
import jsqliteclient.JSQLiteClient;
import jsqliteclient.MyJTable;

public final class MyTableCellRenderer
extends DefaultTableCellRenderer {
    JSQLiteClient parent;
    static final long serialVersionUID = 32148L;
    String rightJustify;
    int rjLen;
    boolean title;
    boolean errorDisp = false;
    Border cb = null;
    Font font;
    boolean needEllipse = false;
    EmptyBorder emptyBorder;
    LineBorder lineBorder;
    Map<Integer, Integer> decPlaces;

    public MyTableCellRenderer(JSQLiteClient p, boolean title, boolean errorDisp, Map<Integer, Integer> dp) {
        this.parent = p;
        this.decPlaces = dp;
        this.title = title;
        this.errorDisp = errorDisp;
        this.rightJustify = "                           ";
        this.rjLen = this.rightJustify.length();
        if (title) {
            this.font = new Font("Monospaced", 1, 16);
        } else {
            this.cb = new EmptyBorder(this.parent.tablePaddingConstant + 2, this.parent.tablePaddingConstant + 2, this.parent.tablePaddingConstant, this.parent.tablePaddingConstant);
            this.lineBorder = new LineBorder(this.parent.tableBorderColor);
            this.font = this.parent.baseFont;
        }
    }

    private String ellipsizeString(String sv, int pixw) {
        boolean needFix;
        int stringLen = sv.length();
        int sw = stringLen * this.parent.charWidth;
        boolean bl = needFix = sw >= pixw;
        if (needFix) {
            int ni = pixw / this.parent.charWidth - 3;
            ni = Math.max(0, ni);
            sv = sv.substring(0, ni) + "...";
            this.needEllipse |= needFix;
        }
        return sv;
    }

    private String ellipsizeTest(String sv, int pixw) {
        String[] array = sv.split("\n");
        if (array.length < 2) {
            return this.ellipsizeString(sv, pixw);
        }
        StringBuilder sb = new StringBuilder();
        for (String sa : array) {
            sb.append(this.ellipsizeString(sa, pixw));
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.needEllipse = false;
        String sv = "";
        if (value == null) {
            sv = "NULL";
        } else {
            String cls = value.getClass().getName();
            if (this.decPlaces != null && this.decPlaces.containsKey(column) && cls.matches("(?i).*(double|float|integer|long).*")) {
                double dval = Double.parseDouble(value.toString());
                int dp = this.decPlaces.get(column);
                String form = String.format("%%.%df", dp);
                sv = String.format(form, dval);
            } else {
                sv = cls.matches("(?i).*(integer|long).*") ? String.format("%d", value) : (cls.matches("(?i).*(float|double).*") ? String.format("%.8g", value) : value.toString());
            }
        }
        sv = sv.replaceAll("\t", "        ");
        int stringLen = sv.length();
        int colw = table.getColumnModel().getColumn(column).getWidth();
        int pixw = colw - this.parent.tablePaddingConstant;
        sv = this.ellipsizeTest(sv, pixw);
        if (!this.needEllipse && !(value instanceof String)) {
            StringBuilder sb = new StringBuilder();
            int chw = colw / this.parent.charWidth - 1;
            int delta = chw - stringLen;
            if (delta > 0) {
                if (delta < this.rjLen) {
                    sb.append(this.rightJustify.substring(0, delta));
                } else {
                    sb.append(this.rightJustify);
                    delta -= this.rjLen;
                    while (delta > 0) {
                        sb.append(" ");
                        --delta;
                    }
                }
            }
            sv = new String(sb.append(sv));
        }
        JTextArea ta = new JTextArea();
        ta.setEditable(false);
        ta.setLineWrap(false);
        if (this.font != null) {
            ta.setFont(this.font);
        }
        if (!this.title) {
            if (this.errorDisp && column == 3 && !sv.equals("(none)")) {
                ta.setForeground(this.parent.changedColor);
            }
            if (isSelected) {
                ta.setBackground(this.parent.selectedColor);
            } else if (table instanceof MyJTable) {
                if (row == ((MyJTable)table).hoverRow) {
                    ta.setBackground(this.parent.hoverColor);
                } else {
                    ta.setBackground(this.parent.oddeven[row % 2]);
                }
            }
        } else {
            int lm = (table.getWidth() - sv.length() * this.parent.charWidth) / 2;
            this.cb = new EmptyBorder(16, lm, 0, 0);
        }
        ta.setBorder(this.cb);
        ta.setText(sv);
        return ta;
    }

    private void p(String s) {
        System.out.println(s);
    }
}

