/*
 * Decompiled with CFR 0.152.
 */
package jrx;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import jrx.Beep;
import jrx.JRX;
import jrx.MemoryButton;
import jrx.TuneData;

public final class ScanFunctions {
    JRX parent;
    long scanStartFreq = 0L;
    long scanEndFreq = 0L;
    int scanStartIndex = 0;
    int scanEndIndex = 0;
    int scanMemoryIndex = 0;
    boolean programScan = false;
    double scanStep;
    double scanSpeedMS = 500.0;
    int scanDirection = 0;
    Timer scanTimer = null;
    MemoryButton oldButton = null;
    ArrayList<MemoryButton> buttonScanList = null;
    ArrayList<TuneData> tableScanList = null;
    boolean buttonScanMode = false;

    public ScanFunctions(JRX p) {
        this.parent = p;
    }

    protected long getScanFrequency() {
        if (this.buttonScanMode) {
            MemoryButton mb = this.buttonScanList.get(this.scanMemoryIndex);
            if (this.oldButton != null) {
                this.oldButton.updateState(this.parent.darkGreen);
            }
            mb.updateState(Color.red);
            this.oldButton = mb;
            return mb.skipDuringScan != 0 ? -1L : mb.frequency;
        }
        return this.tableScanList.get((int)this.scanMemoryIndex).freq;
    }

    protected boolean validState() {
        return this.parent.dcdCapable || this.parent.useJRXSquelch;
    }

    protected void startScan(int direction) {
        if (!this.validState()) {
            this.parent.tellUser("No squelch scheme enabled");
        } else {
            this.parent.getScopePanel().stopSweep(false);
            if (this.scanTimer == null) {
                this.oldButton = null;
                this.scanDirection = direction;
                if (this.setScanParams()) {
                    if (this.programScan) {
                        if (direction < 0) {
                            if (this.scanMemoryIndex > this.scanEndIndex || this.scanMemoryIndex < this.scanStartIndex) {
                                this.scanMemoryIndex = this.scanEndIndex;
                            }
                        } else if (this.scanMemoryIndex > this.scanEndIndex || this.scanMemoryIndex < this.scanStartIndex) {
                            this.scanMemoryIndex = this.scanStartIndex;
                        }
                    } else if (direction < 0) {
                        if (this.parent.sv_freq > this.scanEndFreq || this.parent.sv_freq < this.scanStartFreq) {
                            this.parent.sv_freq = this.scanEndFreq;
                        }
                        this.scanStep = -Math.abs(this.scanStep);
                    } else {
                        if (this.parent.sv_freq > this.scanEndFreq || this.parent.sv_freq < this.scanStartFreq) {
                            this.parent.sv_freq = this.scanStartFreq;
                        }
                        this.scanStep = Math.abs(this.scanStep);
                    }
                    this.scanTimer = new Timer();
                    this.scanTimer.scheduleAtFixedRate((TimerTask)new ScanEvents(), 0L, (long)((int)this.scanSpeedMS));
                    this.parent.updateScanControls();
                }
            } else {
                if (direction != this.scanDirection) {
                    this.scanDirection = direction;
                    this.scanStep = Math.abs(this.scanStep) * (double)this.scanDirection;
                }
                this.parent.sv_freq = this.programScan ? this.getNextScanFrequency() : (long)((double)this.parent.sv_freq + this.scanStep);
            }
        }
    }

    protected void stopScan(boolean alert) {
        if (this.scanTimer != null) {
            this.scanTimer.cancel();
            this.scanTimer = null;
        } else if (alert) {
            Beep.beep();
        }
        this.parent.updateScanControls();
    }

    protected boolean setScanParams() {
        int index = this.parent.getActiveTab();
        boolean bl = this.buttonScanMode = index == 0;
        if (this.buttonScanMode) {
            return this.setMemoryScanParams();
        }
        return this.setTableScanParams();
    }

    protected boolean setTableScanParams() {
        if (this.parent.validSetup()) {
            int[] rowindices;
            this.tableScanList = new ArrayList();
            for (int i : rowindices = this.parent.freqTable.getSelectedRows()) {
                long f = 0L;
                try {
                    double df = Double.parseDouble(this.parent.freqData[i][3]);
                    f = (long)(df * 1000000.0 + 0.5);
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.tableScanList.add(new TuneData(this.parent.freqData[i][2], f));
            }
            this.scanStartIndex = 0;
            this.scanEndIndex = this.tableScanList.size();
            if (this.scanEndIndex < 2) {
                this.tableScanList = null;
                this.parent.tellUser("<html>For scanning, please select two or more frequencies<br/>from the frequency table.");
            } else {
                boolean bl = this.programScan = this.scanEndIndex > 2;
                if (!this.programScan) {
                    this.scanStartFreq = this.tableScanList.get((int)0).freq;
                    this.scanEndFreq = this.tableScanList.get((int)1).freq;
                    if (this.scanStartFreq > this.scanEndFreq) {
                        long temp = this.scanStartFreq;
                        this.scanStartFreq = this.scanEndFreq;
                        this.scanEndFreq = temp;
                    }
                }
            }
            this.scanStep = this.parent.getScanStep(this.parent.sv_scanStepComboBox);
            this.scanSpeedMS = this.parent.getTimeStep(this.parent.sv_scanSpeedComboBox);
            return this.tableScanList != null;
        }
        return false;
    }

    protected boolean setMemoryScanParams() {
        if (this.parent.validSetup()) {
            this.buttonScanList = this.parent.getScanButtons(this.parent.memoryButtonTotal);
            if (this.buttonScanList != null) {
                int sz = this.buttonScanList.size();
                if (sz >= 2) {
                    boolean bl = this.programScan = sz > 2;
                    if (this.programScan) {
                        this.scanStartIndex = 0;
                        this.scanEndIndex = sz;
                    } else {
                        this.scanStartFreq = this.buttonScanList.get((int)0).frequency;
                        this.scanEndFreq = this.buttonScanList.get((int)1).frequency;
                        if (this.scanStartFreq == this.scanEndFreq) {
                            this.parent.tellUser("Scan start and end frequencies are the same");
                            return false;
                        }
                        if (this.scanStartFreq > this.scanEndFreq) {
                            long temp = this.scanStartFreq;
                            this.scanStartFreq = this.scanEndFreq;
                            this.scanEndFreq = temp;
                        }
                    }
                    this.scanStep = this.parent.getScanStep(this.parent.sv_scanStepComboBox);
                    this.scanSpeedMS = this.parent.getTimeStep(this.parent.sv_scanSpeedComboBox);
                    return true;
                }
                this.parent.tellUser("<html>For scanning, please click the lower or upper button<br/>of a set of at least two adjacent defined memory buttons");
            }
        }
        return false;
    }

    protected int incrementScan(int i, int lo, int hi, int increm) {
        if (hi > lo) {
            return (i + increm + (hi - lo)) % (hi - lo) + lo;
        }
        return i;
    }

    protected long getNextScanFrequency() {
        long freq = -1L;
        int count = 100;
        while (freq < 0L && count-- > 0) {
            this.scanMemoryIndex = this.incrementScan(this.scanMemoryIndex, this.scanStartIndex, this.scanEndIndex, this.scanDirection);
            freq = this.getScanFrequency();
        }
        if (count < 0) {
            this.parent.noValidFrequenciesPrompt();
            this.stopScan(false);
            return this.parent.defaultFrequency;
        }
        return freq;
    }

    class ScanEvents
    extends TimerTask {
        long lastOpenSquelchTime = -1L;

        ScanEvents() {
        }

        @Override
        public void run() {
            ScanFunctions.this.parent.getSignalStrength();
            ScanFunctions.this.parent.setSMeter();
            ScanFunctions.this.parent.getSquelch(false);
            boolean sqopen = ScanFunctions.this.parent.testSquelch();
            if (sqopen) {
                this.lastOpenSquelchTime = System.currentTimeMillis();
            }
            double dwellTime = (double)this.lastOpenSquelchTime + ScanFunctions.this.parent.getTimeStep(ScanFunctions.this.parent.sv_dwellTimeComboBox);
            double now = System.currentTimeMillis();
            if (now >= dwellTime && !sqopen && ScanFunctions.this.scanTimer != null) {
                if (ScanFunctions.this.programScan) {
                    ScanFunctions.this.parent.sv_freq = ScanFunctions.this.getNextScanFrequency();
                } else {
                    ScanFunctions.this.parent.sv_freq = (long)((double)ScanFunctions.this.parent.sv_freq + ScanFunctions.this.scanStep);
                    if (ScanFunctions.this.scanDirection < 0) {
                        if (ScanFunctions.this.parent.sv_freq < ScanFunctions.this.scanStartFreq) {
                            ScanFunctions.this.parent.sv_freq = ScanFunctions.this.scanEndFreq;
                        }
                    } else if (ScanFunctions.this.parent.sv_freq > ScanFunctions.this.scanEndFreq) {
                        ScanFunctions.this.parent.sv_freq = ScanFunctions.this.scanStartFreq;
                    }
                }
            }
            long t1 = System.currentTimeMillis();
            ScanFunctions.this.parent.frequencyToDigits(ScanFunctions.this.parent.sv_freq);
            long t2 = System.currentTimeMillis();
            double dt = (double)(t2 - t1) / 1000.0;
            if (ScanFunctions.this.parent.comArgs.debug >= 1) {
                ScanFunctions.this.parent.p(String.format("scan operation: frequency %d, latency: %f", ScanFunctions.this.parent.sv_freq, dt));
            }
        }
    }
}

