/*
 * Decompiled with CFR 0.152.
 */
package jrx;

import java.awt.Color;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JSlider;
import jrx.Beep;
import jrx.JRX;

public final class MemoryButton
extends JButton
implements MouseListener {
    JRX parent;
    String label;
    Timer defineButtonTimer = null;
    MouseEvent mouseEvent = null;
    int timeout = 1000;
    boolean defineButton = false;
    int skipDuringScan = 0;
    String tt = "<span color=\"green\">Click: read</span><br/><span color=\"blue\">Right-click: toggle skip in memory scan</span><br/><span color=\"red\">Click and hold 1 sec.: write</span><br/><span color=\"purple\">Right-click and hold 1 sec: erase</span>";
    long frequency = -1L;
    int mode;
    int filter;
    int agc;
    int stepSizeIndex = 0;
    int ctcss;
    int nb;
    int antenna;
    int preamp;
    int attenuator;

    public MemoryButton(String lbl, JRX p) {
        super(lbl);
        this.label = lbl;
        this.parent = p;
        this.setToolTipText(this.tt);
        this.setup();
        this.reset();
        this.updateState();
    }

    private void setup() {
        this.addMouseListener(this);
    }

    protected void setButtonColor(Color col) {
        this.setForeground(col);
    }

    protected void reset() {
        this.frequency = -1L;
        this.mode = -1;
        this.filter = -1;
        this.agc = -1;
        this.ctcss = -1;
        this.nb = -1;
        this.antenna = -1;
        this.preamp = -1;
        this.attenuator = -1;
    }

    protected void updateState(Color foreground) {
        this.setForeground(this.frequency >= 0L ? (this.skipDuringScan != 0 ? Color.blue : foreground) : Color.gray);
    }

    protected void updateState() {
        this.updateState(Color.black);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        String ms = this.parent.getMode(this.mode);
        String s = this.frequency >= 0L ? String.format("%.6f MHz %s", (double)this.frequency / 1000000.0, ms) : "Undefined";
        return String.format("<html>%s<br/>%s</html>", s, this.tt);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mouseEvent = e;
        this.setForeground(Color.red);
        this.defineButton = false;
        this.defineButtonTimer = new Timer();
        this.defineButtonTimer.schedule((TimerTask)new defineButton(), this.timeout);
        this.parent.getScopePanel().stopSweep(false);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.defineButtonTimer != null) {
            this.defineButtonTimer.cancel();
            this.defineButtonTimer = null;
        }
        if (e.getButton() == 1) {
            if (!this.defineButton) {
                this.readButton();
            }
        } else if (e.getButton() == 3 && !this.defineButton) {
            this.skipDuringScan ^= 1;
        }
        this.updateState();
    }

    private void updateIfNeeded(JComboBox cc, int v) {
        int ov = cc.getSelectedIndex();
        if (ov != v) {
            cc.setSelectedIndex(v);
        }
    }

    private void updateIfNeeded(JSlider sc, int v) {
        int ov = sc.getValue();
        if (ov != v) {
            sc.setValue(v);
        }
    }

    private void updateIfNeeded(JCheckBox cb, int v) {
        int ov;
        int n = ov = cb.isSelected() ? 1 : 0;
        if (ov != v) {
            cb.setSelected(v != 0);
        }
    }

    protected boolean readButton() {
        if (this.frequency >= 0L) {
            this.parent.scanFunctions.stopScan(false);
            this.parent.sv_mostRecentButton = this.label;
            this.updateIfNeeded(this.parent.sv_filtersComboBox, this.filter);
            this.updateIfNeeded(this.parent.sv_modesComboBox, this.mode);
            this.parent.frequencyToDigits(this.frequency);
            this.updateIfNeeded(this.parent.sv_ctcssComboBox, this.ctcss);
            this.updateIfNeeded(this.parent.sv_agcComboBox, this.agc);
            this.updateIfNeeded(this.parent.sv_preampComboBox, this.preamp);
            this.updateIfNeeded(this.parent.sv_antennaComboBox, this.antenna);
            this.updateIfNeeded(this.parent.sv_attenuatorComboBox, this.attenuator);
            this.updateIfNeeded(this.parent.sv_scanStepComboBox, this.stepSizeIndex);
            this.updateIfNeeded(this.parent.sv_blankerCheckBox, this.nb);
            return true;
        }
        Beep.beep();
        this.parent.tellUser("This memory button is undefined. To define it,\npress it for more than one second.");
        return false;
    }

    private void writeButton() {
        this.parent.sv_mostRecentButton = this.label;
        this.filter = this.parent.sv_filtersComboBox.getSelectedIndex();
        this.mode = this.parent.sv_modesComboBox.getSelectedIndex();
        this.frequency = this.parent.sv_freq;
        this.ctcss = this.parent.sv_ctcssComboBox.getSelectedIndex();
        this.agc = this.parent.sv_agcComboBox.getSelectedIndex();
        this.preamp = this.parent.sv_preampComboBox.getSelectedIndex();
        this.antenna = this.parent.sv_antennaComboBox.getSelectedIndex();
        this.attenuator = this.parent.sv_attenuatorComboBox.getSelectedIndex();
        this.stepSizeIndex = this.parent.sv_scanStepComboBox.getSelectedIndex();
        this.nb = this.parent.sv_blankerCheckBox.isSelected() ? 1 : 0;
        this.updateState();
    }

    public void defineFromString(String s) {
        try {
            String[] array = s.split(",");
            if (array.length == 11) {
                this.frequency = Long.parseLong(array[0]);
                this.mode = Integer.parseInt(array[1]);
                this.filter = Integer.parseInt(array[2]);
                this.agc = Integer.parseInt(array[3]);
                this.ctcss = Integer.parseInt(array[4]);
                this.stepSizeIndex = Integer.parseInt(array[5]);
                this.nb = Integer.parseInt(array[6]);
                this.preamp = Integer.parseInt(array[7]);
                this.antenna = Integer.parseInt(array[8]);
                this.attenuator = Integer.parseInt(array[9]);
                this.skipDuringScan = Integer.parseInt(array[10]);
                this.updateState();
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    @Override
    public String toString() {
        return String.format("%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d", this.frequency, this.mode, this.filter, this.agc, this.ctcss, this.stepSizeIndex, this.nb, this.preamp, this.antenna, this.attenuator, this.skipDuringScan);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    private void p(String s) {
        System.out.println(s);
    }

    private class defineButton
    extends TimerTask {
        private defineButton() {
        }

        @Override
        public void run() {
            if (MemoryButton.this.mouseEvent != null) {
                int button = MemoryButton.this.mouseEvent.getButton();
                if (button == 1) {
                    Beep.beep();
                    MemoryButton.this.defineButton = true;
                    MemoryButton.this.writeButton();
                } else if (button == 3 && MemoryButton.this.frequency >= 0L && MemoryButton.this.parent.askUser(String.format("Okay to erase memory %s?", MemoryButton.this.label))) {
                    MemoryButton.this.reset();
                }
                MemoryButton.this.updateState();
            }
        }
    }
}

