/*
 * Decompiled with CFR 0.152.
 */
package jrx;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Scanner;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import jrx.Beep;
import jrx.ConfigComsDialog;
import jrx.ConfigManager;
import jrx.ControlInterface;
import jrx.FreqDigit;
import jrx.MemoryButton;
import jrx.MemoryFunctions;
import jrx.MyTableCellRenderer;
import jrx.ParseComLine;
import jrx.RWCheckBox;
import jrx.RWComboBox;
import jrx.RWSlider;
import jrx.ScanFunctions;
import jrx.SweepScope;

public final class JRX
extends JFrame {
    final String appVersion = "3.2";
    final String appName;
    final String programName;
    String fileSep;
    String lineSep;
    String userDir;
    String userPath;
    String buttonFilePath;
    Timer periodicTimer;
    ParseComLine comArgs = null;
    ImageIcon redLed;
    ImageIcon greenLed;
    ImageIcon blueLed;
    ImageIcon yellowLed;
    ScanFunctions scanFunctions;
    ControlInterface[] settableControls;
    ArrayList<String> interfaceNames = null;
    ArrayList<FreqDigit> freqDigits = null;
    Map<String, Integer> radioCodes = null;
    Map<String, Double> filters = null;
    Map<String, Double> ctcss = null;
    Map<String, Double> scanSteps = null;
    Map<String, Integer> timeSteps = null;
    ArrayList<ControlInterface> controlList;
    int iErrorValue = -100;
    long defaultFrequency = 145000000L;
    int sv_displayState = 0;
    JButton[] stateButtons;
    String[] buttonLabels;
    int sv_hamrigWriteDelay = 12;
    int sv_hamrigPostWriteDelay = 2;
    int sv_hamrigRetries = 3;
    int sv_hamrigTimeout = 400;
    boolean sv_hamrigUseCustomSettings = false;
    int memoryButtonTotal = 200;
    int hamlibPort = 4532;
    String hamlibHost = "127.0.0.1";
    Socket hamlibSocket = null;
    InputStream hamlib_is = null;
    OutputStream hamlib_os = null;
    String hamlibExecPath = "rigctld";
    String radioData = null;
    Process hamlibDaemon = null;
    ConfigManager config = null;
    JFrame sv_frameDims = null;
    long sv_freq;
    int squelchLow = -100;
    int squelchHigh = 100;
    boolean isWindows;
    boolean inhibit;
    Font digitsFont;
    Font baseFont;
    File defaultFreqFile;
    File freqDirectory;
    String[][] freqData = null;
    TreeMap<String, MemoryButton> buttonMap;
    int MODE_CW = 0;
    int MODE_LSB = 1;
    int MODE_USB = 2;
    int MODE_AM = 3;
    int MODE_FM = 4;
    int MODE_WFM = 5;
    int defWidth = 800;
    int defHeight = 400;
    String sv_mostRecentButton = "";
    MemoryFunctions memoryFunctions;
    long digitFrequency = -1L;
    boolean slowRadio = false;
    int readBufferLen = 2048;
    byte[] readBuffer;
    boolean dcdCapable = false;
    boolean useJRXSquelch = false;
    int squelchOpen = -1;
    double signalStrength = 0.0;
    double oldVolume = -1.0;
    double oldFrequency = -1.0;
    Color darkGreen;
    Color darkBlue;
    Color darkRed;
    int comError = 0;
    long oldTime = 0L;
    private JPanel buttonPanel1;
    private JPanel buttonPanel2;
    private JPanel buttonPanel3;
    private JPanel buttonPanel4;
    private JPanel buttonPanel5;
    private JPanel buttonPanel6;
    private JPanel button_bar;
    private JLabel comErrorIconLabel;
    private JButton copyButton;
    private JButton copyMemButton;
    private JLabel dcdIconLabel;
    private JPanel digitsPanel;
    private JPanel digitsParent;
    private JButton eraseMemButton;
    protected JTable freqTable;
    private JButton helpButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private ButtonGroup jrxRadioButtonGroup;
    private JPanel listPanel;
    private JPanel memoryButtonsPanel;
    private JPanel memoryPanel;
    private JScrollPane memoryScrollPane;
    private JButton pasteMemButton;
    private JButton quitButton;
    private JButton radioListButton;
    private JButton radioMemoryButton;
    private JPanel radioPanel;
    private JButton radioScannerButton;
    private JPanel receiverPanel;
    private JButton scanDownButton;
    private JButton scanHelpButton;
    private JLabel scanIconLabel;
    private JButton scanStopButton;
    private JLabel scanTypeLabel;
    private JButton scanUpButton;
    private JPanel scannerPanel;
    private JPanel scopeControlLeftPanel;
    private JPanel scopeControlPanel;
    private JPanel scopeControlRightPanel;
    private JButton scopeDefaultsButton;
    private JPanel scopeDisplayPanel;
    private JPanel scopePanel;
    private JButton scopeScaleButton;
    protected JButton scopeStartStopButton;
    private JPanel signalPanel;
    private JProgressBar signalProgressBar;
    private JPanel sliderPanel;
    private JLabel speedIconLabel;
    protected JComboBox sv_agcComboBox;
    protected JCheckBox sv_anfCheckBox;
    protected JComboBox sv_antennaComboBox;
    protected JCheckBox sv_apfCheckBox;
    protected JComboBox sv_attenuatorComboBox;
    protected JCheckBox sv_blankerCheckBox;
    protected JCheckBox sv_ctcssCheckBox;
    protected JComboBox sv_ctcssComboBox;
    protected JCheckBox sv_dspCheckBox;
    protected JComboBox sv_dspComboBox;
    protected JComboBox<String> sv_dwellTimeComboBox;
    protected JComboBox<String> sv_filtersComboBox;
    protected JComboBox sv_ifShiftComboBox;
    protected JComboBox<String> sv_interfacesComboBox;
    protected JRadioButton sv_jrxToRadioButton;
    protected JComboBox<String> sv_modesComboBox;
    protected JComboBox sv_preampComboBox;
    protected JComboBox<String> sv_radioNamesComboBox;
    protected JRadioButton sv_radioToJrxButton;
    protected JCheckBox sv_rawSigCheckBox;
    protected JComboBox sv_rfGainComboBox;
    protected JComboBox<String> sv_scanSpeedComboBox;
    protected JComboBox<String> sv_scanStepComboBox;
    protected JCheckBox sv_scopeDotsCheckBox;
    protected JComboBox<String> sv_scopeSpeedComboBox;
    protected JComboBox<String> sv_scopeStepComboBox;
    protected JCheckBox sv_squelchCheckBox;
    protected JSlider sv_squelchSlider;
    protected JCheckBox sv_syncCheckBox;
    public JCheckBox sv_synthSquelchCheckBox;
    protected JComboBox<String> sv_timerIntervalComboBox;
    protected JCheckBox sv_volumeExitCheckBox;
    protected JSlider sv_volumeSlider;
    private JScrollPane tableScrollPane;
    private JButton tuneComsButton;
    private JPanel verticalListPanel;

    public JRX(String[] args) {
        this.comArgs = new ParseComLine(this, args);
        this.inhibit = true;
        this.oldTime = System.currentTimeMillis();
        this.sv_freq = this.defaultFrequency;
        this.readBuffer = new byte[this.readBufferLen];
        this.memoryFunctions = new MemoryFunctions(this);
        this.appName = this.getClass().getSimpleName();
        this.programName = this.appName + " " + "3.2";
        this.setTitle(this.programName);
        this.setIconImage(new ImageIcon(this.getClass().getResource("icons/JRX.png")).getImage());
        this.redLed = new ImageIcon(this.getClass().getResource("icons/red-on-16.png"));
        this.greenLed = new ImageIcon(this.getClass().getResource("icons/green-on-16.png"));
        this.blueLed = new ImageIcon(this.getClass().getResource("icons/blue-on-16.png"));
        this.yellowLed = new ImageIcon(this.getClass().getResource("icons/yellow-on-16.png"));
        this.lineSep = System.getProperty("line.separator");
        this.fileSep = System.getProperty("file.separator");
        this.userDir = System.getProperty("user.home");
        this.userPath = this.userDir + this.fileSep + "." + this.appName;
        this.buttonFilePath = this.userPath + this.fileSep + "memoryButtons.ini";
        new File(this.userPath).mkdirs();
        this.digitsFont = new Font("Monospaced", 0, 30);
        this.initComponents();
        this.stateButtons = new JButton[]{this.radioMemoryButton, this.radioListButton, this.radioScannerButton};
        this.buttonLabels = new String[]{"Radio:Buttons", "Radio:List", "Scope/Setup"};
        this.baseFont = new Font("Monospaced", 0, this.getFont().getSize());
        this.setFont(this.baseFont);
        this.scanFunctions = new ScanFunctions(this);
        this.setSize(this.defWidth, this.defHeight);
        this.setControlList();
        this.setupControls();
        this.setDefaultComboContent();
        this.config = new ConfigManager(this);
        if (!this.comArgs.reset) {
            this.config.read();
        }
        this.freqDirectory = new File(this.config.userPath + this.fileSep + "frequencies");
        if (!this.freqDirectory.exists()) {
            this.freqDirectory.mkdirs();
        }
        this.defaultFreqFile = new File(this.freqDirectory + this.fileSep + "default.tsv");
        this.writeFreqTable();
        this.populateFreqTable();
        this.inhibit = false;
        this.initialize();
    }

    private void setDisplayState(int v) {
        this.sv_displayState = v;
        this.configureDisplayState();
    }

    private void configureDisplayState() {
        CardLayout rcl = (CardLayout)this.radioPanel.getLayout();
        rcl.show(this.radioPanel, this.sv_displayState < 2 ? "receiverCard" : "scopeCard");
        CardLayout mcl = (CardLayout)this.memoryPanel.getLayout();
        mcl.show(this.memoryPanel, this.sv_displayState == 0 ? "memoryCard" : "tableCard");
        int i = 0;
        for (JButton b : this.stateButtons) {
            b.setText(i == this.sv_displayState ? String.format("<html><b>%s</b>", this.buttonLabels[i]) : this.buttonLabels[i]);
            ++i;
        }
    }

    private void writeFreqTable() {
        block27: {
            try {
                if (this.defaultFreqFile.exists()) break block27;
                try (InputStream is = this.getClass().getResourceAsStream("frequencies/default.tsv");){
                    InputStreamReader isr = new InputStreamReader(is);
                    BufferedReader br = new BufferedReader(isr);
                    try (FileWriter fw = new FileWriter(this.defaultFreqFile);){
                        String line;
                        while ((line = br.readLine()) != null) {
                            fw.write(line + "\n");
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void populateFreqTable() {
        int row = 0;
        String[] header = null;
        ArrayList<ArrayList<String>> freqList = new ArrayList<ArrayList<String>>();
        try {
            void var8_11;
            Object[] list = this.freqDirectory.listFiles();
            Arrays.sort(list);
            Object[] arr$ = list;
            int len$ = arr$.length;
            boolean bl = false;
            while (var8_11 < len$) {
                Object fn = arr$[var8_11];
                String name = ((File)fn).getName();
                if (name.matches("(?i).*\\.tsv$")) {
                    name = name.replaceFirst("(?i)\\.tsv$", "");
                    List<String> records = Files.readAllLines(Paths.get(((File)fn).toString(), new String[0]), Charset.forName("UTF-8"));
                    int frow = 0;
                    for (String record : records) {
                        ArrayList<String> fields = new ArrayList<String>(Arrays.asList(record.split("\t")));
                        if (fields.size() <= 2) continue;
                        if (frow == 0 && row == 0) {
                            fields.add(0, "File");
                            header = fields.toArray(new String[0]);
                        } else if (frow != 0) {
                            fields.add(0, name);
                            freqList.add(fields);
                        }
                        ++frow;
                        ++row;
                    }
                }
                ++var8_11;
            }
            int i = 0;
            this.freqData = new String[row][];
            for (ArrayList arrayList : freqList) {
                this.freqData[i] = arrayList.toArray(new String[0]);
                ++i;
            }
            DefaultTableModel dtm = new DefaultTableModel(this.freqData, header){

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            };
            this.freqTable.setModel(dtm);
            MyTableCellRenderer myTableCellRenderer = new MyTableCellRenderer();
            this.freqTable.setDefaultRenderer(Object.class, myTableCellRenderer);
            this.freqTable.setSelectionMode(2);
            ListSelectionModel rowSM = this.freqTable.getSelectionModel();
            rowSM.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    try {
                        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                        if (!lsm.isSelectionEmpty()) {
                            JRX.this.scanFunctions.stopScan(false);
                            int row = lsm.getMinSelectionIndex();
                            String mode = JRX.this.freqData[row][2];
                            double freq = Double.parseDouble(JRX.this.freqData[row][3]);
                            JRX.this.frequencyToDigits((long)(freq * 1000000.0 + 0.5));
                            RWComboBox box = (RWComboBox)JRX.this.sv_modesComboBox;
                            mode = "Mode " + mode.toUpperCase();
                            JRX.this.sv_modesComboBox.setSelectedIndex(box.displayMap.get(mode));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    private void startCyclicalTimer() {
        if (this.comArgs.runTimer) {
            if (this.periodicTimer != null) {
                this.periodicTimer.cancel();
            }
            this.periodicTimer = new Timer();
            this.resetTimer();
        }
    }

    private void resetTimer() {
        long delay = (long)((RWComboBox)this.sv_timerIntervalComboBox).getConvertedValue();
        if (delay > 0L && this.periodicTimer != null) {
            this.periodicTimer.schedule((TimerTask)new PeriodicEvents(), delay);
        }
    }

    private void setComErrorIcon() {
        if (this.comError > 0) {
            if (--this.comError > 0) {
                this.comErrorIconLabel.setIcon(this.redLed);
            }
        } else {
            this.comErrorIconLabel.setIcon(this.greenLed);
        }
    }

    protected void updateScanControls() {
        this.sv_scanStepComboBox.setEnabled(this.scanFunctions.scanTimer == null);
        this.sv_scanSpeedComboBox.setEnabled(this.scanFunctions.scanTimer == null);
        String label = "Scan";
        String toolTip = "No active scan";
        if (this.scanFunctions.scanTimer != null) {
            label = this.scanFunctions.programScan ? "Pscan" : "Mscan";
            toolTip = this.scanFunctions.programScan ? "Program scan: scans memory locations" : "Memory scan: scans between two defined frequencies";
        } else {
            this.memoryFunctions.resetButtonColors();
        }
        this.scanTypeLabel.setText(label);
        this.scannerPanel.setToolTipText(toolTip);
        this.scanIconLabel.setIcon(this.scanFunctions.validState() ? this.greenLed : this.redLed);
    }

    private void initialize() {
        if (!this.inhibit) {
            this.configureDisplayState();
            this.oldFrequency = -1.0;
            this.dcdIconLabel.setText("");
            this.dcdIconLabel.setIcon(this.greenLed);
            this.setupHamlibDaemon();
            this.inhibit = true;
            this.setComboBoxScales();
            this.inhibit = false;
            if (this.sv_jrxToRadioButton.isSelected()) {
                this.setFrequency();
                this.writeRadioControls();
            }
            this.setRadioSquelch();
            this.readRadioControls(true);
            this.startCyclicalTimer();
            this.measureSpeed();
            this.setComErrorIcon();
            this.frequencyToDigits(this.sv_freq);
            this.memoryScrollPane.getVerticalScrollBar().setUnitIncrement(8);
            this.getActiveTab();
        }
    }

    private void readRadioControls(boolean all) {
        if (all || this.sv_syncCheckBox.isSelected()) {
            this.readFrequency();
            for (ControlInterface cont : this.controlList) {
                cont.selectiveReadValue(all);
            }
        }
    }

    private void writeRadioControls() {
        for (ControlInterface cont : this.controlList) {
            cont.writeValue(true);
        }
    }

    protected String getMode(int n) {
        String s = "";
        RWComboBox box = (RWComboBox)this.sv_modesComboBox;
        if (n >= 0 && n < box.reverseUseMap.size()) {
            s = box.reverseUseMap.get(n);
        }
        return s;
    }

    private void measureSpeed() {
        long t = System.currentTimeMillis();
        this.oldFrequency = -1.0;
        this.setFrequency(this.sv_freq);
        long dt = System.currentTimeMillis() - t;
        this.slowRadio = dt > 75L;
        this.speedIconLabel.setText("");
        this.speedIconLabel.setIcon(this.slowRadio ? this.redLed : this.greenLed);
        this.speedIconLabel.setToolTipText(this.slowRadio ? "Slow radio coms" : "Fast radio coms");
        if (this.comArgs.debug >= 0) {
            this.p("radio com ms delay: " + dt);
        }
    }

    private void setDefaultComboContent() {
        ((RWComboBox)this.sv_filtersComboBox).comboPlaceholderData();
        ((RWComboBox)this.sv_ctcssComboBox).comboPlaceholderData();
        ((RWComboBox)this.sv_preampComboBox).comboPlaceholderData();
        ((RWComboBox)this.sv_attenuatorComboBox).comboPlaceholderData();
        ((RWComboBox)this.sv_modesComboBox).comboPlaceholderData();
    }

    private void setControlList() {
        Component[] list;
        this.controlList = new ArrayList();
        for (Component comp : list = new Component[]{this.sv_squelchSlider, this.sv_volumeSlider, this.sv_rfGainComboBox, this.sv_ifShiftComboBox, this.sv_dspComboBox, this.sv_dspCheckBox, this.sv_modesComboBox, this.sv_filtersComboBox, this.sv_antennaComboBox, this.sv_attenuatorComboBox, this.sv_agcComboBox, this.sv_preampComboBox, this.sv_ctcssComboBox, this.sv_ctcssCheckBox, this.sv_blankerCheckBox, this.sv_apfCheckBox, this.sv_anfCheckBox}) {
            this.controlList.add((ControlInterface)((Object)comp));
        }
    }

    public String recurseSearch(File dir, Pattern search) {
        String result = null;
        File[] listFile = dir.listFiles();
        if (listFile != null) {
            for (File f : listFile) {
                if (f.isDirectory()) {
                    result = this.recurseSearch(f, search);
                    if (result == null) continue;
                    return result;
                }
                if (!search.matcher(f.getName()).matches()) continue;
                return f.getPath();
            }
        }
        return result;
    }

    private String findHamlibOnWindows() {
        File f = new File(".");
        Pattern p = Pattern.compile("(?i).*?" + this.hamlibExecPath + "\\.exe.*");
        return this.recurseSearch(f, p);
    }

    private void initTimeValues(RWComboBox timebox) {
        timebox.removeAllItems();
        double[] msteps = new double[]{1.0, 2.0, 5.0};
        double bv = 10.0;
        for (int p = 0; p <= 3; ++p) {
            for (double lv : msteps) {
                double v = bv * lv;
                String sl = v >= 1000.0 ? String.format("%d s", (int)(v / 1000.0)) : String.format("%d ms", (int)v);
                timebox.addListItem(sl, v, "" + v);
            }
            bv *= 10.0;
        }
        timebox.addListItem("Off", 0.0, "0");
        timebox.setSelectedIndex(5);
    }

    private void initScanValues(JComboBox<String> stepbox, int initstep, JComboBox<String> speedbox, int initspeed) {
        String sl;
        double v;
        int p;
        double bv;
        double[] msteps = new double[]{1.0, 2.0, 5.0};
        if (stepbox != null) {
            stepbox.removeAllItems();
            this.scanSteps = new TreeMap<String, Double>();
            bv = 1.0;
            for (p = 0; p <= 7; ++p) {
                for (double lv : msteps) {
                    v = bv * lv;
                    sl = this.stepLabel(v);
                    this.scanSteps.put(sl, v);
                    stepbox.addItem(sl);
                }
                bv *= 10.0;
            }
            this.setComboBoxIndex(stepbox, initstep);
        }
        if (speedbox != null) {
            speedbox.removeAllItems();
            this.timeSteps = new TreeMap<String, Integer>();
            bv = 1.0;
            for (p = 0; p <= 4; ++p) {
                for (double lv : msteps) {
                    v = bv * lv;
                    sl = v >= 1000.0 ? String.format("%d s", (int)(v / 1000.0)) : String.format("%d ms", (int)v);
                    this.timeSteps.put(sl, (int)v);
                    speedbox.addItem(sl);
                }
                bv *= 10.0;
            }
            this.setComboBoxIndex(speedbox, initspeed);
        }
    }

    private void setupControls() {
        this.sv_frameDims = this;
        this.speedIconLabel.setText("");
        this.scanIconLabel.setText("");
        this.comErrorIconLabel.setText("");
        this.darkGreen = new Color(0, 128, 0);
        this.darkBlue = new Color(0, 0, 128);
        this.darkRed = new Color(128, 0, 0);
        String os = System.getProperty("os.name").toLowerCase();
        boolean bl = this.isWindows = os.indexOf("win") >= 0;
        if (this.isWindows) {
            this.hamlibExecPath = this.findHamlibOnWindows();
            if (this.hamlibExecPath == null) {
                JOptionPane.showMessageDialog(this, String.format("Error: Cannot find hamlib executable \"%s\"\nCannot continue. Please visit http://arachnoid.com/JRX for help.", this.hamlibExecPath));
                System.exit(0);
            }
            this.hamlibExecPath = "\"" + this.hamlibExecPath + "\"";
            if (this.comArgs.debug >= 0) {
                this.p("have windows exec: " + this.hamlibExecPath);
            }
        }
        this.setComboBoxContent((RWComboBox)this.sv_rfGainComboBox, "RF", 0, 100, 5, 0, 100, 0, 1, 100);
        this.setComboBoxContent((RWComboBox)this.sv_ifShiftComboBox, "IF", -50, 50, 5, -50, 50, 0, 0, 0);
        this.setComboBoxContent((RWComboBox)this.sv_dspComboBox, "DSP", 0, 100, 5, 0, 100, 0, 1, 0);
        this.setComboBoxContent((RWComboBox)this.sv_agcComboBox, "AGC", 0, 10, 1, 0, 1, 0, 10, 1);
        this.setComboBoxContent((RWComboBox)this.sv_antennaComboBox, "Ant", 0, 4, 1, 0, 1, 0, 1, 1);
        this.initInterfaceList();
        this.initRigSpecs();
        this.initDigits();
        this.readMemoryButtons();
        this.initTimeValues((RWComboBox)this.sv_timerIntervalComboBox);
        this.initScanValues(this.sv_scanStepComboBox, 12, this.sv_scanSpeedComboBox, 5);
        this.initScanValues(null, 0, this.sv_dwellTimeComboBox, 10);
        this.initScanValues(this.sv_scopeStepComboBox, 12, this.sv_scopeSpeedComboBox, 0);
        this.memoryButtonsPanel.setBackground(new Color(128, 200, 220));
        this.sliderPanel.setBackground(new Color(192, 200, 192));
        this.listPanel.setBackground(new Color(200, 220, 240));
        this.scannerPanel.setBackground(new Color(240, 240, 220));
        this.scopeControlLeftPanel.setBackground(new Color(240, 240, 220));
        this.scopeControlRightPanel.setBackground(new Color(200, 220, 240));
        this.receiverPanel.setBackground(Color.black);
        this.memoryPanel.setBackground(Color.black);
        this.digitsParent.setToolTipText("<html>Tune each digit:<ul><li>Mouse wheel (\u2743): up, down</li><li>Mouse click top: up</li><li>Mouse click bottom: down</li></ul></html>");
        this.updateScanControls();
    }

    private void enableDSP() {
        this.sv_dspCheckBox.setSelected(true);
        ((RWCheckBox)this.sv_dspCheckBox).actionPerformed(null);
    }

    private void getRigCaps() {
        String com = "\\dump_caps";
        this.radioData = this.sendRadioCom(com, 3, false);
        this.enableControlCap(this.sv_ctcssComboBox, this.radioData, "(?ism).*^Can set CTCSS Squelch:\\s+Y$", false);
        this.enableControlCap(this.sv_agcComboBox, this.radioData, "(?ism).*^Set level:.*?AGC\\(", true);
        this.enableControlCap(this.sv_antennaComboBox, this.radioData, "(?ism).*^Can set Ant:\\s+Y$", false);
        this.enableControlCap(this.sv_preampComboBox, this.radioData, "(?ism).*^Set level:.*?PREAMP\\(", true);
        this.enableControlCap(this.sv_volumeSlider, this.radioData, "(?ism).*^Set level:.*?AF\\(", true);
        this.enableControlCap(this.sv_rfGainComboBox, this.radioData, "(?ism).*^Set level:.*?RF\\(", true);
        this.enableControlCap(this.sv_squelchSlider, this.radioData, "(?ism).*^Set level:.*?SQL\\(", true);
        this.enableControlCap(this.sv_ifShiftComboBox, this.radioData, "(?ism).*^Set level:.*?IF\\(", true);
        this.enableControlCap(this.sv_blankerCheckBox, this.radioData, "(?ism).*^Set functions:.*?\\sNB\\s", false);
        this.enableControlCap(this.sv_anfCheckBox, this.radioData, "(?ism).*^Set functions:.*?\\sANF\\s", false);
        this.enableControlCap(this.sv_apfCheckBox, this.radioData, "(?ism).*^Set functions:.*?\\sAPF\\s", false);
        this.enableControlCap(this.sv_dspComboBox, this.radioData, "(?ism).*^Set level:.*?NR\\(", true);
        String s = this.sendRadioCom("\\get_dcd", 0, false);
        this.dcdCapable = s != null && s.matches("\\d+");
        this.setSquelchScheme();
    }

    private void setSquelchScheme() {
        boolean stateFlag;
        this.sv_synthSquelchCheckBox.setEnabled(true);
        this.useJRXSquelch = this.sv_synthSquelchCheckBox.isSelected();
        this.enableControlCap(this.sv_squelchSlider, this.radioData, "(?ism).*^Set level:.*?SQL\\(", true);
        if (this.useJRXSquelch) {
            this.sv_squelchSlider.setEnabled(true);
        }
        ((RWSlider)this.sv_squelchSlider).commOK = stateFlag = !this.useJRXSquelch;
        this.setRadioSquelch();
        this.dcdIconLabel.setIcon(this.dcdCapable ? this.greenLed : (this.useJRXSquelch ? this.yellowLed : this.redLed));
        this.dcdIconLabel.setToolTipText(stateFlag ? "Radio provides squelch scheme" : (this.useJRXSquelch ? "JRX provides squelch scheme" : "No squelch scheme enabled"));
        if (this.comArgs.debug >= 0) {
            this.p("DCD capable: " + this.dcdCapable);
        }
        ((RWSlider)this.sv_squelchSlider).writeValue(false);
        ((RWSlider)this.sv_volumeSlider).writeValue(false);
        this.getSquelch(true);
        this.updateScanControls();
    }

    private void setRadioSquelch() {
        if (this.useJRXSquelch) {
            String com = String.format("L SQL 0", new Object[0]);
            this.sendRadioCom(com, 0, false);
        }
        this.oldVolume = -1.0;
        this.squelchOpen = -1;
    }

    private void readMemoryButtons() {
        this.memoryFunctions.layoutButtons(this.memoryButtonsPanel);
        this.memoryFunctions.readButtonsFromFile(this.buttonFilePath, this.buttonMap);
    }

    private void writeMemoryButtons() {
        this.memoryFunctions.writeButtonsToFile(this.buttonFilePath, this.buttonMap);
    }

    protected String stepLabel(double v) {
        int i;
        String[] labels = new String[]{"Hz", "kHz", "MHz"};
        double tv = 1.0;
        for (i = 0; i < labels.length && !(v < tv * 1000.0); ++i) {
            tv *= 1000.0;
        }
        String s = String.format("%.0f %s", v / tv, labels[i]);
        return s;
    }

    protected double getScanStep(JComboBox box) {
        return this.scanSteps.get((String)box.getSelectedItem());
    }

    protected double getTimeStep(JComboBox box) {
        return this.timeSteps.get((String)box.getSelectedItem()).intValue();
    }

    protected ArrayList<MemoryButton> getScanButtons(int max) {
        ArrayList<MemoryButton> array = null;
        boolean validFreqs = false;
        try {
            int n;
            if (this.sv_mostRecentButton == null || !this.sv_mostRecentButton.matches("(?i)^m.*")) {
                this.sv_mostRecentButton = "M001";
            }
            array = new ArrayList<MemoryButton>();
            Iterator<MemoryButton> ss = this.buttonMap.tailMap(this.sv_mostRecentButton).values().iterator();
            for (n = 0; ss.hasNext() && n < max; ++n) {
                MemoryButton button = ss.next();
                if (button.frequency < 0L) break;
                array.add(button);
                boolean skip = button.skipDuringScan != 0;
                button.updateState(this.darkGreen);
                if (skip) continue;
                validFreqs = true;
            }
            if (n < 2) {
                validFreqs = false;
                array = new ArrayList();
                ArrayList revList = new ArrayList(this.buttonMap.headMap(this.sv_mostRecentButton, true).values());
                Collections.reverse(revList);
                ss = revList.iterator();
                for (n = 0; ss.hasNext() && n < max; ++n) {
                    MemoryButton button = ss.next();
                    if (button.frequency < 0L) break;
                    array.add(button);
                    boolean skip = button.skipDuringScan != 0;
                    button.updateState(this.darkGreen);
                    if (skip) continue;
                    validFreqs = true;
                }
                Collections.reverse(array);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        if (!validFreqs) {
            this.noValidFrequenciesPrompt();
            return null;
        }
        return array;
    }

    protected void noValidFrequenciesPrompt() {
        this.tellUser("<html>No valid memory buttons in range<br/>or all set to <span color=\"blue\">\"skip in memory scan\"</span>");
    }

    protected double getComboBoxTimeStep(JComboBox box) {
        return this.timeSteps.get((String)box.getSelectedItem()).intValue();
    }

    protected void waitMS(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    protected void sleep(JComboBox box) {
        double v = this.getComboBoxTimeStep(box);
        this.waitMS((int)v);
    }

    protected double ntrp(double xa, double xb, double ya, double yb, double x) {
        return (x - xa) * (yb - ya) / (xb - xa) + ya;
    }

    protected int intrp(double xa, double xb, double ya, double yb, double x) {
        return (int)this.ntrp(xa, xb, ya, yb, x);
    }

    protected boolean testSquelch() {
        boolean so = this.squelchOpen == 1 && this.sv_squelchCheckBox.isSelected();
        this.scanIconLabel.setIcon(so && this.scanFunctions.scanTimer != null ? this.redLed : this.greenLed);
        return so;
    }

    protected void getSquelch(boolean force) {
        int sqOpen = this.iErrorValue;
        if (this.dcdCapable && !this.useJRXSquelch) {
            String s;
            if (this.comArgs.debug < 2 && (s = this.sendRadioCom("\\get_dcd", 1, false)) != null) {
                sqOpen = s.trim().equals("1") ? 1 : 0;
            }
        } else if (!this.useJRXSquelch) {
            sqOpen = 1;
        } else {
            double sv = ((ControlInterface)((Object)this.sv_squelchSlider)).getConvertedValue();
            int n = sqOpen = this.signalStrength > (sv = this.ntrp(0.0, 1.0, this.squelchLow, this.squelchHigh, sv)) ? 1 : 0;
        }
        if (sqOpen != this.iErrorValue && sqOpen != this.squelchOpen || force) {
            this.squelchOpen = sqOpen;
            this.setVolume(this.squelchOpen == 1);
        }
    }

    protected double freqStrength(long v) {
        if (v > 0L) {
            long t1 = System.currentTimeMillis();
            this.oldFrequency = -1.0;
            this.setFrequency(v);
            this.getSignalStrength();
            long t2 = System.currentTimeMillis();
            double dt = (double)(t2 - t1) / 1000.0;
            if (this.comArgs.debug >= 1) {
                this.p(String.format("scope sample delay: %f", dt));
            }
        }
        return this.signalStrength;
    }

    private void setComboBoxContent(RWComboBox box, String label, int start, int end, int step, int xlow, int xhigh, int ylow, int yhigh, int initial) {
        box.removeAllItems();
        for (int i = start; i <= end; i += step) {
            String s = String.format("%s %d", label, i);
            box.addListItem(s, i, "" + i);
        }
        box.setXLow(xlow);
        box.setXHigh(xhigh);
        if (yhigh > ylow) {
            box.setYLow(ylow);
            box.setYHigh(yhigh);
        }
        box.setSelectedIndex(box.useMap.get("" + initial));
    }

    private void initDigits() {
        this.digitsPanel.removeAll();
        this.digitsParent.setBackground(Color.black);
        this.digitsPanel.setBackground(Color.black);
        ((FlowLayout)this.digitsPanel.getLayout()).setHgap(0);
        this.freqDigits = new ArrayList();
        FreqDigit ofd = this.setupDigits(this.freqDigits, 4, null, 1.0f);
        FreqDigit fd = new FreqDigit(this, -1, 1.0f);
        this.digitsPanel.add(fd);
        ofd = this.setupDigits(this.freqDigits, 3, ofd, 1.0f);
        fd = new FreqDigit(this, -1, 1.0f);
        this.digitsPanel.add(fd);
        this.setupDigits(this.freqDigits, 3, ofd, 0.7f);
    }

    private FreqDigit setupDigits(ArrayList<FreqDigit> digits, int n, FreqDigit ofd, float size) {
        for (int i = 0; i < n; ++i) {
            FreqDigit fd = new FreqDigit(this, 0, size);
            this.digitsPanel.add(fd);
            if (ofd != null) {
                fd.setCarry(ofd);
            }
            ofd = fd;
            digits.add(fd);
        }
        return ofd;
    }

    protected void readFrequency() {
        try {
            String sf = this.sendRadioCom("f", 0, false);
            long v = Long.parseLong(sf);
            this.frequencyToDigits(v);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void setFrequency() {
        this.frequencyToDigits(this.sv_freq);
    }

    public void frequencyToDigits(long v) {
        this.digitFrequency = this.sv_freq = v;
        ListIterator<FreqDigit> rev = this.freqDigits.listIterator(this.freqDigits.size());
        while (rev.hasPrevious()) {
            FreqDigit fd = rev.previous();
            fd.setDigit(v % 10L);
            fd.setBright(v != 0L);
            v /= 10L;
        }
        this.setFrequency(this.sv_freq);
    }

    protected void digitsToFrequency() {
        if (this.validSetup()) {
            this.digitFrequency = 0L;
            for (FreqDigit fd : this.freqDigits) {
                this.digitFrequency = this.digitFrequency * 10L + fd.getValue();
                fd.setBright(this.digitFrequency != 0L);
            }
        }
        if (!this.slowRadio && this.scanFunctions.scanTimer == null) {
            this.sv_freq = this.digitFrequency;
            this.setFrequency(this.sv_freq);
        }
    }

    public void setFrequency(long v) {
        try {
            if (this.validSetup()) {
                if (v < 0L) {
                    v = this.sv_freq;
                }
                if (v < 0L) {
                    throw new Exception("frequency <= 0");
                }
                if (this.oldFrequency != (double)v) {
                    this.sv_freq = v;
                    String com = String.format("F %d", v);
                    this.sendRadioCom(com, 0, true);
                    this.oldFrequency = v;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    private void timerUpdateFreq() {
        if (this.digitFrequency >= 0L && this.digitFrequency != this.sv_freq) {
            this.frequencyToDigits(this.digitFrequency);
        }
    }

    protected boolean validSetup() {
        return !this.inhibit;
    }

    public String getMode() {
        String s = null;
        if (this.validSetup()) {
            s = (String)this.sv_modesComboBox.getSelectedItem();
        }
        return s;
    }

    private void initInterfaceList() {
        this.sv_interfacesComboBox.removeAllItems();
        this.sv_interfacesComboBox.addItem("-- Interfaces --");
        if (this.isWindows) {
            for (int i = 1; i <= 16; ++i) {
                this.sv_interfacesComboBox.addItem(String.format("COM%d", i));
            }
        } else {
            String data = this.runSysCommand(new String[]{"bash", "-c", "echo /dev/ttyS* /dev/ttyUSB* /dev/video*"}, true);
            if (this.comArgs.debug >= 1) {
                this.p("serial list output: [" + data + "]");
            }
            for (String s : data.split("\\s+")) {
                if (s.matches(".*\\*.*")) continue;
                this.sv_interfacesComboBox.addItem(s);
            }
        }
    }

    private void setComboBoxScales() {
        ((RWComboBox)this.sv_preampComboBox).setGenericComboBoxScale("Pre", "(?ism).*^Preamp:\\s*(.*?)\\s*$.*", true, true);
        ((RWComboBox)this.sv_attenuatorComboBox).setGenericComboBoxScale("Att", "(?ism).*^Attenuator:\\s*(.*?)\\s*$.*", true, true);
        ((RWComboBox)this.sv_filtersComboBox).setGenericComboBoxScale("", "", true, true);
        ((RWComboBox)this.sv_modesComboBox).setGenericComboBoxScale("Mode", "(?ism).*^Mode list:\\s*(.*?)\\s*$.*", false, false);
        ((RWComboBox)this.sv_ctcssComboBox).setGenericComboBoxScale("CTCSS", "(?ism).*^CTCSS:\\s*(.*?)\\s*$.*", false, true);
    }

    private void initRigSpecs() {
        this.radioCodes = new TreeMap<String, Integer>();
        String s = this.runSysCommand(new String[]{this.hamlibExecPath, "-l"}, true);
        if (this.comArgs.debug >= 1) {
            this.p("dump from rigctld -l: [" + s + "]");
        }
        for (String item : s.split(this.lineSep)) {
            if (item.length() <= 30) continue;
            try {
                String a;
                String parse;
                String[] fields;
                if (this.comArgs.debug >= 1) {
                    this.p("rigctl radio description line: [" + item + "]");
                }
                if ((fields = (parse = item.replaceFirst("^\\s*(\\S+)\\s*(.*)$", "$1\t$2")).split("\t")) == null || fields.length <= 1 || !(a = fields[0].trim()).matches("[0-9]+") || fields[1].length() <= 47) continue;
                String b = fields[1].substring(0, 47).trim();
                b = b.replaceAll("\\s+", " ");
                int v = Integer.parseInt(a);
                if (this.comArgs.debug >= 1) {
                    this.p("radio record: " + b + " = " + v);
                }
                this.radioCodes.put(b, v);
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
        this.sv_radioNamesComboBox.removeAllItems();
        this.sv_radioNamesComboBox.addItem("-- Radios --");
        for (String key : this.radioCodes.keySet()) {
            int val = this.radioCodes.get(key);
            this.sv_radioNamesComboBox.addItem(key);
        }
    }

    private String runSysCommand(String[] array, boolean read) {
        String result = "";
        try {
            Process p = new ProcessBuilder(array).redirectErrorStream(true).start();
            if (read) {
                result = new Scanner(p.getInputStream()).useDelimiter("\\Z").next();
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        return result;
    }

    protected boolean askUser(String prompt) {
        Beep.beep();
        int choice = JOptionPane.showConfirmDialog(this, prompt);
        return choice == 0;
    }

    protected void tellUser(String prompt) {
        Beep.beep();
        JOptionPane.showMessageDialog(this, prompt);
    }

    private void setupHamlibDaemon() {
        if (!this.inhibit) {
            this.closeConnection();
            String interfaceName = null;
            String rigName = null;
            int rigCode = -1;
            if (this.comArgs.rigName != null) {
                rigName = this.comArgs.rigName;
                this.sv_radioNamesComboBox.setSelectedItem(rigName);
                this.sv_radioNamesComboBox.setEnabled(false);
                try {
                    rigCode = this.radioCodes.get(rigName);
                }
                catch (Exception e) {
                    this.tellUser(String.format("Error: rig name \"%s\" not known.", rigName));
                    this.sv_radioNamesComboBox.setEnabled(true);
                }
            }
            if (this.comArgs.rigCode >= 0 && rigCode == -1) {
                rigCode = this.comArgs.rigCode;
                rigName = String.format("(radio code: %d)", rigCode);
                this.sv_radioNamesComboBox.setEnabled(false);
            }
            if (this.comArgs.interfaceName != null) {
                interfaceName = this.comArgs.interfaceName;
                this.sv_interfacesComboBox.setSelectedItem(interfaceName);
                this.sv_interfacesComboBox.setEnabled(false);
            } else if (this.sv_interfacesComboBox.getSelectedIndex() > 0) {
                interfaceName = (String)this.sv_interfacesComboBox.getSelectedItem();
            }
            if (rigCode == -1 && this.sv_radioNamesComboBox.getSelectedIndex() > 0) {
                rigName = (String)this.sv_radioNamesComboBox.getSelectedItem();
                rigCode = this.radioCodes.get(rigName);
            }
            if (rigCode >= 0 && interfaceName != null) {
                String[] com = this.sv_hamrigUseCustomSettings ? new String[]{this.hamlibExecPath, String.format("--set-conf=write_delay=%d", this.sv_hamrigWriteDelay), String.format("--set-conf=post_write_delay=%d", this.sv_hamrigPostWriteDelay), String.format("--set-conf=retry=%d", this.sv_hamrigRetries), String.format("--set-conf=timeout=%d", this.sv_hamrigTimeout), "-m", "" + rigCode, "-r", interfaceName} : new String[]{this.hamlibExecPath, "-m", "" + rigCode, "-r", interfaceName};
                if (this.comArgs.debug >= 0) {
                    this.p("setup daemon with: " + rigName + "," + rigCode + "," + interfaceName);
                }
                try {
                    this.hamlibDaemon = new ProcessBuilder(com).redirectErrorStream(true).start();
                    boolean connected = false;
                    int n = 5;
                    while (!connected && n >= 0) {
                        try {
                            this.hamlibSocket = new Socket(this.hamlibHost, this.hamlibPort);
                            this.hamlibSocket.setKeepAlive(true);
                            this.hamlibSocket.setTcpNoDelay(true);
                            this.hamlib_is = this.hamlibSocket.getInputStream();
                            this.hamlib_os = this.hamlibSocket.getOutputStream();
                            connected = true;
                            if (this.comArgs.debug < 0) continue;
                            this.p("socket connected: " + connected);
                        }
                        catch (Exception e) {
                            if (this.comArgs.debug >= 0) {
                                this.p("fail connect " + e.getMessage());
                            }
                            this.waitMS(500);
                            if (n-- > 0) continue;
                            this.tellUser("Error: Cannot connect to Hamlib Daemon process.");
                        }
                    }
                    this.getRigCaps();
                }
                catch (Exception e) {
                    e.printStackTrace(System.out);
                }
            }
        }
    }

    private void enableControlCap(Component cc, String source, String search, boolean level) {
        boolean enabled = source != null && source.matches(search + ".*");
        cc.setEnabled(enabled);
        if (enabled && level) {
            try {
                if (cc instanceof ControlInterface) {
                    String range = source.replaceFirst(search + "([0-9+-]+)\\.\\.([0-9+-]+).*", "$1,$2");
                    String[] digits = range.split(",");
                    int low = Integer.parseInt(digits[0]);
                    int high = Integer.parseInt(digits[1]);
                    if (high - low == 0) {
                        low = 0;
                        high = 1;
                    }
                    ControlInterface box = (ControlInterface)((Object)cc);
                    box.setYLow(low);
                    box.setYHigh(high);
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
    }

    private String readInputStream(InputStream is) {
        StringBuilder sb = new StringBuilder();
        try {
            int len;
            do {
                if ((len = is.read(this.readBuffer, 0, this.readBufferLen)) < 0) continue;
                sb.append(new String(this.readBuffer, 0, len));
            } while (len == this.readBufferLen);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        return sb.toString().trim();
    }

    protected String sendRadioCom(String s, int localDebug, boolean writeMode) {
        String result = null;
        if (this.validSetup() && this.hamlibDaemon != null && this.hamlibSocket != null && s != null && this.hamlibSocket.isConnected()) {
            try {
                this.hamlib_os.write((s + this.lineSep).getBytes());
                this.hamlib_os.flush();
                if (this.comArgs.debug >= localDebug) {
                    this.p("sendradiocom   emit: [" + s + "]");
                }
                result = this.readInputStream(this.hamlib_is);
                if (this.comArgs.debug >= localDebug) {
                    this.p("sendradiocom result: [" + result.replaceAll("[\r\n]", " ") + "]");
                }
                if (result.matches("(?i).*RPRT -.*")) {
                    this.comError = 2;
                    result = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
        return result;
    }

    protected void setVolume(boolean squelchOpen) {
        double volume = ((ControlInterface)((Object)this.sv_volumeSlider)).getConvertedValue();
        double d = volume = squelchOpen ? volume : 0.0;
        if (volume != this.oldVolume) {
            this.setVolumeDirect(volume);
            this.oldVolume = volume;
        }
    }

    private void setVolumeDirect(double v) {
        String com = String.format("L AF %.2f", v);
        this.sendRadioCom(com, 0, true);
        ((RWSlider)this.sv_volumeSlider).oldLevel = -1.0;
    }

    private void squelchOnExit() {
        ((RWSlider)this.sv_squelchSlider).writeValue(true);
    }

    private void closeConnection() {
        try {
            if (this.periodicTimer != null) {
                this.periodicTimer.cancel();
                this.periodicTimer = null;
            }
            if (this.sv_volumeExitCheckBox.isSelected()) {
                this.setVolumeDirect(0.0);
            }
            this.squelchOnExit();
            if (this.hamlibSocket != null) {
                this.hamlibSocket.close();
                this.waitMS(100);
                this.hamlibSocket = null;
            }
            if (this.hamlibDaemon != null) {
                this.hamlibDaemon.destroy();
                this.waitMS(100);
                this.hamlibDaemon = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    private void setComboBoxIndex(JComboBox box, int index) {
        index = Math.max(0, index);
        index = Math.min(index, box.getItemCount() - 1);
        box.setSelectedIndex(index);
    }

    protected SweepScope getScopePanel() {
        return (SweepScope)this.scopeDisplayPanel;
    }

    private boolean testRawSignalMode() {
        boolean raw = this.sv_rawSigCheckBox.isSelected();
        if (raw) {
            this.squelchLow = -256;
            this.squelchHigh = 256;
        } else {
            this.squelchLow = -100;
            this.squelchHigh = 100;
        }
        return raw;
    }

    protected void getSignalStrength() {
        try {
            String com;
            String result;
            if (this.comArgs.debug < 2 && (result = this.sendRadioCom(com = this.testRawSignalMode() ? "l RAWSTR" : "l STRENGTH", 1, false)) != null && result.length() > 0 && result.matches("(?ims).*?^-?\\d+$.*")) {
                result = result.replaceFirst("(?ims).*?^(-?\\d+)$.*", "$1");
                this.signalStrength = Double.parseDouble(result);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    double dbToSUnits(double x) {
        return 9.0 + x / 6.0;
    }

    protected void setSMeter() {
        if (this.validSetup()) {
            try {
                double ss = this.signalStrength;
                if (this.testRawSignalMode()) {
                    ss -= 120.0;
                }
                double sunit = this.dbToSUnits(ss);
                this.signalProgressBar.setValue((int)ss);
                this.signalProgressBar.setString(String.format("S %.0f (%.0f db)", sunit, ss));
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
    }

    private void adjustSize() {
        int fontSize = (int)((double)this.digitsParent.getWidth() / 6.5);
        for (Component c : this.digitsPanel.getComponents()) {
            float fs = ((FreqDigit)c).fontScale;
            Font font = new Font("Monospace", 0, (int)((float)fontSize * fs));
            c.setFont(font);
        }
    }

    private void checkMainTabState() {
        if (this.sv_displayState < 2) {
            this.getScopePanel().stopSweep(true);
        }
    }

    protected int getActiveTab() {
        return this.sv_displayState;
    }

    public String readTextFile(String path, String lineSep) {
        String result = "";
        try {
            result = new Scanner(new File(path)).useDelimiter("\\Z").next();
        }
        catch (Exception e) {
            // empty catch block
        }
        return result;
    }

    public void writeTextFile(String path, String data) {
        try (PrintWriter out = new PrintWriter(new File(path));){
            out.write(data);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public void launchHelp(String url) {
        try {
            Desktop desktop = Desktop.getDesktop();
            desktop.browse(new URI(url));
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace(System.out);
        }
    }

    protected void writeToClipboard(String s) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection transferable = new StringSelection(s);
        clipboard.setContents(transferable, null);
    }

    protected String readFromClipboard() {
        String data = "";
        try {
            data = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor);
        }
        catch (HeadlessException | UnsupportedFlavorException | IOException exception) {
            // empty catch block
        }
        return data;
    }

    private void showConfigDialog() {
        ConfigComsDialog dlg = new ConfigComsDialog(this, true, this.sv_hamrigWriteDelay, this.sv_hamrigPostWriteDelay, this.sv_hamrigRetries, this.sv_hamrigTimeout, this.sv_hamrigUseCustomSettings);
        dlg.setTitle(this.programName + " communication settings");
        dlg.setVisible(true);
        this.sv_hamrigUseCustomSettings = dlg.accept;
        if (this.sv_hamrigUseCustomSettings) {
            this.sv_hamrigWriteDelay = Integer.parseInt(dlg.writeDelayTextField.getText());
            this.sv_hamrigPostWriteDelay = Integer.parseInt(dlg.postWriteDelayTextField.getText());
            this.sv_hamrigRetries = Integer.parseInt(dlg.retriesTextField.getText());
            this.sv_hamrigTimeout = Integer.parseInt(dlg.timeoutTextField.getText());
        }
    }

    private void closeApp() {
        this.getScopePanel().stopSweep(false);
        this.scanFunctions.stopScan(false);
        if (this.periodicTimer != null) {
            this.periodicTimer.cancel();
            this.periodicTimer = null;
        }
        if (this.scanFunctions.scanTimer != null) {
            this.scanFunctions.scanTimer.cancel();
            this.scanFunctions.scanTimer = null;
        }
        this.config.write();
        this.writeMemoryButtons();
        this.closeConnection();
        System.exit(0);
    }

    public String gcFromTimeMS(long timeMS) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTimeInMillis(timeMS);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        return sdf.format(gc.getTime());
    }

    public String gcFromNow() {
        return this.gcFromTimeMS(System.currentTimeMillis());
    }

    public void p(String s) {
        long t = System.currentTimeMillis();
        Time et = new Time(t);
        double dt = (double)(t - this.oldTime) / 1000.0;
        System.out.println(String.format("%s : %06f : %s", this.gcFromNow(), dt, s));
        this.oldTime = t;
    }

    private void initComponents() {
        this.jrxRadioButtonGroup = new ButtonGroup();
        this.radioPanel = new JPanel();
        this.receiverPanel = new JPanel();
        this.listPanel = new JPanel();
        this.buttonPanel5 = new JPanel();
        this.sv_radioNamesComboBox = new JComboBox();
        this.speedIconLabel = new JLabel();
        this.comErrorIconLabel = new JLabel();
        this.dcdIconLabel = new JLabel();
        this.buttonPanel4 = new JPanel();
        this.sv_interfacesComboBox = new JComboBox();
        this.sv_antennaComboBox = new RWComboBox(this, "Y", "");
        this.sv_synthSquelchCheckBox = new RWCheckBox(this, null, null);
        this.buttonPanel1 = new JPanel();
        this.sv_filtersComboBox = new RWComboBox(this, "F", "");
        this.sv_ctcssComboBox = new RWComboBox(this, "ctcss", "");
        this.sv_attenuatorComboBox = new RWComboBox(this, "L", "ATT");
        this.buttonPanel3 = new JPanel();
        this.sv_modesComboBox = new RWComboBox(this, "M", "");
        this.sv_agcComboBox = new RWComboBox(this, "L", "AGC");
        this.sv_dspComboBox = new RWComboBox(this, "L", "NR");
        this.buttonPanel6 = new JPanel();
        this.sv_rfGainComboBox = new RWComboBox(this, "L", "RF");
        this.sv_ifShiftComboBox = new RWComboBox(this, "L", "IF");
        this.sv_preampComboBox = new RWComboBox(this, "L", "PREAMP");
        this.buttonPanel2 = new JPanel();
        this.copyMemButton = new JButton();
        this.pasteMemButton = new JButton();
        this.eraseMemButton = new JButton();
        this.helpButton = new JButton();
        this.quitButton = new JButton();
        this.tuneComsButton = new JButton();
        this.verticalListPanel = new JPanel();
        this.sv_rawSigCheckBox = new RWCheckBox(this, null, null);
        this.sv_blankerCheckBox = new RWCheckBox(this, "U", "NB");
        this.sv_apfCheckBox = new RWCheckBox(this, "U", "APF");
        this.sv_anfCheckBox = new RWCheckBox(this, "U", "ANF");
        this.sv_ctcssCheckBox = new RWCheckBox(this, "U", "TSQL");
        this.sv_dspCheckBox = new RWCheckBox(this, "U", "NR");
        this.signalPanel = new JPanel();
        this.signalProgressBar = new JProgressBar();
        this.digitsParent = new JPanel();
        this.digitsPanel = new JPanel();
        this.scannerPanel = new JPanel();
        this.sv_scanStepComboBox = new RWComboBox(this, null, null);
        this.sv_scanSpeedComboBox = new RWComboBox(this, null, null);
        this.sv_dwellTimeComboBox = new RWComboBox(this, null, null);
        this.scanDownButton = new JButton();
        this.scanStopButton = new JButton();
        this.scanUpButton = new JButton();
        this.sv_squelchCheckBox = new RWCheckBox(this, null, null);
        this.scanTypeLabel = new JLabel();
        this.scanIconLabel = new JLabel();
        this.sliderPanel = new JPanel();
        this.sv_volumeSlider = new RWSlider(this, "L", "AF", 20);
        this.sv_squelchSlider = new RWSlider(this, "L", "SQL", 0);
        this.memoryPanel = new JPanel();
        this.memoryScrollPane = new JScrollPane();
        this.memoryButtonsPanel = new JPanel();
        this.tableScrollPane = new JScrollPane();
        this.freqTable = new JTable();
        this.scopePanel = new JPanel();
        this.scopeDisplayPanel = new SweepScope(this);
        this.scopeControlPanel = new JPanel();
        this.scopeControlLeftPanel = new JPanel();
        this.sv_scopeStepComboBox = new RWComboBox(this, null, null);
        this.sv_scopeSpeedComboBox = new RWComboBox(this, null, null);
        this.scopeStartStopButton = new JButton();
        this.sv_scopeDotsCheckBox = new JCheckBox();
        this.scopeScaleButton = new JButton();
        this.scopeDefaultsButton = new JButton();
        this.copyButton = new JButton();
        this.scanHelpButton = new JButton();
        this.jLabel1 = new JLabel();
        this.scopeControlRightPanel = new JPanel();
        this.sv_jrxToRadioButton = new JRadioButton();
        this.sv_radioToJrxButton = new JRadioButton();
        this.sv_syncCheckBox = new JCheckBox();
        this.sv_timerIntervalComboBox = new RWComboBox(this, null, null);
        this.jLabel2 = new JLabel();
        this.sv_volumeExitCheckBox = new JCheckBox();
        this.button_bar = new JPanel();
        this.radioMemoryButton = new JButton();
        this.radioListButton = new JButton();
        this.radioScannerButton = new JButton();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                JRX.this.formWindowClosing(evt);
            }
        });
        this.radioPanel.setLayout(new CardLayout());
        this.receiverPanel.setLayout(new GridBagLayout());
        this.listPanel.setLayout(new GridBagLayout());
        this.buttonPanel5.setOpaque(false);
        this.buttonPanel5.setLayout(new GridBagLayout());
        this.sv_radioNamesComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.sv_radioNamesComboBox.setToolTipText("Available radio manufacturers and models");
        this.sv_radioNamesComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JRX.this.sv_radioNamesComboBoxActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.buttonPanel5.add(this.sv_radioNamesComboBox, gridBagConstraints);
        this.speedIconLabel.setText("Speed Icon");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.buttonPanel5.add((Component)this.speedIconLabel, gridBagConstraints);
        this.comErrorIconLabel.setText("Error Icon");
        this.comErrorIconLabel.setToolTipText("Red indicates communications error");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.buttonPanel5.add((Component)this.comErrorIconLabel, gridBagConstraints);
        this.dcdIconLabel.setText("DCD Icon");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.buttonPanel5.add((Component)this.dcdIconLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.listPanel.add((Component)this.buttonPanel5, gridBagConstraints);
        this.buttonPanel4.setOpaque(false);
        this.buttonPanel4.setLayout(new GridBagLayout());
        this.sv_interfacesComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.sv_interfacesComboBox.setToolTipText("Available communication interfaces");
        this.sv_interfacesComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JRX.this.sv_interfacesComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.buttonPanel4.add(this.sv_interfacesComboBox, gridBagConstraints);
        this.sv_antennaComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.sv_antennaComboBox.setToolTipText("Available antennas (\u2743)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.buttonPanel4.add((Component)this.sv_antennaComboBox, gridBagConstraints);
        this.sv_synthSquelchCheckBox.setText("Squelch");
        this.sv_synthSquelchCheckBox.setToolTipText("Use JRX squelch scheme");
        this.sv_synthSquelchCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JRX.this.sv_synthSquelchCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.buttonPanel4.add((Component)this.sv_synthSquelchCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.listPanel.add((Component)this.buttonPanel4, gridBagConstraints);
        this.buttonPanel1.setOpaque(false);
        this.buttonPanel1.setLayout(new GridBagLayout());
        this.sv_filtersComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.sv_filtersComboBox.setToolTipText("Bandwidth filters (\u2743)\n");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.buttonPanel1.add(this.sv_filtersComboBox, gridBagConstraints);
        this.sv_ctcssComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.sv_ctcssComboBox.setToolTipText("CTCSS tone squelch frequencies (\u2743)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.buttonPanel1.add((Component)this.sv_ctcssComboBox, gridBagConstraints);
        this.sv_attenuatorComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.sv_attenuatorComboBox.setToolTipText("Input attenuator (\u2743)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.buttonPanel1.add((Component)this.sv_attenuatorComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.listPanel.add((Component)this.buttonPanel1, gridBagConstraints);
        this.buttonPanel3.setOpaque(false);
        this.buttonPanel3.setLayout(new GridBagLayout());
        this.sv_modesComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.sv_modesComboBox.setToolTipText("Operating modes (\u2743)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.buttonPanel3.add(this.sv_modesComboBox, gridBagConstraints);
        this.sv_agcComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.sv_agcComboBox.setToolTipText("AGC setting (\u2743)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.buttonPanel3.add((Component)this.sv_agcComboBox, gridBagConstraints);
        this.sv_dspComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.sv_dspComboBox.setToolTipText("DSP Noise Reduction (\u2743)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.buttonPanel3.add((Component)this.sv_dspComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.listPanel.add((Component)this.buttonPanel3, gridBagConstraints);
        this.buttonPanel6.setOpaque(false);
        this.buttonPanel6.setLayout(new GridBagLayout());
        this.sv_rfGainComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.sv_rfGainComboBox.setToolTipText("RF Gain (\u2743)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.buttonPanel6.add((Component)this.sv_rfGainComboBox, gridBagConstraints);
        this.sv_ifShiftComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.sv_ifShiftComboBox.setToolTipText("IF Shift (\u2743)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.buttonPanel6.add((Component)this.sv_ifShiftComboBox, gridBagConstraints);
        this.sv_preampComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.sv_preampComboBox.setToolTipText("Preamp setting (\u2743)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.buttonPanel6.add((Component)this.sv_preampComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        this.listPanel.add((Component)this.buttonPanel6, gridBagConstraints);
        this.buttonPanel2.setOpaque(false);
        this.buttonPanel2.setLayout(new GridBagLayout());
        this.copyMemButton.setText("CM");
        this.copyMemButton.setToolTipText("Copy JRX memory buttons to clipboard");
        this.copyMemButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JRX.this.copyMemButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.buttonPanel2.add((Component)this.copyMemButton, gridBagConstraints);
        this.pasteMemButton.setText("PM");
        this.pasteMemButton.setToolTipText("Paste JRX memory buttons from clipboard");
        this.pasteMemButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JRX.this.pasteMemButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.buttonPanel2.add((Component)this.pasteMemButton, gridBagConstraints);
        this.eraseMemButton.setText("EM");
        this.eraseMemButton.setToolTipText("Erase all JRX memory buttons");
        this.eraseMemButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JRX.this.eraseMemButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.buttonPanel2.add((Component)this.eraseMemButton, gridBagConstraints);
        this.helpButton.setText("Help");
        this.helpButton.setToolTipText("Visit the JRX Home Page");
        this.helpButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JRX.this.helpButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.buttonPanel2.add((Component)this.helpButton, gridBagConstraints);
        this.quitButton.setText("Quit");
        this.quitButton.setToolTipText("Exit JRX");
        this.quitButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JRX.this.quitButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.buttonPanel2.add((Component)this.quitButton, gridBagConstraints);
        this.tuneComsButton.setText("Conf");
        this.tuneComsButton.setToolTipText("Configure Hamlib communications");
        this.tuneComsButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JRX.this.tuneComsButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.buttonPanel2.add((Component)this.tuneComsButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        this.listPanel.add((Component)this.buttonPanel2, gridBagConstraints);
        this.verticalListPanel.setOpaque(false);
        this.verticalListPanel.setLayout(new GridBagLayout());
        this.sv_rawSigCheckBox.setText("Raw");
        this.sv_rawSigCheckBox.setToolTipText("<html>Use unconverted signal<br/>strength readings");
        this.sv_rawSigCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JRX.this.sv_rawSigCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.verticalListPanel.add((Component)this.sv_rawSigCheckBox, gridBagConstraints);
        this.sv_blankerCheckBox.setText("NB");
        this.sv_blankerCheckBox.setToolTipText("<html>Noise Blanker -- reduces<br/>some kinds of noise");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.verticalListPanel.add((Component)this.sv_blankerCheckBox, gridBagConstraints);
        this.sv_apfCheckBox.setText("APF");
        this.sv_apfCheckBox.setToolTipText("Automatic Peak Filter");
        this.sv_apfCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JRX.this.sv_apfCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.verticalListPanel.add((Component)this.sv_apfCheckBox, gridBagConstraints);
        this.sv_anfCheckBox.setText("ANF");
        this.sv_anfCheckBox.setToolTipText("Automatic Notch Filter");
        this.sv_anfCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JRX.this.sv_anfCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.verticalListPanel.add((Component)this.sv_anfCheckBox, gridBagConstraints);
        this.sv_ctcssCheckBox.setText("CTCSS");
        this.sv_ctcssCheckBox.setToolTipText("Tone squelch control");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.verticalListPanel.add((Component)this.sv_ctcssCheckBox, gridBagConstraints);
        this.sv_dspCheckBox.setText("DSP");
        this.sv_dspCheckBox.setToolTipText("Digital signal processing");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.verticalListPanel.add((Component)this.sv_dspCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.fill = 3;
        this.listPanel.add((Component)this.verticalListPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 0, 1);
        this.receiverPanel.add((Component)this.listPanel, gridBagConstraints);
        this.signalPanel.setLayout(new GridBagLayout());
        this.signalProgressBar.setMaximum(20);
        this.signalProgressBar.setMinimum(-50);
        this.signalProgressBar.setValue(-50);
        this.signalProgressBar.setStringPainted(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.signalPanel.add((Component)this.signalProgressBar, gridBagConstraints);
        this.digitsParent.setLayout(new GridBagLayout());
        this.digitsPanel.addHierarchyBoundsListener(new HierarchyBoundsListener(){

            @Override
            public void ancestorMoved(HierarchyEvent evt) {
            }

            @Override
            public void ancestorResized(HierarchyEvent evt) {
                JRX.this.digitsPanelAncestorResized(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.digitsParent.add((Component)this.digitsPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.signalPanel.add((Component)this.digitsParent, gridBagConstraints);
        this.scannerPanel.setLayout(new GridBagLayout());
        this.sv_scanStepComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.sv_scanStepComboBox.setToolTipText("Scan frequency step size (\u2743)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.scannerPanel.add(this.sv_scanStepComboBox, gridBagConstraints);
        this.sv_scanSpeedComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.sv_scanSpeedComboBox.setToolTipText("Scan delay (\u2743)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.scannerPanel.add(this.sv_scanSpeedComboBox, gridBagConstraints);
        this.sv_dwellTimeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.sv_dwellTimeComboBox.setToolTipText("Pause dwell time (\u2743)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.scannerPanel.add(this.sv_dwellTimeComboBox, gridBagConstraints);
        this.scanDownButton.setText("<-");
        this.scanDownButton.setToolTipText("Scan down");
        this.scanDownButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JRX.this.scanDownButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.scannerPanel.add((Component)this.scanDownButton, gridBagConstraints);
        this.scanStopButton.setText("Stop");
        this.scanStopButton.setToolTipText("Halt scan");
        this.scanStopButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JRX.this.scanStopButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.scannerPanel.add((Component)this.scanStopButton, gridBagConstraints);
        this.scanUpButton.setText("->");
        this.scanUpButton.setToolTipText("Scan up");
        this.scanUpButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JRX.this.scanUpButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.scannerPanel.add((Component)this.scanUpButton, gridBagConstraints);
        this.sv_squelchCheckBox.setSelected(true);
        this.sv_squelchCheckBox.setText("Squelch");
        this.sv_squelchCheckBox.setToolTipText("Pause on squelch active");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        this.scannerPanel.add((Component)this.sv_squelchCheckBox, gridBagConstraints);
        this.scanTypeLabel.setText("Scan");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.scannerPanel.add((Component)this.scanTypeLabel, gridBagConstraints);
        this.scanIconLabel.setText("x");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.scannerPanel.add((Component)this.scanIconLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.signalPanel.add((Component)this.scannerPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.receiverPanel.add((Component)this.signalPanel, gridBagConstraints);
        this.sliderPanel.setLayout(new GridBagLayout());
        this.sv_volumeSlider.setToolTipText("Audio Gain (\u2743)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.sliderPanel.add((Component)this.sv_volumeSlider, gridBagConstraints);
        this.sv_squelchSlider.setToolTipText("Squelch (\u2743)\n");
        this.sv_squelchSlider.setValue(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.sliderPanel.add((Component)this.sv_squelchSlider, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 8;
        gridBagConstraints.ipady = 8;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 0, 1);
        this.receiverPanel.add((Component)this.sliderPanel, gridBagConstraints);
        this.memoryPanel.setLayout(new CardLayout());
        this.memoryButtonsPanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0), 2));
        this.memoryButtonsPanel.setLayout(new GridLayout(1, 0));
        this.memoryScrollPane.setViewportView(this.memoryButtonsPanel);
        this.memoryPanel.add((Component)this.memoryScrollPane, "memoryCard");
        this.freqTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.tableScrollPane.setViewportView(this.freqTable);
        this.memoryPanel.add((Component)this.tableScrollPane, "tableCard");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.1;
        this.receiverPanel.add((Component)this.memoryPanel, gridBagConstraints);
        this.radioPanel.add((Component)this.receiverPanel, "receiverCard");
        this.scopePanel.setLayout(new BorderLayout());
        this.scopePanel.add((Component)this.scopeDisplayPanel, "Center");
        this.scopeControlPanel.setBackground(new Color(0, 0, 0));
        this.scopeControlPanel.setLayout(new GridBagLayout());
        this.scopeControlLeftPanel.setLayout(new GridBagLayout());
        this.sv_scopeStepComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.sv_scopeStepComboBox.setToolTipText("Sweep frequency step size (\u2743)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.scopeControlLeftPanel.add(this.sv_scopeStepComboBox, gridBagConstraints);
        this.sv_scopeSpeedComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.sv_scopeSpeedComboBox.setToolTipText("Sweep delay (\u2743)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.scopeControlLeftPanel.add(this.sv_scopeSpeedComboBox, gridBagConstraints);
        this.scopeStartStopButton.setText("Start");
        this.scopeStartStopButton.setToolTipText("Start or stop the sweep");
        this.scopeStartStopButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JRX.this.scopeStartStopButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.scopeControlLeftPanel.add((Component)this.scopeStartStopButton, gridBagConstraints);
        this.sv_scopeDotsCheckBox.setText("Dots");
        this.sv_scopeDotsCheckBox.setToolTipText("Add dots at each sample point");
        this.sv_scopeDotsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JRX.this.sv_scopeDotsCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.scopeControlLeftPanel.add((Component)this.sv_scopeDotsCheckBox, gridBagConstraints);
        this.scopeScaleButton.setText("Rescale");
        this.scopeScaleButton.setToolTipText("During or after a sweep, optimally scale the vertical axis");
        this.scopeScaleButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JRX.this.scopeScaleButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.scopeControlLeftPanel.add((Component)this.scopeScaleButton, gridBagConstraints);
        this.scopeDefaultsButton.setText("Defaults");
        this.scopeDefaultsButton.setToolTipText("Set scaling defaults");
        this.scopeDefaultsButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JRX.this.scopeDefaultsButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.scopeControlLeftPanel.add((Component)this.scopeDefaultsButton, gridBagConstraints);
        this.copyButton.setText("Copy");
        this.copyButton.setToolTipText("Copy sweep dataset to system clipboard");
        this.copyButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JRX.this.copyButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.scopeControlLeftPanel.add((Component)this.copyButton, gridBagConstraints);
        this.scanHelpButton.setText("Help");
        this.scanHelpButton.setToolTipText("Visit the JRX Home Page");
        this.scanHelpButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JRX.this.scanHelpButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.scopeControlLeftPanel.add((Component)this.scanHelpButton, gridBagConstraints);
        this.jLabel1.setText("Sweep scope controls");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.scopeControlLeftPanel.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.scopeControlPanel.add((Component)this.scopeControlLeftPanel, gridBagConstraints);
        this.scopeControlRightPanel.setLayout(new GridBagLayout());
        this.jrxRadioButtonGroup.add(this.sv_jrxToRadioButton);
        this.sv_jrxToRadioButton.setSelected(true);
        this.sv_jrxToRadioButton.setText("JRX->Radio");
        this.sv_jrxToRadioButton.setToolTipText("At startup, JRX sets the radio's controls");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.scopeControlRightPanel.add((Component)this.sv_jrxToRadioButton, gridBagConstraints);
        this.jrxRadioButtonGroup.add(this.sv_radioToJrxButton);
        this.sv_radioToJrxButton.setText("Radio->JRX");
        this.sv_radioToJrxButton.setToolTipText("At startup, the radio sets JRX's controls");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.scopeControlRightPanel.add((Component)this.sv_radioToJrxButton, gridBagConstraints);
        this.sv_syncCheckBox.setText("Sync with radio");
        this.sv_syncCheckBox.setToolTipText("<html>Dynamically synchronize JRX<br/>controls with radio controls");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.scopeControlRightPanel.add((Component)this.sv_syncCheckBox, gridBagConstraints);
        this.sv_timerIntervalComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.sv_timerIntervalComboBox.setToolTipText("Control/event update timer interval (\u2743)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.scopeControlRightPanel.add(this.sv_timerIntervalComboBox, gridBagConstraints);
        this.jLabel2.setText("JRX setup controls");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.scopeControlRightPanel.add((Component)this.jLabel2, gridBagConstraints);
        this.sv_volumeExitCheckBox.setSelected(true);
        this.sv_volumeExitCheckBox.setText("Volume down on exit");
        this.sv_volumeExitCheckBox.setToolTipText("<html>Turn down the radio volume<br/>when JRX exits");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.scopeControlRightPanel.add((Component)this.sv_volumeExitCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.scopeControlPanel.add((Component)this.scopeControlRightPanel, gridBagConstraints);
        this.scopePanel.add((Component)this.scopeControlPanel, "South");
        this.radioPanel.add((Component)this.scopePanel, "scopeCard");
        this.getContentPane().add((Component)this.radioPanel, "Center");
        this.radioMemoryButton.setText("Radio:Buttons");
        this.radioMemoryButton.setToolTipText("Show memory buttons");
        this.radioMemoryButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JRX.this.radioMemoryButtonMouseClicked(evt);
            }
        });
        this.button_bar.add(this.radioMemoryButton);
        this.radioListButton.setText("Radio:List");
        this.radioListButton.setToolTipText("Show frequency list");
        this.radioListButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JRX.this.radioListButtonMouseClicked(evt);
            }
        });
        this.button_bar.add(this.radioListButton);
        this.radioScannerButton.setText("Scope/Setup");
        this.radioScannerButton.setToolTipText("Show spectrum scope and setup controls");
        this.radioScannerButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JRX.this.radioScannerButtonMouseClicked(evt);
            }
        });
        this.button_bar.add(this.radioScannerButton);
        this.getContentPane().add((Component)this.button_bar, "Last");
        this.pack();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeApp();
    }

    private void scanHelpButtonMouseClicked(MouseEvent evt) {
        this.launchHelp("http://arachnoid.com/JRX/index.html#Spectrum_Analysis");
    }

    private void copyButtonMouseClicked(MouseEvent evt) {
        this.getScopePanel().saveData();
    }

    private void scopeDefaultsButtonMouseClicked(MouseEvent evt) {
        this.getScopePanel().setup();
    }

    private void scopeScaleButtonMouseClicked(MouseEvent evt) {
        this.getScopePanel().autoscale();
    }

    private void sv_scopeDotsCheckBoxActionPerformed(ActionEvent evt) {
        this.repaint();
    }

    private void scopeStartStopButtonMouseClicked(MouseEvent evt) {
        this.getScopePanel().startSweep();
    }

    private void scanUpButtonMouseClicked(MouseEvent evt) {
        this.scanFunctions.startScan(1);
    }

    private void scanStopButtonMouseClicked(MouseEvent evt) {
        this.scanFunctions.stopScan(true);
    }

    private void scanDownButtonMouseClicked(MouseEvent evt) {
        this.scanFunctions.startScan(-1);
    }

    private void digitsPanelAncestorResized(HierarchyEvent evt) {
        this.adjustSize();
    }

    private void sv_anfCheckBoxActionPerformed(ActionEvent evt) {
        this.enableDSP();
    }

    private void sv_apfCheckBoxActionPerformed(ActionEvent evt) {
        this.enableDSP();
    }

    private void sv_rawSigCheckBoxActionPerformed(ActionEvent evt) {
        this.testRawSignalMode();
    }

    private void tuneComsButtonMouseClicked(MouseEvent evt) {
        this.showConfigDialog();
    }

    private void quitButtonMouseClicked(MouseEvent evt) {
        this.closeApp();
    }

    private void helpButtonMouseClicked(MouseEvent evt) {
        this.launchHelp("http://arachnoid.com/JRX");
    }

    private void eraseMemButtonMouseClicked(MouseEvent evt) {
        this.memoryFunctions.dispatch(evt);
    }

    private void pasteMemButtonMouseClicked(MouseEvent evt) {
        this.memoryFunctions.dispatch(evt);
    }

    private void copyMemButtonMouseClicked(MouseEvent evt) {
        this.memoryFunctions.dispatch(evt);
    }

    private void sv_synthSquelchCheckBoxActionPerformed(ActionEvent evt) {
        this.setSquelchScheme();
    }

    private void sv_interfacesComboBoxActionPerformed(ActionEvent evt) {
        this.initialize();
    }

    private void sv_radioNamesComboBoxActionPerformed(ActionEvent evt) {
        this.initialize();
    }

    private void radioMemoryButtonMouseClicked(MouseEvent evt) {
        this.setDisplayState(0);
    }

    private void radioListButtonMouseClicked(MouseEvent evt) {
        this.setDisplayState(1);
    }

    private void radioScannerButtonMouseClicked(MouseEvent evt) {
        this.setDisplayState(2);
    }

    public static void main(final String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            Logger.getLogger(JRX.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new JRX(args).setVisible(true);
            }
        });
    }

    class PeriodicEvents
    extends TimerTask {
        PeriodicEvents() {
        }

        @Override
        public void run() {
            if (!JRX.this.getScopePanel().isRunning() && JRX.this.scanFunctions.scanTimer == null) {
                JRX.this.getSignalStrength();
                JRX.this.setSMeter();
                JRX.this.getSquelch(false);
                JRX.this.setComErrorIcon();
                JRX.this.readRadioControls(false);
            }
            if (JRX.this.slowRadio || JRX.this.scanFunctions.scanTimer != null) {
                JRX.this.timerUpdateFreq();
            }
            JRX.this.resetTimer();
        }
    }
}

