/*
 * Decompiled with CFR 0.152.
 */
package jrx;

import java.awt.Color;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JLabel;
import jrx.JRX;

public final class FreqDigit
extends JLabel
implements MouseWheelListener,
MouseListener {
    JRX parent;
    float fontScale;
    FreqDigit carry = null;
    private long value = 0L;
    Color nonZeroColor = new Color(0, 192, 0);
    Color zeroColor = new Color(0, 64, 0);

    public FreqDigit(JRX p, int dflt, float fs) {
        this.parent = p;
        this.fontScale = fs;
        this.value = dflt;
        if (dflt >= 0 && dflt <= 9) {
            this.setDigit(dflt);
            this.setForeground(this.zeroColor);
        } else {
            this.setText(".");
            this.setForeground(this.nonZeroColor);
        }
        this.setFont(this.parent.digitsFont);
        this.addMouseWheelListener(this);
        this.addMouseListener(this);
    }

    public void setDigit(long v) {
        this.value = v;
        this.setText("" + this.value);
    }

    public void setCarry(FreqDigit fd) {
        this.carry = fd;
    }

    public void setBright(boolean v) {
        this.setForeground(v ? this.nonZeroColor : this.zeroColor);
    }

    private void increm(int v) {
        boolean carried = false;
        if (this.value >= 0L) {
            long nv = this.value + (long)v;
            this.setDigit((nv + 10L) % 10L);
            if (this.carry != null) {
                if (nv > 9L) {
                    this.carry.increm(1);
                    carried = true;
                }
                if (nv < 0L) {
                    this.carry.increm(-1);
                    carried = true;
                }
            }
            if (!carried) {
                this.parent.digitsToFrequency();
            }
        }
    }

    public long getValue() {
        return this.value;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int v = e.getWheelRotation();
        int iv = v < 0 ? 1 : -1;
        this.increm(iv);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            int cy;
            int my = e.getY();
            int inc = my < (cy = this.getHeight() / 2) ? 1 : -1;
            this.increm(inc);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }
}

