/*
 * Decompiled with CFR 0.152.
 */
package jrx;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import jrx.Configurable;
import jrx.JRX;

public class ConfigComsDialog
extends JDialog
implements Configurable {
    JRX parent;
    boolean accept;
    String speech = "If you aren't having any communication speed difficulties, then there's no reason to change these settings.\n\nBut to optimize communications between JRX, the Hamlib library and your radio, you may want to adjust the settings below.\n\nTo use the Hamlib defaults, deselect \"Make and use custom settings\" below and exit this dialog.\n\nTo customize the settings, select \"Make and use custom settings\", enter your settings, then exit and re-enter JRX to let the settings take effect.\n\nYour settings are preserved between program runs.";
    private JCheckBox customCheckBox;
    private JPanel dialogControlPanel;
    private JButton dlgCancelButton;
    private JButton dlgOkButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JScrollPane jScrollPane1;
    private JTextArea messageTextArea;
    protected JTextField postWriteDelayTextField;
    protected JTextField retriesTextField;
    protected JTextField timeoutTextField;
    protected JTextField writeDelayTextField;

    public ConfigComsDialog(JRX p, boolean modal, int wd, int pwd, int re, int ti, boolean useCustom) {
        super((Frame)p, modal);
        this.parent = p;
        this.initComponents();
        this.setDefaultCloseOperation(2);
        this.setSize(600, 400);
        this.setLocationRelativeTo(this.parent);
        this.messageTextArea.setText(this.speech);
        this.messageTextArea.setFont(this.parent.baseFont);
        this.messageTextArea.setCaretPosition(0);
        this.writeDelayTextField.setText("" + wd);
        this.postWriteDelayTextField.setText("" + pwd);
        this.retriesTextField.setText("" + re);
        this.timeoutTextField.setText("" + ti);
        this.customCheckBox.setSelected(useCustom);
        this.updateControls();
    }

    private void updateControls() {
        this.accept = this.customCheckBox.isSelected();
        this.writeDelayTextField.setEnabled(this.accept);
        this.postWriteDelayTextField.setEnabled(this.accept);
        this.retriesTextField.setEnabled(this.accept);
        this.timeoutTextField.setEnabled(this.accept);
    }

    private void setupExit(boolean outcome) {
        this.accept &= outcome;
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void fromString(String s) {
    }

    @Override
    public String toString() {
        return "";
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.messageTextArea = new JTextArea();
        this.dialogControlPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.writeDelayTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.postWriteDelayTextField = new JTextField();
        this.jLabel3 = new JLabel();
        this.timeoutTextField = new JTextField();
        this.customCheckBox = new JCheckBox();
        this.dlgOkButton = new JButton();
        this.dlgCancelButton = new JButton();
        this.jLabel4 = new JLabel();
        this.retriesTextField = new JTextField();
        this.setDefaultCloseOperation(2);
        this.messageTextArea.setColumns(20);
        this.messageTextArea.setLineWrap(true);
        this.messageTextArea.setRows(5);
        this.messageTextArea.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.messageTextArea);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.dialogControlPanel.setLayout(new GridBagLayout());
        this.jLabel1.setText("Write delay ms:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 1, 4);
        this.dialogControlPanel.add((Component)this.jLabel1, gridBagConstraints);
        this.writeDelayTextField.setHorizontalAlignment(4);
        this.writeDelayTextField.setText("000");
        this.writeDelayTextField.setMinimumSize(new Dimension(70, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 4, 1, 4);
        this.dialogControlPanel.add((Component)this.writeDelayTextField, gridBagConstraints);
        this.jLabel2.setText("Post write delay ms:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 1, 4);
        this.dialogControlPanel.add((Component)this.jLabel2, gridBagConstraints);
        this.postWriteDelayTextField.setHorizontalAlignment(4);
        this.postWriteDelayTextField.setText("000");
        this.postWriteDelayTextField.setMinimumSize(new Dimension(70, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 4, 1, 4);
        this.dialogControlPanel.add((Component)this.postWriteDelayTextField, gridBagConstraints);
        this.jLabel3.setText("Timeout ms:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 1, 4);
        this.dialogControlPanel.add((Component)this.jLabel3, gridBagConstraints);
        this.timeoutTextField.setHorizontalAlignment(4);
        this.timeoutTextField.setText("000");
        this.timeoutTextField.setMinimumSize(new Dimension(70, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 4, 1, 4);
        this.dialogControlPanel.add((Component)this.timeoutTextField, gridBagConstraints);
        this.customCheckBox.setText("Make and use custom Settings");
        this.customCheckBox.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ConfigComsDialog.this.customCheckBoxMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(1, 4, 1, 4);
        this.dialogControlPanel.add((Component)this.customCheckBox, gridBagConstraints);
        this.dlgOkButton.setText("OK");
        this.dlgOkButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ConfigComsDialog.this.dlgOkButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(1, 4, 1, 4);
        this.dialogControlPanel.add((Component)this.dlgOkButton, gridBagConstraints);
        this.dlgCancelButton.setText("Cancel");
        this.dlgCancelButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ConfigComsDialog.this.dlgCancelButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(1, 4, 1, 4);
        this.dialogControlPanel.add((Component)this.dlgCancelButton, gridBagConstraints);
        this.jLabel4.setText("Retries:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 1, 4);
        this.dialogControlPanel.add((Component)this.jLabel4, gridBagConstraints);
        this.retriesTextField.setHorizontalAlignment(4);
        this.retriesTextField.setText("000");
        this.retriesTextField.setMinimumSize(new Dimension(70, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 4, 1, 4);
        this.dialogControlPanel.add((Component)this.retriesTextField, gridBagConstraints);
        this.getContentPane().add((Component)this.dialogControlPanel, "South");
        this.pack();
    }

    private void customCheckBoxMouseClicked(MouseEvent evt) {
        this.updateControls();
    }

    private void dlgOkButtonMouseClicked(MouseEvent evt) {
        this.setupExit(true);
    }

    private void dlgCancelButtonMouseClicked(MouseEvent evt) {
        this.setupExit(false);
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(ConfigComsDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(ConfigComsDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(ConfigComsDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(ConfigComsDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                System.exit(0);
            }
        });
    }
}

