/*
 * Decompiled with CFR 0.152.
 */
package jrx;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.SourceDataLine;

public final class Beep
extends Thread {
    float sampleRate = 32000.0f;
    int freqHz;
    int durationMsec;
    double level;

    public Beep(int freqHz, int durationMsec, double level) {
        this.freqHz = freqHz;
        this.durationMsec = durationMsec;
        this.level = level * 32767.0;
        this.start();
    }

    private double envelope(double a, double b, double t, double tc) {
        return (b - t) * (-a + t) / ((b - t + tc) * (-a + t + tc));
    }

    @Override
    public void run() {
        try {
            int bsize = (int)(2.0f * this.sampleRate * (float)this.durationMsec / 1000.0f);
            byte[] buf = new byte[bsize];
            double step = Math.PI * 2 * (double)this.freqHz / (double)this.sampleRate;
            double angle = 0.0;
            int i = 0;
            while (i < bsize) {
                int n = (int)(Math.sin(angle) * this.level * this.envelope(0.0, bsize, i, 1000.0));
                buf[i++] = (byte)(n % 256);
                buf[i++] = (byte)(n / 256);
                angle += step;
            }
            AudioFormat af = new AudioFormat(this.sampleRate, 16, 1, true, false);
            SourceDataLine sdl = AudioSystem.getSourceDataLine(af);
            sdl.open(af);
            sdl.start();
            sdl.write(buf, 0, buf.length);
            sdl.drain();
            sdl.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void beep(double level) {
        new Beep(1000, 100, level);
    }

    public static void beep() {
        new Beep(1000, 100, 0.5);
    }

    public static void main(String[] args) {
        Beep.beep(0.5);
    }
}

