/*
 * Decompiled with CFR 0.152.
 */
package jnx;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import jnx.JNX;

public class MessageFilterDialog
extends JDialog {
    String[][] nav_msgs = new String[][]{{"A", "Navigational warnings", "Navigational warnings"}, {"B", "Meteorological warnings", "Meteorological warnings"}, {"C", "Ice reports", "Ice reports"}, {"D", "Search & rescue / pirate warnings", "Search & rescue information, and pirate warnings"}, {"E", "Meteorological forecasts", "Meteorological forecasts"}, {"F", "Pilot service messages", "Pilot service messages"}, {"G", "AIS messages", "AIS messages"}, {"H", "LORAN messages", "LORAN messages"}, {"I", "Not used", "Not used"}, {"J", "SATNAV messages", "SATNAV messages (i.e. GPS or GLONASS)"}, {"K", "Other navaid messages", "Other electronic navaid messages"}, {"L", "Navigational warnings", "Navigational warnings - additional to letter A (Should not be rejected by the receiver)"}, {"T", "Test transmissions", "Test transmissions (UK only - not official)"}, {"V", "Notice to fishermen", "Notice to fishermen (U.S. only - currently not used)"}, {"W", "Environmental", "Environmental (U.S. only - currently not used)"}, {"X", "Special services", "Special services - allocation by IMO NAVTEX Panel"}, {"Y", "Special services", "Special services - allocation by IMO NAVTEX Panel"}, {"Z", "No message on hand", "No message on hand"}};
    JNX parent;
    HashMap<String, JCheckBox> button_list;
    private JPanel button_panel;
    private JButton clear_all_button;
    private JButton close_button;
    private JPanel jPanel1;
    private JButton select_all_button;

    public MessageFilterDialog(JNX p, boolean modal) {
        super((Frame)p, modal);
        this.parent = p;
        this.initComponents();
        this.setTitle("Select which Navtex messages to accept");
        this.button_list = new HashMap();
        int i = 0;
        int col_len = 10;
        while (i + col_len < this.nav_msgs.length) {
            for (int j = 0; j <= col_len; j += col_len) {
                String tag = this.nav_msgs[i + j][0];
                JCheckBox b = new JCheckBox(tag + ": " + this.nav_msgs[i + j][1]);
                b.setToolTipText(this.nav_msgs[i + j][2]);
                b.setSelected(this.parent.accepted_navtex_messages.accept(tag));
                this.button_list.put(tag, b);
                this.button_panel.add(b);
            }
            ++i;
        }
        this.pack();
        this.setLocationRelativeTo(this.parent);
    }

    private void reset_all_buttons(boolean state) {
        for (String s : this.button_list.keySet()) {
            this.button_list.get(s).setSelected(state);
        }
        this.button_list.get("L").setSelected(true);
    }

    private void close() {
        String selected = "";
        ArrayList<String> keys = new ArrayList<String>(this.button_list.keySet());
        Collections.sort(keys);
        for (String s : keys) {
            if (!this.button_list.get(s).isSelected()) continue;
            selected = selected + s;
        }
        this.parent.accepted_navtex_messages.set_value(selected);
        this.setVisible(false);
    }

    private void initComponents() {
        this.button_panel = new JPanel();
        this.jPanel1 = new JPanel();
        this.select_all_button = new JButton();
        this.clear_all_button = new JButton();
        this.close_button = new JButton();
        this.setDefaultCloseOperation(2);
        this.button_panel.setLayout(new GridLayout(8, 2));
        this.getContentPane().add((Component)this.button_panel, "Center");
        this.select_all_button.setText("Select All");
        this.select_all_button.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                MessageFilterDialog.this.select_all_buttonMouseClicked(evt);
            }
        });
        this.jPanel1.add(this.select_all_button);
        this.clear_all_button.setText("Clear All");
        this.clear_all_button.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                MessageFilterDialog.this.clear_all_buttonMouseClicked(evt);
            }
        });
        this.jPanel1.add(this.clear_all_button);
        this.close_button.setText("Close");
        this.close_button.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                MessageFilterDialog.this.close_buttonMouseClicked(evt);
            }
        });
        this.jPanel1.add(this.close_button);
        this.getContentPane().add((Component)this.jPanel1, "Last");
        this.pack();
    }

    private void close_buttonMouseClicked(MouseEvent evt) {
        this.close();
    }

    private void clear_all_buttonMouseClicked(MouseEvent evt) {
        this.reset_all_buttons(false);
    }

    private void select_all_buttonMouseClicked(MouseEvent evt) {
        this.reset_all_buttons(true);
    }
}

