/*
 * Decompiled with CFR 0.152.
 */
package jnx;

import java.util.ArrayList;
import java.util.List;
import jnx.Complex;
import jnx.FFTPrecalc;

public final class FFT {
    private int size = 0;
    private boolean valid = false;
    private Complex[] in_data = null;
    private Complex[] out_data = null;
    private List<FFTPrecalc> fftPrecalc;
    FFTPrecalc tcalc;
    private final double pi2 = Math.PI * 2;
    private double scale;
    private double fft_pi2;
    private boolean inverse;

    boolean test_pwr2(int n) {
        return n >= 2 && (n & n - 1) == 0;
    }

    int rev_bits(int index, int size) {
        int rev = 0;
        while (size > 1) {
            rev = rev << 1 | index & 1;
            index >>= 1;
            size >>= 1;
        }
        return rev;
    }

    public void initialize(int n, boolean inverse) {
        this.inverse = inverse;
        this.fft_pi2 = inverse ? Math.PI * -2 : Math.PI * 2;
        try {
            if (this.size != n) {
                if (!this.test_pwr2(n)) {
                    throw new Exception("Error: array size is not a power of 2\n");
                }
                this.size = n;
                this.valid = true;
                this.in_data = new Complex[n];
                this.out_data = new Complex[n];
                this.scale = 1.0 / (double)this.size;
                for (int i = 0; i < n; ++i) {
                    Complex tc = new Complex();
                    int rb = this.rev_bits(i, n);
                    this.in_data[i] = tc;
                    this.out_data[rb] = tc;
                }
                this.fftPrecalc = new ArrayList<FFTPrecalc>();
                int imax = 1;
                while (imax < this.size) {
                    this.tcalc = new FFTPrecalc(imax, this.fft_pi2);
                    this.fftPrecalc.add(this.tcalc);
                    imax = this.tcalc.istep;
                }
            }
        }
        catch (Exception e) {
            System.out.println(this.getClass().getName() + ": Error: " + e);
        }
    }

    void resize(int n, boolean inverse) {
        this.initialize(n, inverse);
    }

    boolean valid() {
        return this.valid;
    }

    int size() {
        return this.size;
    }

    public Complex[] inputArray() {
        return this.in_data;
    }

    public Complex[] outputArray() {
        return this.out_data;
    }

    public void set_value(int i, double v) {
        this.in_data[i].re = v;
    }

    void fft1() {
        if (this.valid && this.out_data != null) {
            Complex tc = new Complex();
            for (FFTPrecalc this.tcalc : this.fftPrecalc) {
                int imax = this.tcalc.imax;
                int istep = this.tcalc.istep;
                double wpr = this.tcalc.wpr;
                double wpi = this.tcalc.wpi;
                double wr = 1.0;
                double wi = 0.0;
                for (int m = 0; m < imax; ++m) {
                    for (int i = m; i < this.size; i += istep) {
                        int j = i + imax;
                        Complex ac = this.out_data[j];
                        Complex bc = this.out_data[i];
                        tc.re = wr * ac.re - wi * ac.im;
                        tc.im = wr * ac.im + wi * ac.re;
                        ac.re = bc.re - tc.re;
                        ac.im = bc.im - tc.im;
                        bc.add(tc);
                    }
                    double wtemp = wr;
                    wr = wtemp * wpr - wi * wpi + wr;
                    wi = wi * wpr + wtemp * wpi + wi;
                }
            }
            if (!this.inverse) {
                for (int k = 0; k < this.size; ++k) {
                    this.out_data[k].mult(this.scale);
                }
            }
        }
    }
}

