/*
 * Decompiled with CFR 0.152.
 */
package jnx;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jnx.ControlInterface;

public final class ConfigManager {
    String line_sep;
    String init_path;
    Component parent;
    Pattern pat;
    Matcher mat;
    ConcurrentSkipListMap<String, ControlInterface> map;

    public ConfigManager(Component p, String path) {
        this.parent = p;
        this.init_path = path;
        this.pat = Pattern.compile("\\s*(.+?)\\s*=\\s*(.+?)\\s*");
        this.line_sep = System.getProperty("line.separator");
        this.create_control_map();
        this.read_config_file();
    }

    private void create_control_map() {
        this.map = new ConcurrentSkipListMap();
        for (Field f : Arrays.asList(this.parent.getClass().getDeclaredFields())) {
            String name = f.getName();
            try {
                Object obj = f.get(this.parent);
                String t = obj.getClass().getGenericInterfaces()[0].toString();
                if (!t.equals("interface jnx.ControlInterface")) continue;
                this.map.put(name, (ControlInterface)obj);
            }
            catch (Exception e) {}
        }
    }

    private void read_config_file() {
        try {
            File f = new File(this.init_path);
            if (f.exists()) {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(f));
                while ((line = br.readLine()) != null) {
                    this.mat = this.pat.matcher(line);
                    if (!this.mat.matches()) continue;
                    this.map.get(this.mat.group(1)).set_value(this.mat.group(2));
                }
                br.close();
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void write_config_file() {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(this.init_path));
            for (String key : this.map.keySet()) {
                String val = ((Object)this.map.get(key)).toString();
                bw.write(key + " = " + val + this.line_sep);
            }
            bw.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

