/*
 * Decompiled with CFR 0.152.
 */
package jnx;

public final class BiQuadraticFilter {
    double a0;
    double a1;
    double a2;
    double b0;
    double b1;
    double b2;
    double x1;
    double x2;
    double y;
    double y1;
    double y2;
    double gain_abs;
    Type type;
    double center_freq;
    double sample_rate;
    double Q;
    double gainDB;

    public BiQuadraticFilter() {
    }

    public BiQuadraticFilter(Type type, double center_freq, double sample_rate, double Q, double gainDB) {
        this.configure(type, center_freq, sample_rate, Q, gainDB);
    }

    public BiQuadraticFilter(Type type, double center_freq, double sample_rate, double Q) {
        this.configure(type, center_freq, sample_rate, Q, 0.0);
    }

    public void reset() {
        this.y2 = 0.0;
        this.y1 = 0.0;
        this.x2 = 0.0;
        this.x1 = 0.0;
    }

    public double frequency() {
        return this.center_freq;
    }

    public void configure(Type type, double center_freq, double sample_rate, double Q, double gainDB) {
        this.reset();
        Q = Q == 0.0 ? 1.0E-9 : Q;
        this.type = type;
        this.sample_rate = sample_rate;
        this.Q = Q;
        this.gainDB = gainDB;
        this.reconfigure(center_freq);
    }

    public void configure(Type type, double center_freq, double sample_rate, double Q) {
        this.configure(type, center_freq, sample_rate, Q, 0.0);
    }

    public void reconfigure(double cf) {
        this.center_freq = cf;
        this.gain_abs = Math.pow(10.0, this.gainDB / 40.0);
        double omega = Math.PI * 2 * cf / this.sample_rate;
        double sn = Math.sin(omega);
        double cs = Math.cos(omega);
        double alpha = sn / (2.0 * this.Q);
        double beta = Math.sqrt(this.gain_abs + this.gain_abs);
        switch (this.type) {
            case BANDPASS: {
                this.b0 = alpha;
                this.b1 = 0.0;
                this.b2 = -alpha;
                this.a0 = 1.0 + alpha;
                this.a1 = -2.0 * cs;
                this.a2 = 1.0 - alpha;
                break;
            }
            case LOWPASS: {
                this.b0 = (1.0 - cs) / 2.0;
                this.b1 = 1.0 - cs;
                this.b2 = (1.0 - cs) / 2.0;
                this.a0 = 1.0 + alpha;
                this.a1 = -2.0 * cs;
                this.a2 = 1.0 - alpha;
                break;
            }
            case HIGHPASS: {
                this.b0 = (1.0 + cs) / 2.0;
                this.b1 = -(1.0 + cs);
                this.b2 = (1.0 + cs) / 2.0;
                this.a0 = 1.0 + alpha;
                this.a1 = -2.0 * cs;
                this.a2 = 1.0 - alpha;
                break;
            }
            case NOTCH: {
                this.b0 = 1.0;
                this.b1 = -2.0 * cs;
                this.b2 = 1.0;
                this.a0 = 1.0 + alpha;
                this.a1 = -2.0 * cs;
                this.a2 = 1.0 - alpha;
                break;
            }
            case PEAK: {
                this.b0 = 1.0 + alpha * this.gain_abs;
                this.b1 = -2.0 * cs;
                this.b2 = 1.0 - alpha * this.gain_abs;
                this.a0 = 1.0 + alpha / this.gain_abs;
                this.a1 = -2.0 * cs;
                this.a2 = 1.0 - alpha / this.gain_abs;
                break;
            }
            case LOWSHELF: {
                this.b0 = this.gain_abs * (this.gain_abs + 1.0 - (this.gain_abs - 1.0) * cs + beta * sn);
                this.b1 = 2.0 * this.gain_abs * (this.gain_abs - 1.0 - (this.gain_abs + 1.0) * cs);
                this.b2 = this.gain_abs * (this.gain_abs + 1.0 - (this.gain_abs - 1.0) * cs - beta * sn);
                this.a0 = this.gain_abs + 1.0 + (this.gain_abs - 1.0) * cs + beta * sn;
                this.a1 = -2.0 * (this.gain_abs - 1.0 + (this.gain_abs + 1.0) * cs);
                this.a2 = this.gain_abs + 1.0 + (this.gain_abs - 1.0) * cs - beta * sn;
                break;
            }
            case HIGHSHELF: {
                this.b0 = this.gain_abs * (this.gain_abs + 1.0 + (this.gain_abs - 1.0) * cs + beta * sn);
                this.b1 = -2.0 * this.gain_abs * (this.gain_abs - 1.0 + (this.gain_abs + 1.0) * cs);
                this.b2 = this.gain_abs * (this.gain_abs + 1.0 + (this.gain_abs - 1.0) * cs - beta * sn);
                this.a0 = this.gain_abs + 1.0 - (this.gain_abs - 1.0) * cs + beta * sn;
                this.a1 = 2.0 * (this.gain_abs - 1.0 - (this.gain_abs + 1.0) * cs);
                this.a2 = this.gain_abs + 1.0 - (this.gain_abs - 1.0) * cs - beta * sn;
            }
        }
        this.b0 /= this.a0;
        this.b1 /= this.a0;
        this.b2 /= this.a0;
        this.a1 /= this.a0;
        this.a2 /= this.a0;
    }

    public double result(double f) {
        double phi = Math.pow(Math.sin(Math.PI * 2 * f / (2.0 * this.sample_rate)), 2.0);
        return (Math.pow(this.b0 + this.b1 + this.b2, 2.0) - 4.0 * (this.b0 * this.b1 + 4.0 * this.b0 * this.b2 + this.b1 * this.b2) * phi + 16.0 * this.b0 * this.b2 * phi * phi) / (Math.pow(1.0 + this.a1 + this.a2, 2.0) - 4.0 * (this.a1 + 4.0 * this.a2 + this.a1 * this.a2) * phi + 16.0 * this.a2 * phi * phi);
    }

    public double log_result(double f) {
        double r;
        try {
            r = 10.0 * Math.log10(this.result(f));
        }
        catch (Exception e) {
            r = -100.0;
        }
        if (Double.isInfinite(r) || Double.isNaN(r)) {
            r = -100.0;
        }
        return r;
    }

    public double[] constants() {
        return new double[]{this.b0, this.b1, this.b2, this.a1, this.a2};
    }

    public double filter(double x) {
        this.y = this.b0 * x + this.b1 * this.x1 + this.b2 * this.x2 - this.a1 * this.y1 - this.a2 * this.y2;
        this.x2 = this.x1;
        this.x1 = x;
        this.y2 = this.y1;
        this.y1 = this.y;
        return this.y;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        BANDPASS,
        LOWPASS,
        HIGHPASS,
        NOTCH,
        PEAK,
        LOWSHELF,
        HIGHSHELF;

    }
}

