// ***************************************************************************
// *   Copyright (C) 2012 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************
package jdbclient;

import java.awt.Component;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

/**
 *
 * @author lutusp
 */
final public class QueryControlRow implements Configurable {

    JDBClient parent;
    QueryProcessor qProcessor;
    ArrayList<javax.swing.JComponent> row;
    String fieldName;
    int y;
    JLabel fieldLabel;
    JRadioButton leftAndOp, rightAndOp;
    ButtonGroup leftButtonGroup, rightButtonGroup;
    JRadioButton leftOrOp, rightOrOp;
    MyJTextField leftEntryField, rightEntryField;
    JCheckBox includeCheckBox;

    public QueryControlRow(JDBClient p, String fn, int y, QueryProcessor qr) {
        parent = p;
        qProcessor = qr;
        this.y = y;
        fieldName = fn;
        row = new ArrayList<>();
        setupRow(p.queryLayoutPanel);
    }

    private void setupRow(JPanel panel) {
        Insets insets = new Insets(-1, 2, -1, 2);
        row.add((fieldLabel = new JLabel("<html><b>" + fieldName + ":</b></html>")));
        row.add((leftAndOp = new JRadioButton("And")));
        row.add((leftOrOp = new JRadioButton("Or")));
        row.add((leftEntryField = new MyJTextField(parent, qProcessor)));
        row.add((rightAndOp = new JRadioButton("And")));
        row.add((rightOrOp = new JRadioButton("Or")));
        row.add((rightEntryField = new MyJTextField(parent, qProcessor)));
        row.add((includeCheckBox = new JCheckBox("Inc")));
        int x = 0;
        for (javax.swing.JComponent comp : row) {
            comp.setFont(parent.baseFont);
            boolean isTextField = (comp instanceof javax.swing.JTextField);
            float weight = (isTextField) ? 1f : 0f;
            panel.add((Component) comp, parent.createConstraints(x, y, 1, weight, insets));
            if (isTextField || (comp instanceof JCheckBox)) {
                comp.setToolTipText(String.format(parent.queryTableToolTips[x], fieldName));
            } else {
                comp.setToolTipText(parent.queryTableToolTips[x]);
            }
            x += 1;
        }
        row.remove(0);
        leftButtonGroup = new ButtonGroup();
        leftButtonGroup.add(leftAndOp);
        leftButtonGroup.add(leftOrOp);
        rightButtonGroup = new ButtonGroup();
        rightButtonGroup.add(rightAndOp);
        rightButtonGroup.add(rightOrOp);
        leftAndOp.setSelected(true);
        rightAndOp.setSelected(true);
        includeCheckBox.setSelected(true);

    }

    protected boolean getInclude() {
        return includeCheckBox.isSelected();
    }

    protected String getFieldName() {
        return fieldName;
    }

    private String logicOp(JRadioButton andButton) {
        return (andButton.isSelected() ? "AND" : "OR");
    }

    private String textOp(JTextField tf) {
        String result = "";
        String s = tf.getText().trim();
        if (s.length() > 0) {
            StringBuilder arg = new StringBuilder();
            arg.append(String.format("`%s` ", fieldName));
            if (!s.matches("(?i).*(regexp|>|=|<|like|between).*")) {
                arg.append("REGEXP ");
                if (!s.matches("^\".*\"$")) {
                    s = escapeQuote(s);
                }
            }
            arg.append(s);
            result = arg.toString();
        }
        return result;
    }

    String escapeQuote(String s) {
        return String.format("\"%s\"", s.replaceAll("\"", "\"\""));
    }

    protected ArrayList<String> buildQuery(ArrayList<String> arg) {
        String logica = logicOp(leftAndOp);
        String logicb = logicOp(rightAndOp);
        String arga = textOp(leftEntryField);
        String argb = textOp(rightEntryField);
        int argalen = arga.length();
        int argblen = argb.length();
        if (argalen == 0 && argblen == 0) {
            return arg;
        }

        boolean enclose = (argalen > 0 && argblen > 0);
        if (enclose) {
            if (arg.size() > 0) {
                arg.add(logica);
            }
            arg.add("(");
        }
        if (argalen > 0) {
            if (!enclose && arg.size() > 0) {
                arg.add(logica);
            }
            arg.add(arga);
        }
        if (argblen > 0) {
            if (arg.size() > 0) {
                arg.add(logicb);
            }
            arg.add(argb);
        }
        if (enclose) {
            arg.add(")");
        }
        return arg;
    }

    @Override
    public String toString() {
        ArrayList<String> out = new ArrayList<>();
        for (Component comp : row) {
            if (comp instanceof JLabel) {
                out.add(((JLabel) comp).getText());
            } else if (comp instanceof JTextField) {
                out.add(((JTextField) comp).getText());
            } else if (comp instanceof JCheckBox) {
                out.add(((JCheckBox) comp).isSelected() ? "1" : "0");
            } else if (comp instanceof JRadioButton) {
                out.add(((JRadioButton) comp).isSelected() ? "1" : "0");
            }
            //out.add(comp.toString());
        }
        return parent.joinStringCollection(out, "\t");
    }

    @Override
    public void fromString(String data) {
        String[] values = data.split("\t", -1);
        int i = 0;
        for (Component comp : row) {
            if (comp instanceof JLabel) {
                ((JLabel) comp).setText(values[i]);
            } else if (comp instanceof JTextField) {
                ((JTextField) comp).setText(values[i]);
            } else if (comp instanceof JCheckBox) {
                ((JCheckBox) comp).setSelected(values[i].equals("1"));
            } else if (comp instanceof JRadioButton) {
                ((JRadioButton) comp).setSelected(values[i].equals("1"));
            }
            i += 1;
        }
    }

    private void p(String s) {
        System.out.println(s);
    }
}
