// ***************************************************************************
// *   Copyright (C) 2012 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************
package jdbclient;

/**
 *
 * @author lutusp
 */
final public class ParseComLine {

    String server = null;
    String user = null;
    String database = null;
    String table = null;
    String password = null;
    String baseFont = null;
    boolean query = false;
    JDBClient parent;

    public ParseComLine(JDBClient p, String[] args) {
        parent = p;
        int state = 0;
        for (String arg : args) {
            switch (state) {
                case (1):
                    baseFont = arg;
                    state = 0;
                    break;
                case (2):
                    server = arg;
                    state = 0;
                    break;
                case (3):
                    user = arg;
                    state = 0;
                    break;
                case (4):
                    database = arg;
                    state = 0;
                    break;
                case (5):
                    table = arg;
                    state = 0;
                    break;
                case (6):
                    password = arg;
                    state = 0;
                    break;
                case (0):
                    switch (arg) {
                        case "-f":
                            state = 1;
                            break;
                        case "-s":
                            state = 2;
                            break;
                        case "-u":
                            state = 3;
                            break;
                        case "-d":
                            state = 4;
                            break;
                        case "-t":
                            state = 5;
                            break;
                        case "-p":
                            state = 6;
                            break;
                        case "-r":
                            query = true;
                            break;
                        case "-b":
                            parent.debug = true;
                            break;
                        case "-h":
                        default:
                            comHelp();
                            break;
                    }
                    break;
            }
        }
    }

    protected void process1() {
        if (baseFont != null) {
            parent.baseFontName = baseFont;
        }
        if (server != null) {
            parent.sv_serverTextField.setText(server);
        }
        if (user != null) {
            parent.sv_userTextField.setText(user);
        }
        if (query && password == null) {
            password = parent.getUserPassword("Enter a password for MySQL access");
        }
        if (password != null) {
            parent.passwordTextField.setText(password);
        }
        if (parent.readDatabaseList(false)) {
            if (database != null) {
                parent.sv_databaseComboBox.setSelectedItem(database);
            }
            if (table != null) {
                parent.sv_tableComboBox.setSelectedItem(table);
            }
        }
    }

    protected void process2() {
        if (query) {
            parent.formatRunQuery();
        } else {
            parent.passwordTextField.grabFocus();
        }
    }

    private void comHelp() {
        String help = "Usage: -f \"name of font\" -s server\n"
                + "       -u user -d database -t table\n"
                + "       -p password -r read table -b debug\n"
                + "       -h help\n";
        System.out.println(help);
        System.exit(0);
    }
}
