/*
 * Decompiled with CFR 0.152.
 */
package jdbclient;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollBar;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import jdbclient.Configurable;
import jdbclient.JDBClient;
import jdbclient.MyJTextField;
import jdbclient.MyTableCellRenderer;
import jdbclient.QueryControlRow;

public final class QueryProcessor
implements Configurable {
    JDBClient parent;
    JCheckBox checkBox;
    JTextField prefix = null;
    JTextField postfix = null;
    Map<Object, Integer> colWidths;
    Map<Integer, Integer> rowHeights;
    ArrayList<ArrayList<Object>> sqlData;
    Map<String, ArrayList<Object>> fieldMap = null;
    ArrayList<Object> sqlColNames = null;
    ArrayList<QueryControlRow> queryRows;
    String serverName;
    String userName;
    String password;
    String mysqlPort;
    String db = null;
    String table = null;
    String query = null;
    JTable displayTable = null;
    DefaultTableModel tableModel = null;
    ArrayList<String> primaryKeyFields = null;
    String recDelimiter = "<\t>";
    ArrayList<String> restoreState = null;
    boolean columnSortable = false;
    long startTime;
    long endTime;

    public QueryProcessor(JDBClient p, JCheckBox box, boolean cs) {
        this.parent = p;
        this.checkBox = box;
        this.columnSortable = cs;
        this.restoreState = new ArrayList();
        this.prefix = new JTextField();
        this.postfix = new JTextField();
        this.reset();
    }

    protected void reset() {
        this.queryRows = new ArrayList();
        this.sqlData = new ArrayList();
        this.sqlColNames = new ArrayList();
        this.colWidths = new HashMap<Object, Integer>();
        this.rowHeights = new HashMap<Integer, Integer>();
        this.primaryKeyFields = new ArrayList();
    }

    public void setup(String sn, String user, String pw, String mport, String qdb, String qtable, JTable qt) {
        this.serverName = sn;
        this.userName = user;
        this.password = pw;
        this.mysqlPort = mport;
        this.db = qdb;
        this.table = qtable;
        this.displayTable = qt;
    }

    protected void addQueryRow(QueryControlRow qr) {
        this.queryRows.add(qr);
    }

    private void updateWidthHeight(ArrayList<Object> vo, int row, JTable localTable) {
        int col = 0;
        int rowHeight = 1;
        for (Object k : this.sqlColNames) {
            String key = k.toString();
            if (col >= vo.size()) break;
            Object obj = vo.get(col);
            if (obj != null) {
                String s = obj.toString();
                String[] array = s.split("\n", -1);
                int cellHeight = array.length;
                rowHeight = Math.max(rowHeight, cellHeight);
                int width = 0;
                if (this.colWidths.containsKey(key)) {
                    width = this.colWidths.get(key);
                }
                for (String v : array) {
                    int strLen = v.length();
                    width = Math.max(strLen, width);
                }
                this.colWidths.put(key, width);
                if (localTable != null) {
                    width = width * this.parent.charWidth + this.parent.tablePaddingConstant * 4;
                    localTable.getColumn(key).setPreferredWidth(width);
                }
            }
            ++col;
        }
        if (row >= 0) {
            this.rowHeights.put(row, rowHeight);
        }
    }

    public void addRecord(ArrayList<Object> vo, int row, JTable table) {
        this.sqlData.add(vo);
        this.updateWidthHeight(vo, row, table);
    }

    public ArrayList<ArrayList<Object>> getData() {
        return this.sqlData;
    }

    public ArrayList<Object> getColumnNames() {
        return this.sqlColNames;
    }

    public Map<Object, Integer> getColumnWidths() {
        return this.colWidths;
    }

    public int getColumnWidth(String s) {
        if (this.colWidths.containsKey(s)) {
            return this.colWidths.get(s);
        }
        return 0;
    }

    public int getRecordCount() {
        return this.sqlData.size();
    }

    public void execMySQLQuery(String query) {
        this.startTime = System.currentTimeMillis();
        String dbUrl = this.parent.makeDBUrl(this.db);
        this.query = query;
        String queryText = null;
        String errorText = null;
        if (this.parent.validString(dbUrl) && this.parent.validString(this.userName) && this.parent.validString(this.password) && this.parent.validString(query)) {
            try {
                queryText = query;
                this.parent.queryDisp(query);
                Class.forName("com.mysql.jdbc.Driver").newInstance();
                Connection conn = DriverManager.getConnection(dbUrl, this.userName, this.password);
                Statement stmt = conn.createStatement();
                String escQuery = this.parent.escapeQueryArg(query);
                ResultSet rs = stmt.executeQuery(escQuery);
                ResultSetMetaData md = rs.getMetaData();
                int cols = md.getColumnCount();
                this.sqlColNames = new ArrayList();
                for (int i = 0; i < cols; ++i) {
                    String cl = md.getColumnLabel(i + 1);
                    this.sqlColNames.add(cl);
                }
                this.updateWidthHeight(this.sqlColNames, -1, null);
                this.sqlData = new ArrayList();
                int row = 0;
                while (rs.next()) {
                    ArrayList<Object> dataRecord = new ArrayList<Object>();
                    for (Object objkey : this.sqlColNames) {
                        String key = objkey.toString().trim();
                        Object obj = null;
                        try {
                            obj = rs.getObject(key);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        dataRecord.add(obj);
                    }
                    this.addRecord(dataRecord, row, null);
                    ++row;
                }
            }
            catch (Exception e) {
                if (this.parent.debug) {
                    e.printStackTrace(System.out);
                }
                errorText = e.getMessage();
            }
        }
        this.endTime = System.currentTimeMillis();
        this.parent.logEventAction(String.format("Q: %s", query), this.startTime, this.endTime, errorText);
    }

    protected int execMySQLUpdate(String query) {
        this.startTime = System.currentTimeMillis();
        String errorText = null;
        int changed = 0;
        try {
            String dbUrl = this.parent.makeDBUrl("");
            Connection conn = DriverManager.getConnection(dbUrl, this.userName, this.password);
            Statement stmt = conn.createStatement();
            String escQuery = this.parent.escapeQueryArg(query);
            changed = stmt.executeUpdate(escQuery);
        }
        catch (Exception e) {
            if (this.parent.debug) {
                e.printStackTrace(System.out);
            }
            errorText = e.getMessage();
        }
        this.endTime = System.currentTimeMillis();
        this.parent.logEventAction(String.format("Q: %s", query), this.startTime, this.endTime, errorText);
        return changed;
    }

    protected void populateQueryPanel(QueryProcessor qr) {
        this.parent.queryLayoutPanel.removeAll();
        if (this.parent.editFunctions != null) {
            this.parent.editFunctions.activateEdit(-1);
        }
        if (qr != null && qr.getRecordCount() > 0) {
            this.prefix.setText("");
            this.postfix.setText("");
            this.queryRows = new ArrayList();
            this.parent.queryScrollPane.getVerticalScrollBar().setUnitIncrement(16);
            boolean x = false;
            int y = 0;
            Insets insets = new Insets(-1, 2, -1, 2);
            JLabel freeLabel1 = new JLabel("<html><b>Prefix arguments:</b></html>");
            freeLabel1.setFont(this.parent.baseFont);
            this.prefix.setToolTipText("<html>Enter SQL to precede any entries below such as a selection filter<br/>May be blank, \"Enter\" executes, arrow keys browse history");
            this.parent.queryLayoutPanel.add((Component)freeLabel1, this.parent.createConstraints(0, y, 3, 0.0f, insets));
            this.parent.queryLayoutPanel.add((Component)this.prefix, this.parent.createConstraints(3, y, 6, 1.0f, insets));
            ++y;
            ArrayList<ArrayList<Object>> colNames = qr.getData();
            for (ArrayList<Object> obj : colNames) {
                this.addQueryRow(new QueryControlRow(this.parent, obj.get(0).toString(), y, this));
                ++y;
            }
            JLabel freeLabel2 = new JLabel("<html><b>Postfix arguments:</b></html>");
            freeLabel2.setFont(this.parent.baseFont);
            this.postfix.setToolTipText("<html>Enter SQL to follow any entries above like a WHERE or GROUP BY clause<br/>May be blank, \"Enter\" executes, arrow keys browse history");
            this.parent.queryLayoutPanel.add((Component)freeLabel2, this.parent.createConstraints(0, y, 3, 0.0f, insets));
            this.parent.queryLayoutPanel.add((Component)this.postfix, this.parent.createConstraints(3, y, 6, 1.0f, insets));
            this.parent.repaint();
        }
    }

    protected void setWidthsHeights() {
        if (this.displayTable != null && this.sqlColNames.size() > 0 && this.colWidths.size() > 0) {
            for (Object obj : this.sqlColNames) {
                if (!this.colWidths.containsKey(obj)) continue;
                int w = this.colWidths.get(obj) * this.parent.charWidth + this.parent.tablePaddingConstant * 4;
                this.displayTable.getColumn(obj).setPreferredWidth(w);
            }
            if (this.rowHeights.size() > 0) {
                for (int n = 0; n < this.displayTable.getRowCount(); ++n) {
                    if (!this.rowHeights.containsKey(n)) continue;
                    this.displayTable.setRowHeight(n, this.parent.tableRowHeight(this.rowHeights.get(n)));
                }
            } else {
                this.displayTable.setRowHeight(this.parent.tableRowHeight(1));
            }
        }
    }

    protected Object getRecordField(ArrayList<Object> rec, String key) {
        Object result = null;
        if (this.sqlColNames != null && rec != null && this.sqlColNames.contains(key)) {
            int col = this.sqlColNames.indexOf(key);
            result = rec.get(col);
        }
        return result;
    }

    protected Object getRecordField(int row, String key) {
        Object obj = null;
        if (row >= 0 && row < this.sqlData.size()) {
            obj = this.getRecordField(this.sqlData.get(row), key);
        }
        return obj;
    }

    protected Object getRecordField(String fieldName, String key) {
        if (this.fieldMap != null) {
            return this.getRecordField(this.fieldMap.get(fieldName), key);
        }
        return null;
    }

    protected ArrayList<Object> getRecordByFieldName(String fieldName) {
        if (this.fieldMap != null) {
            return this.fieldMap.get(fieldName);
        }
        return null;
    }

    protected void tableDescSetup() {
        this.mapFieldNamesToDescriptions();
        this.mapPrimaryKeys();
    }

    protected void mapFieldNamesToDescriptions() {
        this.fieldMap = new TreeMap<String, ArrayList<Object>>();
        for (ArrayList<Object> rec : this.sqlData) {
            String key = rec.get(0).toString();
            this.fieldMap.put(key, rec);
        }
    }

    protected boolean mapPrimaryKeys() {
        boolean result = false;
        for (ArrayList<Object> rec : this.sqlData) {
            String keyVal = (String)this.getRecordField(rec, "Key");
            if (keyVal == null || !keyVal.equals("PRI")) continue;
            this.primaryKeyFields.add((String)this.getRecordField(rec, "Field"));
            result = true;
        }
        return result;
    }

    public void setup(String[] columnNames) {
        this.sqlColNames.addAll(Arrays.asList(columnNames));
    }

    public void addRecord(String[] record) {
        ArrayList<Object> vs = new ArrayList<Object>();
        vs.addAll(Arrays.asList(record));
        int row = this.displayTable.getRowCount();
        ((DefaultTableModel)this.displayTable.getModel()).addRow(vs.toArray());
        this.addRecord(vs, row, this.displayTable);
        this.displayTable.setRowHeight(this.parent.tableRowHeight(1));
    }

    protected int getOriginalTableRow(int row) {
        int result = -1;
        if (this.displayTable != null && row >= 0 && row < this.displayTable.getRowCount() && this.displayTable.getColumnCount() > 0) {
            result = this.displayTable.convertRowIndexToModel(row);
        }
        return result;
    }

    protected DefaultTableModel createSortableTableModel() {
        Object[][] data = new Object[this.getData().size()][];
        int row = 0;
        for (ArrayList<Object> ao : this.getData()) {
            data[row++] = ao.toArray();
        }
        return new DefaultTableModel(data, this.getColumnNames().toArray()){
            static final long serialVersionUID = 23954L;

            @Override
            public Class<?> getColumnClass(int column) {
                if (column >= 0 && column < this.getColumnCount() && this.getRowCount() > 0) {
                    Object obj = this.getValueAt(0, column);
                    return obj == null ? Object.class : obj.getClass();
                }
                return Object.class;
            }
        };
    }

    protected void populateResultTable(boolean errorDisp) {
        try {
            this.tableModel = this.createSortableTableModel();
            this.displayTable.setModel(this.tableModel);
            this.displayTable.setAutoCreateRowSorter(this.columnSortable);
            this.setWidthsHeights();
            this.displayTable.setIntercellSpacing(new Dimension(-4, -4));
            this.displayTable.setGridColor(this.parent.tableBorderColor);
            this.displayTable.setShowGrid(true);
            this.displayTable.setDefaultRenderer(Object.class, new MyTableCellRenderer(this.parent, false, errorDisp));
            this.displayTable.getParent().setBackground(Color.white);
            this.setEllipsize(this.checkBox);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    protected void setEllipsize(JCheckBox box) {
        if (box != null) {
            boolean ellipsize = box.isSelected();
            this.displayTable.setAutoResizeMode(ellipsize ? 1 : 0);
        }
    }

    protected void vtab(MyJTextField tf, int v) {
        int sz;
        int ip;
        int i = 0;
        boolean j = false;
        for (QueryControlRow qr : this.queryRows) {
            if (tf == qr.leftEntryField) {
                j = false;
                break;
            }
            if (tf == qr.rightEntryField) {
                j = true;
                break;
            }
            ++i;
        }
        if ((ip = Math.abs((i + v + (sz = this.queryRows.size())) % sz)) >= 0 && ip < this.queryRows.size()) {
            QueryControlRow tr = this.queryRows.get(ip);
            MyJTextField targ = !j ? tr.leftEntryField : tr.rightEntryField;
            targ.grabFocus();
            Point p = targ.getLocation();
            JScrollBar vs = this.parent.queryScrollPane.getVerticalScrollBar();
            vs.setValue(p.y - vs.getHeight() / 2);
        }
    }

    protected boolean canRestore() {
        boolean restorable = this.restoreState.size() == this.queryRows.size() + 2;
        return restorable;
    }

    protected void restore() {
        if (this.canRestore()) {
            this.prefix.setText(this.restoreState.remove(0));
            this.postfix.setText(this.restoreState.remove(this.restoreState.size() - 1));
            for (QueryControlRow qr : this.queryRows) {
                qr.fromString(this.restoreState.remove(0));
            }
        }
    }

    @Override
    public void fromString(String data) {
        String[] array = data.split(this.recDelimiter, -1);
        this.restoreState.addAll(Arrays.asList(array));
    }

    @Override
    public String toString() {
        ArrayList<String> array = new ArrayList<String>();
        array.add(this.prefix == null ? "" : this.prefix.getText());
        for (QueryControlRow row : this.queryRows) {
            array.add(row.toString());
        }
        array.add(this.postfix == null ? "" : this.postfix.getText());
        return this.parent.joinStringCollection(array, this.recDelimiter);
    }

    public void p(String s) {
        System.out.println(s);
    }
}

