/*
 * Decompiled with CFR 0.152.
 */
package jdbclient;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JLabel;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultCaret;
import jdbclient.JDBClient;
import jdbclient.MyJTextArea;

public final class EditFunctions {
    JDBClient parent;
    int userSelectedRow = -1;
    int realRow = -1;
    boolean isChanged = false;
    boolean allowEdits = false;
    Map<String, MyJTextArea> editControls;
    ArrayList<MyJTextArea> editList;
    private String focusedControlFieldName = null;
    JLabel chooseLabel;
    boolean commitInProgress = false;
    int currentFocusedRow = -1;

    public EditFunctions(JDBClient p) {
        this.parent = p;
        this.chooseLabel = new JLabel();
        this.getAllowEditState();
        this.populateEditPane();
        this.parent.editScrollPane.getVerticalScrollBar().setUnitIncrement(16);
    }

    protected void setAllowEditState() {
        if (!this.askAbandonEdit()) {
            this.parent.sv_editAllowCheckBox.setSelected(this.allowEdits);
        }
        this.getAllowEditState();
    }

    protected boolean getAllowEditState() {
        boolean active;
        this.allowEdits = this.parent.sv_editAllowCheckBox.isSelected();
        this.chooseLabel.setEnabled(this.allowEdits);
        boolean bl = active = this.allowEdits && this.userSelectedRow >= 0 && this.parent.sv_currentQuery != null && this.parent.sv_currentQuery.getRecordCount() > 0;
        if (this.editControls != null && this.editControls.size() > 0) {
            for (String key : this.editControls.keySet()) {
                this.editControls.get(key).setEnabled(active);
            }
        }
        this.parent.priorButton.setEnabled(active);
        this.parent.nextButton.setEnabled(active);
        this.parent.sv_wordWrapCheckBox.setEnabled(active);
        this.parent.editCancelButton.setEnabled(this.isChanged && active);
        this.parent.editCommitButton.setEnabled(this.isChanged && active);
        this.parent.editCopyButton.setEnabled(active && !this.isChanged && this.parent.tableDescriptionQuery.mapPrimaryKeys());
        this.parent.editNewButton.setEnabled(!this.isChanged && this.allowEdits && this.parent.sv_currentQuery != null);
        this.parent.editDeleteButton.setEnabled(active && !this.isChanged);
        return this.allowEdits;
    }

    protected boolean askAbandonEdit() {
        if (this.isChanged) {
            boolean agree = this.parent.askUser("Okay to abandon an incomplete edit?");
            if (agree) {
                this.doCancel();
            } else {
                this.refocus();
            }
            return agree;
        }
        return true;
    }

    protected void activateEdit(int row) {
        if (this.commitInProgress) {
            return;
        }
        if (!this.askAbandonEdit()) {
            this.refocus();
            return;
        }
        this.isChanged = false;
        this.userSelectedRow = row;
        this.realRow = -1;
        if (row >= 0) {
            this.setRealRow();
            this.parent.performTabActions(this.parent.editingPanel);
        }
        this.populateEditPane();
        this.getAllowEditState();
        this.currentFocusedRow = this.userSelectedRow;
        this.identifySelectedRow();
    }

    protected void moveToTableRowDelta(int delta) {
        int max = this.parent.queryResultTable.getRowCount();
        this.currentFocusedRow += delta;
        this.currentFocusedRow = this.currentFocusedRow < 0 ? 0 : this.currentFocusedRow;
        this.currentFocusedRow = this.currentFocusedRow > max - 1 ? max - 1 : this.currentFocusedRow;
        this.focusRow(this.currentFocusedRow);
        this.activateEdit(this.currentFocusedRow);
    }

    protected void identifySelectedRow() {
        if (this.currentFocusedRow >= 0) {
            this.parent.selectedRecordLabel.setText(String.format("Selected record: %d", this.currentFocusedRow + 1));
        } else {
            this.parent.selectedRecordLabel.setText("No selected record");
        }
    }

    protected void setChanged() {
        this.isChanged = true;
        this.getAllowEditState();
    }

    protected void setRealRow() {
        this.realRow = this.parent.sv_currentQuery.getOriginalTableRow(this.userSelectedRow);
    }

    protected void refocus() {
        if (this.focusedControlFieldName != null) {
            this.editControls.get(this.focusedControlFieldName).grabFocus();
        }
    }

    protected void saveFocus(String fn) {
        this.focusedControlFieldName = fn;
    }

    protected void cancelEdit() {
        if (this.isChanged) {
            if (!this.parent.askUser("Okay to cancel current edit?")) {
                this.refocus();
            } else {
                this.doCancel();
            }
        }
    }

    protected void doCancel() {
        this.isChanged = false;
        this.getAllowEditState();
        this.populateEditPane();
        this.refocus();
    }

    protected void focusRow(int row) {
        if (this.parent.queryResultTable != null && row >= 0 && row < this.parent.queryResultTable.getRowCount()) {
            this.parent.queryResultTable.setRowSelectionInterval(row, row);
            Rectangle rect = new Rectangle(this.parent.queryResultTable.getCellRect(row, 0, true));
            this.parent.queryResultTable.scrollRectToVisible(rect);
            this.currentFocusedRow = row;
            this.identifySelectedRow();
        }
    }

    protected void focusBottomRow() {
        if (this.parent.queryResultTable != null) {
            this.focusRow(this.parent.queryResultTable.getRowCount() - 1);
        }
    }

    protected String dateTimeFormat(String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return "'" + sdf.format(new Date()) + "'";
    }

    protected void getFieldValue(String key, Object orig, ArrayList<String> fields, ArrayList<String> values) {
        if (!this.parent.tableDescriptionQuery.primaryKeyFields.contains(key)) {
            ArrayList<Object> desc = this.parent.tableDescriptionQuery.getRecordByFieldName(key);
            fields.add(String.format("`%s`", key));
            String type = (String)desc.get(1);
            if (orig != null) {
                values.add(String.format("'%s'", this.escapeSQL(orig)));
            } else if (type.equals("date")) {
                values.add(this.dateTimeFormat("yyyy-MM-dd"));
            } else if (type.equals("time")) {
                values.add(this.dateTimeFormat("HH:mm:ss"));
            } else if (type.matches("(?i).*(datetime|timestamp).*")) {
                values.add(this.dateTimeFormat("yyyy-MM-dd HH:mm:ss"));
            } else if (type.matches("(?i).*(decimal|float|double|int).*")) {
                values.add("'0'");
            } else if (type.matches("(?i).*(text|char).*")) {
                values.add("''");
            } else {
                if (orig == null) {
                    orig = type.matches(".*enum\\(.*") ? type.replaceFirst(".*enum\\('(.*?)'.*", "$1") : "";
                }
                values.add(String.format("'%s'", this.escapeSQL(orig)));
            }
        }
    }

    protected void newRecord() {
        if (this.parent.sv_currentQuery != null && this.askAbandonEdit()) {
            String db = this.parent.sv_currentQuery.db;
            String table = this.parent.sv_currentQuery.table;
            ArrayList<String> fields = new ArrayList<String>();
            ArrayList<String> values = new ArrayList<String>();
            for (Object obj : this.parent.sv_currentQuery.sqlColNames) {
                String key = (String)obj;
                this.getFieldValue(key, null, fields, values);
            }
            String fs = this.parent.joinStringCollection(fields, ",");
            String vs = this.parent.joinStringCollection(values, ",");
            String sql = String.format("INSERT INTO `%s`.`%s` (%s) VALUES (%s)", db, table, fs, vs);
            int changed = this.parent.sv_currentQuery.execMySQLUpdate(sql);
            this.updateChangedLabel(changed);
            this.parent.formatRunQuery();
            this.userSelectedRow = this.parent.queryResultTable.getRowCount() - 1;
            this.setRealRow();
            this.populateEditPane();
            this.focusRow(this.userSelectedRow);
            this.clearChanged();
            this.refocus();
        }
    }

    protected void deleteRecord() {
        if (this.userSelectedRow >= 0 && this.parent.sv_currentQuery != null && this.parent.sv_currentQuery.getRecordCount() > 0 && this.askAbandonEdit() && this.parent.askUser(String.format("Okay to delete record %d?", this.userSelectedRow + 1))) {
            this.parent.p("A");
            Map<String, Object> original = this.getOriginalRecord();
            ArrayList<String> where = new ArrayList<String>();
            for (Object obj : this.parent.sv_currentQuery.sqlColNames) {
                String key = (String)obj;
                Object orig = original.get(key);
                where.add(this.equalsPhrase(key, orig, false));
            }
            String db = this.parent.sv_currentQuery.db;
            String table = this.parent.sv_currentQuery.table;
            String set = this.parent.joinStringCollection(where, " AND ");
            String sql = String.format("DELETE FROM `%s`.`%s` WHERE %s", db, table, set);
            int changed = this.parent.sv_currentQuery.execMySQLUpdate(sql);
            this.updateChangedLabel(changed);
            this.parent.formatRunQuery();
            this.userSelectedRow = -1;
            this.populateEditPane();
            this.setRealRow();
            this.clearChanged();
            this.refocus();
        }
    }

    protected void copyRecord() {
        if (this.realRow >= 0 && this.parent.sv_currentQuery != null && this.parent.tableDescriptionQuery != null && this.askAbandonEdit()) {
            Map<String, Object> original = this.getOriginalRecord();
            ArrayList<String> fields = new ArrayList<String>();
            ArrayList<String> values = new ArrayList<String>();
            for (Object obj : this.parent.sv_currentQuery.sqlColNames) {
                String key = (String)obj;
                Object orig = original.get(key);
                this.getFieldValue(key, orig, fields, values);
            }
            String db = this.parent.sv_currentQuery.db;
            String table = this.parent.sv_currentQuery.table;
            String flds = this.parent.joinStringCollection(fields, ",");
            String vals = this.parent.joinStringCollection(values, ",");
            String sql = String.format("INSERT INTO `%s`.`%s` (%s) VALUES (%s)", db, table, flds, vals);
            int changed = this.parent.sv_currentQuery.execMySQLUpdate(sql);
            this.updateChangedLabel(changed);
            this.parent.formatRunQuery();
            this.userSelectedRow = this.parent.queryResultTable.getRowCount() - 1;
            this.setRealRow();
            this.populateEditPane();
            this.focusRow(this.userSelectedRow);
            this.clearChanged();
            this.refocus();
        }
    }

    protected void updateChangedLabel(int changed) {
        this.parent.changedRecordsLabel.setText(String.format("Changed records: %d", changed));
        this.parent.changedRecordsLabel.setForeground(changed == 0 ? this.parent.changedColor : Color.black);
    }

    protected void commitEdit() {
        if (this.realRow >= 0 && this.parent.sv_currentQuery != null) {
            Map<String, Object> original = this.getOriginalRecord();
            Map<String, MyJTextArea> edited = this.getEditedRecord();
            String sql = this.assembleEditString(original, edited);
            int changed = this.parent.sv_currentQuery.execMySQLUpdate(sql);
            this.updateChangedLabel(changed);
            this.commitInProgress = true;
            this.parent.formatRunQuery();
            this.commitInProgress = false;
            this.populateEditPane();
            this.setRealRow();
            this.clearChanged();
            this.refocus();
            this.parent.sv_currentQuery.displayTable.setRowSelectionInterval(this.realRow, this.realRow);
            this.focusRow(this.realRow);
        }
    }

    protected String assembleEditString(Map<String, Object> original, Map<String, MyJTextArea> edited) {
        ArrayList<String> update = new ArrayList<String>();
        ArrayList<String> where = new ArrayList<String>();
        String db = this.parent.sv_currentQuery.db;
        String table = this.parent.sv_currentQuery.table;
        for (Object obj : this.parent.sv_currentQuery.sqlColNames) {
            String key = (String)obj;
            Object orig = original.get(key);
            MyJTextArea edit = edited.get(key);
            if (edit.changed) {
                String se = edit.getText();
                if (se.equals("NULL")) {
                    se = null;
                }
                update.add(this.equalsPhrase(key, se, true));
            }
            where.add(this.equalsPhrase(key, orig, false));
        }
        String set = this.parent.joinStringCollection(update, " , ");
        String whs = this.parent.joinStringCollection(where, " AND ");
        return String.format("UPDATE `%s`.`%s` SET %s WHERE %s", db, table, set, whs);
    }

    protected String equalsPhrase(String key, Object value, boolean assign) {
        if (value == null) {
            if (assign) {
                return String.format("`%s` = NULL", key);
            }
            return String.format("`%s` is NULL", key);
        }
        String s = this.escapeSQL(value);
        String dtype = this.parent.dataType(key);
        String fmtstr = dtype.equals("tinyint(1)") ? "`%s` = %s" : "`%s` = '%s'";
        return String.format(fmtstr, key, s);
    }

    protected String escapeSQL(Object value) {
        String s;
        if (value == null) {
            s = "NULL";
        } else {
            s = value.toString();
            s = s.replaceAll("\\\\", "\\\\\\\\");
            s = s.replaceAll("'", "''");
        }
        return s;
    }

    protected Map<String, Object> getOriginalRecord() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        for (Object obj : this.parent.sv_currentQuery.sqlColNames) {
            String key = (String)obj;
            Object targ = this.parent.sv_currentQuery.getRecordField(this.realRow, key);
            map.put(key, targ);
        }
        return map;
    }

    protected Map<String, MyJTextArea> getEditedRecord() {
        TreeMap<String, MyJTextArea> map = new TreeMap<String, MyJTextArea>();
        for (Object obj : this.parent.sv_currentQuery.sqlColNames) {
            String key = (String)obj;
            map.put(key, this.editControls.get(key));
        }
        return map;
    }

    protected void clearChanged() {
        if (this.editControls != null) {
            for (String key : this.editControls.keySet()) {
                this.editControls.get(key).clearChanged();
            }
        }
        this.isChanged = false;
        this.getAllowEditState();
    }

    protected void reset() {
        this.populateEditPane();
    }

    protected void vtab(MyJTextArea ta, int v) {
        int pv = this.editList.indexOf(ta);
        int sz = this.editList.size();
        if ((pv = Math.abs(pv + v + sz) % sz) >= 0 && pv < this.editList.size()) {
            MyJTextArea targ = this.editList.get(pv);
            targ.grabFocus();
            Point p = targ.getLocation();
            JScrollBar vs = this.parent.editScrollPane.getVerticalScrollBar();
            vs.setValue(p.y - vs.getHeight() / 2);
        }
    }

    protected void populateEditPane() {
        this.parent.editControlPanel.removeAll();
        this.parent.editScrollPane.setHorizontalScrollBarPolicy(this.parent.sv_wordWrapCheckBox.isSelected() ? 31 : 30);
        if (this.parent.sv_currentQuery != null && this.parent.sv_currentQuery.getRecordCount() > 0 && this.realRow >= 0) {
            int scroll = this.parent.editScrollPane.getVerticalScrollBar().getValue();
            this.editControls = new HashMap<String, MyJTextArea>();
            this.editList = new ArrayList();
            Insets insets = new Insets(-1, 2, -1, 2);
            int y = 0;
            for (Object obj : this.parent.sv_currentQuery.sqlColNames) {
                String key = (String)obj;
                JLabel lbl = new JLabel(String.format("<html><b>%s:", key));
                lbl.setFont(this.parent.baseFont);
                this.parent.editControlPanel.add((Component)lbl, this.parent.createConstraints(0, y, 1, 0.0f, insets));
                MyJTextArea tf = new MyJTextArea(this.parent, this, key);
                tf.setLineWrap(this.parent.sv_wordWrapCheckBox.isSelected());
                tf.setWrapStyleWord(true);
                Object val = this.parent.sv_currentQuery.getRecordField(this.realRow, key);
                if (val == null) {
                    val = "NULL";
                }
                tf.setText(val.toString());
                tf.setToolTipText(String.format("<html>Compose or edit field \"%s\"<br/>Shift+Enter accepts,<br/>Shift+arrow key moves vertically", key));
                this.editControls.put(key, tf);
                this.editList.add(tf);
                DefaultCaret caret = (DefaultCaret)tf.getCaret();
                caret.setUpdatePolicy(2);
                this.parent.editControlPanel.add((Component)tf, this.parent.createConstraints(1, y, 1, 1.0f, insets));
                ++y;
            }
            this.scrollPaintLater(scroll);
        } else {
            String option = this.allowEdits ? "" : " select \"Allow Edits\" at the lower right, then";
            String s = String.format("To edit a record,%s click a row above.", option);
            int lm = (this.parent.getWidth() - s.length() * this.parent.charWidth) / 2;
            Insets insets = new Insets(16, lm, 0, 0);
            this.chooseLabel.setText("<html><h3>" + s);
            this.parent.editControlPanel.add((Component)this.chooseLabel, this.parent.createConstraints(0, 0, 1, 0.5f, insets));
            this.scrollPaintLater(0);
        }
    }

    protected void scrollPaintLater(final int scroll) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditFunctions.this.parent.editScrollPane.getVerticalScrollBar().setValue(scroll);
                EditFunctions.this.parent.repaint();
            }
        });
    }

    protected void resizeEvent() {
        if (this.editList != null) {
            // empty if block
        }
    }

    protected void resizeEvent2(int n) {
        if (n > 0) {
            this.parent.editControlPanel.validate();
            int w = this.parent.editScrollPane.getViewport().getSize().width;
            int h = this.parent.editControlPanel.getSize().height;
            Dimension d = new Dimension(w, h);
            this.p("resize: " + d + "," + n);
            this.parent.editControlPanel.setPreferredSize(d);
            this.resizeEvent2(n - 1);
        }
    }

    protected void addPrimaryKey() {
        String prompt;
        if (this.parent.sv_currentQuery != null && this.parent.askUser(prompt = String.format("Okay to add primary key to table \"%s.%s\"?\n(nearly always a good idea)", this.parent.sv_currentQuery.db, this.parent.sv_currentQuery.table))) {
            String pkname = "pk";
            int i = 0;
            while (this.parent.sv_currentQuery.sqlColNames.contains(pkname)) {
                pkname = String.format("pk%d", ++i);
            }
            String sql = String.format("alter table `%s`.`%s` add column %s integer not null auto_increment primary key", this.parent.sv_currentQuery.db, this.parent.sv_currentQuery.table, pkname);
            int changed = this.parent.sv_currentQuery.execMySQLUpdate(sql);
            this.updateChangedLabel(changed);
            this.commitInProgress = true;
            this.parent.formatRunQuery();
            this.commitInProgress = false;
            this.populateEditPane();
            this.clearChanged();
            this.refocus();
        }
    }

    public void p(String s) {
        System.out.println(s);
    }
}

