/*
 * Decompiled with CFR 0.152.
 */
package hdtvtestpattern;

import hdtvtestpattern.HDTVTestPattern;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.io.InputStream;
import javax.swing.GroupLayout;
import javax.swing.JPanel;

public class ImagePanel
extends JPanel {
    HDTVTestPattern parent;
    Font ttfFont = null;

    public ImagePanel(HDTVTestPattern p) {
        this.parent = p;
        this.initComponents();
        this.setBorder(null);
        try {
            InputStream is = HDTVTestPattern.class.getResourceAsStream("verdana.ttf");
            this.ttfFont = Font.createFont(0, is);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void paintComponent(Graphics gg) {
        super.paintComponent(gg);
        int width = this.getWidth();
        int height = this.getHeight();
        this.renderPattern(gg, width, height, true);
    }

    public void renderPattern(Graphics gg, int width, int height, boolean fromJava) {
        Graphics2D g2 = (Graphics2D)gg;
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setColor(Color.black);
        g2.fillRect(0, 0, width, height);
        Font numFont = this.ttfFont.deriveFont(0, 0.0065f * (float)width);
        Font hFont = numFont.deriveFont(0.011f * (float)width);
        FontMetrics metrics = g2.getFontMetrics(hFont);
        this.drawInstructions(g2, width, height, hFont, metrics, fromJava);
        AffineTransform fat = new AffineTransform();
        fat.rotate(1.5707963267948966);
        Font vFont = hFont.deriveFont(fat);
        int ch = metrics.getHeight();
        int cw = metrics.charWidth('H');
        FontMetrics hmetrics = g2.getFontMetrics(numFont);
        int fh = hmetrics.getHeight();
        int xs = (int)(0.012 * (double)width);
        int sh = (int)(0.0444 * (double)height);
        int oh = sh + fh + 10;
        int ybase = height / 2;
        int step = 4;
        int efw = width - (int)(0.043 * (double)width);
        Color[] cols = new Color[]{Color.white, Color.red, Color.green, Color.blue, Color.yellow, Color.magenta, Color.cyan};
        String[] colName = new String[]{"White", "Red", "Green", "Blue", "Yellow", "Magenta", "Cyan"};
        g2.setFont(vFont);
        int lyh = ybase + (fh + sh) * cols.length;
        this.drawLimits(g2, step, efw, xs, 16, ybase, lyh, "Black Reference", metrics);
        this.drawLimits(g2, step, efw, xs, 236, ybase, lyh, "White Reference", metrics);
        for (int y = 0; y < cols.length; ++y) {
            g2.setFont(numFont);
            this.drawStrip(g2, xs, step, fh, efw, ybase + y * oh, sh, cols[y], hmetrics);
            g2.setFont(hFont);
            g2.setColor(Color.black);
            g2.drawString(colName[y], width * 4 / 5, ybase + y * oh + sh * 2 / 3);
        }
        this.drawBorders(g2, ch, width, height, vFont, hFont, metrics);
    }

    private void drawStrip(Graphics2D g2, int xs, int step, int fh, int efw, int ys, int bh, Color col, FontMetrics metrics) {
        for (int i = 0; i <= 256; i += step) {
            int qr = col.getRed() * i / 256;
            int qg = col.getGreen() * i / 256;
            int qb = col.getBlue() * i / 256;
            int xp = xs + efw * i / 256;
            int bw = efw * step / 256 + 1;
            g2.setColor(new Color(qr, qg, qb));
            g2.fillRect(xp, ys, bw, bh);
            g2.setColor(Color.white);
            String s = "" + i;
            int w = metrics.stringWidth(s);
            float xt = (float)xp + (float)(bw - w) / 2.0f;
            int j = i > 0 ? i - 1 : i;
            g2.drawString("" + j, xt, (float)(ys + bh + fh));
        }
    }

    private void drawLimits(Graphics2D g2, int step, int efw, int xs, int x, int y, int h, String s, FontMetrics vmetrics) {
        int bw = efw * step / 256;
        int xp = xs + efw * x / 256 + bw / 2;
        int sw = vmetrics.stringWidth(s + "  ");
        g2.setColor(Color.gray);
        g2.drawLine(xp, y -= sw, xp, y + (h -= sw));
        g2.setColor(Color.white);
        g2.drawString(s, xp + 4, y);
    }

    private void drawInstructions(Graphics2D g2, int width, int height, Font font, FontMetrics metrics, boolean fromJava) {
        int lineHeight = (int)((double)metrics.getHeight() * 1.2);
        int charWidth = metrics.charWidth('H');
        g2.setFont(font);
        g2.setColor(Color.white);
        int vpos = 2;
        int hpos = 2;
        for (String s : this.parent.instructions) {
            if (s.matches(".*%dx%d.*")) {
                s = String.format(s, width, height);
            }
            if (s.matches("(?i).*press any key.*") && !fromJava) continue;
            if (s.substring(0, 1).equals(">")) {
                s = "    * " + s.substring(1);
            }
            vpos = this.printLine(g2, lineHeight, charWidth, hpos, vpos, s);
        }
    }

    private int printLine(Graphics2D g2, int lineHeight, int charWidth, int hPos, int vpos, String s) {
        g2.drawString(s, hPos * charWidth, vpos * lineHeight);
        return vpos + 1;
    }

    private void drawBorders(Graphics2D g2, int ch, int width, int height, Font vFont, Font hFont, FontMetrics metrics) {
        g2.setColor(Color.white);
        g2.drawRect(0, 0, width - 1, height - 1);
        String s = "White border indicates no overscan";
        int len = metrics.stringWidth(s);
        int h = (width - len) / 2;
        g2.setFont(hFont);
        g2.drawString(s, h, ch - 6);
        g2.drawString(s, h, height - 4);
        g2.setFont(vFont);
        int v = (height - len) / 2;
        g2.drawString(s, 4, v);
        g2.drawString(s, width - ch + 6, v);
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }
}

