/***************************************************************************
 *   Copyright (C) 2009 by Paul Lutus                                      *
 *   lutusp@arachnoid.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/*
 * GraphicControl.java
 *
 * Created on Mar 22, 2009, 4:30:51 PM
 */
package fftexplorer;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.text.NumberFormat;
import java.text.NumberFormat;
import java.util.Locale;
;

/**
 *
 * @author lutusp
 */
public class GraphicControl extends javax.swing.JPanel {

    boolean freq;
    FFTExplorer parent;
    GraphicPanel graphicPane;
   Vector<Double> hVals;
    double timeSpan = 1.0;
    double freqSpan = 1.0;

    /** Creates new form GraphicControl */
    public GraphicControl(FFTExplorer p, boolean freq) {
        parent = p;
        initComponents();
        this.freq = freq;
        idLabel.setText((freq) ? "Frequency span:" : "Time span:");
        graphicPane = new GraphicPanel(parent, this, freq);
        targetPanel.add((JPanel) graphicPane, BorderLayout.CENTER);
        new ComboControl(this, vertComboBox);
        new ComboControl(this, horizComboBox);
        setup(true);
    }

    public void setup(boolean first) {
        setupScale();
        hVals = new Vector<Double>();
        double[] steps = {1, 2, 4, 8};
        int vn = vertComboBox.getSelectedIndex();
        int hn = horizComboBox.getSelectedIndex();
        vertComboBox.removeAllItems();
        //hVals.removeAllElements();
        double v,w;
        for (int n = -6; n <= 6; n++) {
             v = Math.pow(10, n);
            for (int i = 0; i < steps.length; i++) {
                w = v * steps[i];
                vertComboBox.addItem(parent.formatNum(w));
            }
        }
        double q = (freq) ? freqSpan : timeSpan;
        horizComboBox.removeAllItems();
        for (int n = 0; n <= 6; n++) {
            v = Math.pow(10, n);
            for (int i = 0; i < steps.length; i++) {
                w = v * steps[i];
                horizComboBox.addItem(parent.getEngFormatString(q / w, freq));
                hVals.add(1 / w);
            }
        }
        // default indices
        vn = (first) ? 0 : vn;
        hn = (first) ? 0 : hn;
        vertComboBox.setSelectedIndex(vn);
        horizComboBox.setSelectedIndex(hn);
        adjustControls();
    }

    public void setupScale() {
        timeSpan = parent.arraySize / parent.sampleRate;
        freqSpan = parent.sampleRate / 2.0;
    }

    void setData(Complex[] data) {
        graphicPane.setData(data);
    }

    public void adjustControls() {
        graphicPane.vScale = getDouble(vertComboBox, graphicPane.vScale);
        graphicPane.antialias = parent.sv_antialiasCheckBox.isSelected();
        graphicPane.hScale = getDouble(horizComboBox, graphicPane.hScale);
        graphicPane.adjustOffset();
    }

    double getDouble(JComboBox box, double v) {
        if (box == horizComboBox) {
            int n = box.getSelectedIndex();
            v = hVals.get(n);
        } else {
            String s = (String) box.getSelectedItem();
            try {
                v = parent.numberFormat.parse(s).doubleValue();
            } catch (Exception e) {
                System.out.println("getDouble: " + e);
            }
        }
        return v;
    }

    void handleWheelEvent(MouseWheelEvent evt) {
        //parent.p("handlerwheelevent");
        double n = -evt.getWheelRotation();
        //n = (evt.isShiftDown()) ? n * 10 : n;
        //n = (evt.isAltDown()) ? n * 100 : n;
        int v = horizComboBox.getSelectedIndex();
        v += n;
        int top = horizComboBox.getItemCount();
        v = (v < 0) ? 0 : v;
        v = (v >= top) ? top - 1 : v;
        horizComboBox.setSelectedIndex(v);
        adjustControls();
      //  if (parent != null) {
      //      parent.readControls();
      //  }
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        cPanel = new javax.swing.JPanel();
        idLabel = new javax.swing.JLabel();
        horizComboBox = new javax.swing.JComboBox();
        vertComboBox = new javax.swing.JComboBox();
        jLabel1 = new javax.swing.JLabel();
        targetPanel = new javax.swing.JPanel();

        setBorder(null);
        setLayout(new java.awt.GridBagLayout());

        cPanel.setBackground(new java.awt.Color(254, 240, 230));
        cPanel.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        cPanel.setLayout(new java.awt.GridBagLayout());

        idLabel.setText("...");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        cPanel.add(idLabel, gridBagConstraints);

        horizComboBox.setBackground(new java.awt.Color(254, 240, 230));
        horizComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        cPanel.add(horizComboBox, gridBagConstraints);

        vertComboBox.setBackground(new java.awt.Color(254, 240, 230));
        vertComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        cPanel.add(vertComboBox, gridBagConstraints);

        jLabel1.setText("Vertical Gain:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        cPanel.add(jLabel1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        add(cPanel, gridBagConstraints);

        targetPanel.setBorder(null);
        targetPanel.setLayout(new java.awt.BorderLayout());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 10.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 0, 2);
        add(targetPanel, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel cPanel;
    protected javax.swing.JComboBox horizComboBox;
    private javax.swing.JLabel idLabel;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JPanel targetPanel;
    protected javax.swing.JComboBox vertComboBox;
    // End of variables declaration//GEN-END:variables
}
