/***************************************************************************
 *   Copyright (C) 2009 by Paul Lutus                                      *
 *   lutusp@arachnoid.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
package fftexplorer;

/*
 * FFTExplorer.java
 *
 * Created on November 10, 2004, 2:51 PM
 */
/**
 *
 * @author  lutusp
 */

import javax.swing.*;
import java.awt.*;

public final class FFTExplorerApp extends javax.swing.JFrame {

    FFTExplorer mainPanel;

    /** Creates new form FFTExplorer */
    public FFTExplorerApp(String[] args) {
        initComponents();
        mainPanel = new FFTExplorer(this,false,args);
        setTitle(mainPanel.appName + " " + mainPanel.appVersion);
        setIconImage(new ImageIcon(mainPanel.getClass().getResource("icons/" + mainPanel.appName + ".png")).getImage());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        getContentPane().add(mainPanel, gridBagConstraints);
    }

    

    void close() {
        //this.sv_helpScrollPos = helpPane.getScrollPos();
        mainPanel.initManager.writeConfig();
        setVisible(false);
        dispose();
        System.exit(0);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        generatorModeGroup = new javax.swing.ButtonGroup();

        setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                formWindowClosing(evt);
            }
        });
        getContentPane().setLayout(new java.awt.GridBagLayout());

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing
        // TODO add your handling code here:
        mainPanel.close();
    }//GEN-LAST:event_formWindowClosing

    /** Exit the Application */
    /**
     * @param args the command line arguments
     */
    public static void main(final String args[]) {

        try {
            // Set to use system-specific L&F
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        } catch (Exception e) {
            // handle exception
        }

        java.awt.EventQueue.invokeLater(new Runnable() {

            public void run() {
                new FFTExplorerApp(args).setVisible(true);
            }
        });
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup generatorModeGroup;
    // End of variables declaration//GEN-END:variables
}
