/*
 * Decompiled with CFR 0.152.
 */
package fftexplorer;

import fftexplorer.Complex;
import fftexplorer.FFT;
import fftexplorer.FFTExplorer;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SignalProcessor {
    FFTExplorer parent;
    FileInputStream fis;
    FFT fft;
    boolean inverse = false;
    boolean audioBusy = false;
    boolean playAudio;
    Thread graphicThread;
    boolean suspendSynth;
    boolean graphicThreadRunning = false;
    final double pi2 = Math.PI * 2;
    Complex[] inData = null;
    Complex[] outData = null;
    int mode;
    final int AM_MODE = 0;
    final int FM_MODE = 1;
    final int SW_MODE = 2;
    final int TW_MODE = 3;
    final int ST_MODE = 4;
    double audioLevel = 8192.0;
    double audioFactor = 1.0 / this.audioLevel;
    SourceDataLine sourceLine = null;
    AudioFormat audioFormat;
    ByteArrayOutputStream bos = new ByteArrayOutputStream();
    byte[] bdata = new byte[4096];
    double tt = 0.0;
    double dt;
    double fm_integral = 0.0;
    int arraySize;

    public SignalProcessor(FFTExplorer p) {
        this.parent = p;
        this.fft = new FFT();
    }

    public float getSampleRate() {
        return this.parent.arraySize;
    }

    public void initialize(boolean warm) {
        if (!warm) {
            this.playAudio = false;
        }
        if (warm && this.playAudio) {
            this.endPlayAudio();
            this.setupPlayAudio();
        }
        boolean wasRunning = this.graphicThreadRunning;
        if (this.graphicThreadRunning && this.inData.length != this.parent.arraySize) {
            this.stopSynthesis();
        }
        this.arraySize = this.parent.arraySize;
        if (this.inData == null || this.inData.length != this.arraySize) {
            this.fft.initialize(this.arraySize, this.inverse);
            this.inData = new Complex[this.arraySize];
            this.outData = new Complex[this.arraySize];
            for (int i2 = 0; i2 < this.arraySize; ++i2) {
                this.inData[i2] = new Complex();
                this.outData[i2] = new Complex();
            }
        }
        this.dt = 1.0 / this.parent.sampleRate;
        this.setMode();
        if (wasRunning) {
            this.startSynthesis();
        }
    }

    public void setMode() {
        if (this.parent.sv_amRadioButton.isSelected()) {
            this.mode = 0;
        } else if (this.parent.sv_fmRadioButton.isSelected()) {
            this.mode = 1;
        } else if (this.parent.sv_sqwRadioButton.isSelected()) {
            this.mode = 2;
        } else if (this.parent.sv_twRadioButton.isSelected()) {
            this.mode = 3;
        } else if (this.parent.sv_stRadioButton.isSelected()) {
            this.mode = 4;
        }
    }

    public void suspend(boolean susp) {
        this.suspendSynth = susp;
    }

    public void startSynthesis() {
        this.parent.audioCapture(false);
        this.parent.streamMP3(false);
        this.parent.setSampleRate();
        this.stopSynthesis();
        this.initialize(false);
        this.playAudio = this.parent.sv_soundCheckBox.isSelected();
        this.setupPlayAudio();
        this.synthesisThread();
    }

    public void synthDisplay(boolean display) {
        if (display) {
            this.startSynthesis();
        } else {
            this.stopSynthesis();
        }
        this.parent.startSynthButton.setEnabled(!this.graphicThreadRunning);
        this.parent.stopSynthButton.setEnabled(this.graphicThreadRunning);
    }

    private void synthesisThread() {
        this.suspendSynth = false;
        this.graphicThreadRunning = true;
        this.graphicThread = new Thread(){

            public void run() {
                while (SignalProcessor.this.graphicThreadRunning) {
                    if (SignalProcessor.this.suspendSynth) {
                        try {
                            Thread.sleep(250L);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    SignalProcessor.this.process();
                    SignalProcessor.this.parent.repaint();
                }
            }
        };
        this.graphicThread.start();
    }

    public void stopSynthesis() {
        this.endPlayAudio();
        try {
            if (this.graphicThreadRunning) {
                this.graphicThreadRunning = false;
                this.graphicThread.join();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.parent.setSampleRate();
    }

    public boolean processing() {
        return this.graphicThreadRunning;
    }

    public void process() {
        this.createData();
        this.process2();
    }

    private void process2() {
        this.parent.timeControl.setData(this.inData);
        this.playAudio(this.inData);
        this.processData();
        this.parent.freqControl.setData(this.outData);
    }

    public void readAudio(ByteArrayOutputStream stream) {
        if (!this.audioBusy) {
            this.audioBusy = true;
            int blen = this.arraySize * 2;
            int top = stream.size();
            if (top > blen) {
                Complex[] ta = this.inData;
                Complex[] tb = this.fft.inputArray();
                byte[] array = stream.toByteArray();
                int n2 = 0;
                for (int i2 = 0; i2 < blen; i2 += 2) {
                    double dv;
                    int v = array[i2 + 1] << 8;
                    ta[n2].re = dv = (double)(v |= array[i2] & 0xFF) * this.audioFactor;
                    tb[n2].re = dv;
                    ++n2;
                }
                stream.reset();
                this.readAudio2();
            } else {
                this.audioBusy = false;
            }
        }
    }

    public void readAudio(Vector<Float> vf) {
        if (!this.audioBusy) {
            int blen;
            this.audioBusy = true;
            Float[] data = vf.toArray(new Float[0]);
            int top = data.length;
            if (top > (blen = this.arraySize)) {
                Complex[] ta = this.inData;
                Complex[] tb = this.fft.inputArray();
                int n2 = 0;
                for (int i2 = 0; i2 < blen; ++i2) {
                    double v;
                    ta[n2].re = v = (double)data[i2].floatValue() * this.audioFactor;
                    tb[n2].re = v;
                    ++n2;
                }
                vf.clear();
                this.readAudio2();
            } else {
                this.audioBusy = false;
            }
        }
    }

    private void readAudio2() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SignalProcessor.this.process2();
                SignalProcessor.this.audioBusy = false;
            }
        });
    }

    private AudioFormat createAudioFormat() {
        int sampleSizeInBits = 16;
        int channels = 1;
        boolean signed = true;
        boolean bigEndian = false;
        return new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, this.getSampleRate(), sampleSizeInBits, channels, 2 * channels, this.getSampleRate(), bigEndian);
    }

    private void setupPlayAudio() {
        if (this.playAudio) {
            try {
                this.audioFormat = this.createAudioFormat();
                DataLine.Info info = new DataLine.Info(SourceDataLine.class, this.audioFormat);
                this.sourceLine = (SourceDataLine)AudioSystem.getLine(info);
                this.sourceLine.open(this.audioFormat);
                this.sourceLine.start();
                this.parent.setArraySizeLabelColor(true);
            }
            catch (Exception e2) {
                System.out.println("setupPlayAudio: " + e2);
                this.parent.beep();
                this.parent.setArraySizeLabelColor(false);
            }
        } else {
            this.sourceLine = null;
        }
    }

    public void flushAudio() {
        if (this.sourceLine != null) {
            this.sourceLine.flush();
        }
    }

    private void endPlayAudio() {
        if (this.sourceLine != null) {
            this.sourceLine.flush();
            this.sourceLine.stop();
            this.sourceLine.close();
            this.sourceLine = null;
            this.bos.reset();
        }
        this.parent.setArraySizeLabelColor(true);
    }

    private void audioWrite() {
        int canwrite = this.inData.length * 2;
        if (this.sourceLine != null && this.bos.size() == canwrite) {
            byte[] data = this.bos.toByteArray();
            try {
                this.sourceLine.write(data, 0, data.length);
            }
            catch (Exception e2) {
                System.out.println("audioWrite: " + e2);
            }
            this.bos.reset();
        }
    }

    private void playAudio(Complex[] data) {
        if (this.sourceLine != null) {
            double lvl = this.audioLevel * 0.5;
            try {
                for (int i2 = 0; i2 < data.length; ++i2) {
                    double dv = data[i2].re * lvl;
                    dv = Math.min(this.audioLevel, dv);
                    dv = Math.max(-this.audioLevel, dv);
                    int iv = (int)dv;
                    this.bos.write(iv & 0xFF);
                    this.bos.write(iv >> 8);
                }
                this.audioWrite();
            }
            catch (Exception e2) {
                System.out.println("playAudio " + e2);
            }
        }
    }

    private double randomNoiseSignal() {
        return (Math.random() - 0.5) * this.parent.noiseLevel;
    }

    private void createAMSignal(Complex[] ta, Complex[] tb) {
        for (int t = 0; t < this.arraySize; ++t) {
            this.tt += this.dt;
            double v = Math.sin(Math.PI * 2 * this.parent.carrier * this.tt) * (1.0 + Math.sin(Math.PI * 2 * this.parent.modFreq * this.tt) * this.parent.modLevel);
            ta[t].re = v += this.randomNoiseSignal();
            tb[t].re = v;
        }
    }

    private void createFMSignal(Complex[] ta, Complex[] tb) {
        for (int t = 0; t < this.arraySize; ++t) {
            this.tt += this.dt;
            this.fm_integral += Math.sin(Math.PI * 2 * this.parent.modFreq * this.tt);
            double v = Math.sin(Math.PI * 2 * this.parent.carrier * (this.tt + this.fm_integral * this.dt * this.parent.modLevel));
            ta[t].re = v += this.randomNoiseSignal();
            tb[t].re = v;
        }
    }

    private void createSQSignal(Complex[] ta, Complex[] tb) {
        for (int t = 0; t < this.arraySize; ++t) {
            this.tt += this.dt;
            double v = Math.sin(Math.PI * 2 * this.parent.carrier * this.tt);
            v = v < 0.0 ? -1.0 : (v > 0.0 ? 1.0 : 0.0);
            ta[t].re = v += this.randomNoiseSignal();
            tb[t].re = v;
        }
    }

    private void createTWSignal(Complex[] ta, Complex[] tb) {
        for (int t = 0; t < this.arraySize; ++t) {
            this.tt += this.dt;
            double v = 4.0 * this.parent.carrier * this.tt % 4.0;
            if (v >= 1.0 && v <= 3.0) {
                v = 2.0 - v;
            } else if (v > 3.0) {
                v -= 4.0;
            }
            ta[t].re = v += this.randomNoiseSignal();
            tb[t].re = v;
        }
    }

    private void createSTSignal(Complex[] ta, Complex[] tb) {
        for (int t = 0; t < this.arraySize; ++t) {
            this.tt += this.dt;
            double v = 2.0 * this.parent.carrier * this.tt % 2.0 - 1.0;
            ta[t].re = v += this.randomNoiseSignal();
            tb[t].re = v;
        }
    }

    private void createData() {
        switch (this.mode) {
            case 0: {
                this.createAMSignal(this.inData, this.fft.inputArray());
                break;
            }
            case 1: {
                this.createFMSignal(this.inData, this.fft.inputArray());
                break;
            }
            case 2: {
                this.createSQSignal(this.inData, this.fft.inputArray());
                break;
            }
            case 3: {
                this.createTWSignal(this.inData, this.fft.inputArray());
                break;
            }
            case 4: {
                this.createSTSignal(this.inData, this.fft.inputArray());
            }
        }
    }

    private void processData() {
        this.fft.fft1();
        Complex[] fftData = this.fft.outputArray();
        for (int i2 = 0; i2 < this.outData.length; ++i2) {
            this.outData[i2].assign(fftData[i2]);
        }
    }

    public Complex[] getInputData() {
        return this.inData;
    }

    public Complex[] getOutputData() {
        return this.fft.outputArray();
    }
}

