/*
 * Decompiled with CFR 0.152.
 */
package fftexplorer;

import fftexplorer.ColorButton;
import fftexplorer.FFTExplorer;
import fftexplorer.MutableDouble;
import fftexplorer.StringComparatorNoCase;
import java.awt.Component;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InitManager {
    FFTExplorer parent;
    String fileSep;
    String lineSep;
    String appName;
    String userDir;
    String userPath;
    String initPath;
    String fieldPrefix = "sv_";

    public InitManager(FFTExplorer p, boolean isApplet) {
        this.parent = p;
        this.lineSep = System.getProperty("line.separator");
        this.fileSep = System.getProperty("file.separator");
        this.appName = this.parent.getClass().getSimpleName();
        if (!isApplet) {
            this.userDir = System.getProperty("user.home");
            this.userPath = this.userDir + this.fileSep + "." + this.appName;
            this.initPath = this.userPath + this.fileSep + this.appName + ".ini";
            this.testMakeDirs(this.userPath);
        }
    }

    String[] parsePair(String val) {
        String[] pair = null;
        int p = val.indexOf("=");
        if (p > 0) {
            pair = new String[]{val.substring(0, p), val.substring(p + 1, val.length())};
            for (int i2 = 0; i2 < 2 && i2 < pair.length; ++i2) {
                pair[i2] = pair[i2].replaceFirst("^\\s*(.*?)\\s*$", "$1");
            }
        }
        return pair;
    }

    public void setConfig(String data) {
        if (data != null) {
            String[] values = data.split(this.lineSep);
            for (int i2 = 0; i2 < values.length; ++i2) {
                String item = this.strip(values[i2]);
                if ((item = item.replaceFirst("#.*$", "")).length() <= 0) continue;
                String[] pair = this.parsePair(item);
                this.readWriteField(this.parent, pair[0], pair[1]);
            }
        }
    }

    public void readConfig() {
        String data = this.readTextFile(this.initPath, this.lineSep);
        this.setConfig(data);
    }

    Rectangle parseRectangle(String value) {
        Vector<Integer> vi = new Vector<Integer>();
        Rectangle rect = null;
        try {
            String s = value.replaceFirst("^.*x=([-|\\d]+).*y=([-|\\d]+).*width=([-|\\d]+).*height=([-|\\d]+).*$", "$1,$2,$3,$4");
            String[] s_vals = s.split(",");
            for (int j2 = 0; j2 < s_vals.length; ++j2) {
                vi.add(Integer.parseInt(s_vals[j2]));
            }
            Iterator it = vi.iterator();
            rect = new Rectangle((Integer)it.next(), (Integer)it.next(), (Integer)it.next(), (Integer)it.next());
        }
        catch (Exception e2) {
            System.out.println(this.getClass().getName() + ": error: " + e2);
        }
        return rect;
    }

    String readWriteField(Component comp, String name, String value) {
        try {
            boolean write;
            Class<?> pc = comp.getClass();
            Field f2 = pc.getDeclaredField(name);
            Object obj = f2.get(comp);
            String classType = f2.getType().toString();
            classType = classType.replaceFirst(".*\\.(.*)", "$1");
            boolean bl = write = value != null;
            if (write) {
                value = this.strip(value);
            }
            if (classType.equals("int")) {
                if (write) {
                    f2.setInt(comp, Integer.parseInt(value));
                } else {
                    value = "" + f2.getInt(comp);
                }
            } else if (classType.equals("double")) {
                if (write) {
                    f2.setDouble(comp, this.parent.getDouble(value));
                } else {
                    value = "" + this.parent.formatNum(f2.getDouble(comp));
                }
            } else if (classType.equals("MutableDouble")) {
                if (write) {
                    ((MutableDouble)obj).v = this.parent.getDouble(value);
                } else {
                    value = "" + ((MutableDouble)obj).v;
                }
            } else if (classType.equals("boolean")) {
                if (write) {
                    f2.setBoolean(comp, value.equals("true"));
                } else {
                    value = "" + f2.getBoolean(comp);
                }
            } else if (classType.equals("String")) {
                if (write) {
                    f2.set(comp, value);
                } else {
                    value = (String)f2.get(comp);
                }
            } else if (classType.equals("Rectangle")) {
                if (write) {
                    Rectangle r = this.parseRectangle(value);
                    if (r != null) {
                        f2.set(comp, r);
                    }
                } else {
                    value = f2.get(comp).toString();
                }
            } else if (classType.equals("JRadioButton")) {
                JRadioButton button = (JRadioButton)obj;
                if (write) {
                    button.setSelected(value.equals("true"));
                } else {
                    value = "" + button.isSelected();
                }
            } else if (classType.equals("JCheckBox")) {
                JCheckBox cb = (JCheckBox)obj;
                if (write) {
                    cb.setSelected(value.equals("true"));
                } else {
                    value = "" + cb.isSelected();
                }
            } else if (classType.equals("JTextField")) {
                JTextField tf = (JTextField)obj;
                if (write) {
                    tf.setText(value);
                } else {
                    value = tf.getText();
                }
            } else if (classType.equals("JComboBox")) {
                JComboBox box = (JComboBox)obj;
                if (write) {
                    box.setSelectedIndex(Integer.parseInt(value));
                } else {
                    value = "" + box.getSelectedIndex();
                }
            } else if (classType.equals("JSpinner")) {
                JSpinner box = (JSpinner)obj;
                if (write) {
                    box.setValue(Integer.parseInt(value));
                } else {
                    value = "" + box.getValue();
                }
            } else if (classType.equals("JScrollBar")) {
                JScrollBar box = (JScrollBar)obj;
                if (write) {
                    int v = Integer.parseInt(value);
                    box.setValue(v);
                } else {
                    value = "" + box.getValue();
                }
            } else if (classType.equals("JTabbedPane")) {
                JTabbedPane tp = (JTabbedPane)obj;
                if (write) {
                    tp.setSelectedIndex(Integer.parseInt(value));
                } else {
                    value = "" + tp.getSelectedIndex();
                }
            } else if (classType.equals("ColorButton")) {
                ColorButton tp = (ColorButton)obj;
                if (write) {
                    tp.setColor(value);
                } else {
                    value = "" + tp;
                }
            } else if (classType.equals("JFrame")) {
                JFrame tp = (JFrame)obj;
                if (obj != null) {
                    if (write) {
                        Rectangle r = this.parseRectangle(value);
                        if (r != null) {
                            tp.setBounds(r);
                        }
                    } else {
                        value = "" + tp.getBounds();
                    }
                }
            } else {
                System.out.println(this.getClass().getName() + ": cannot decode value for " + classType + " (" + name + ")");
            }
        }
        catch (Exception e2) {
            System.out.println(this.getClass().getName() + ":readWriteField: \"" + name + "\": " + e2);
            e2.printStackTrace();
        }
        return value;
    }

    public void writeConfig() {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(this.initPath));
            bw.write(this.getConfig());
            bw.close();
        }
        catch (IOException e2) {
            System.out.println(e2);
        }
    }

    public String getConfig() {
        Vector<String> data = new Vector<String>();
        Hashtable<String, Field> fnht = this.getFieldNames();
        Enumeration<String> en = fnht.keys();
        while (en.hasMoreElements()) {
            Field field = fnht.get(en.nextElement());
            String name = field.getName();
            String value = this.readWriteField(this.parent, name, null);
            if (value == null) continue;
            data.add(name + " = " + value);
        }
        Collections.sort(data, new StringComparatorNoCase());
        String[] array = data.toArray(new String[0]);
        return this.join(array, this.lineSep) + this.lineSep;
    }

    Hashtable<String, Field> getFieldNames() {
        Hashtable<String, Field> hash = new Hashtable<String, Field>();
        Field[] fields = this.parent.getClass().getDeclaredFields();
        for (int i2 = 0; i2 < fields.length; ++i2) {
            Field field = fields[i2];
            String name = field.getName();
            if (!name.matches("^" + this.fieldPrefix + ".*")) continue;
            hash.put(name, field);
        }
        return hash;
    }

    String readTextFile(String path, String lineSep) {
        String s = null;
        File f2 = new File(path);
        if (f2.exists()) {
            StringBuffer sb = new StringBuffer();
            try {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(f2));
                while ((line = br.readLine()) != null) {
                    sb.append(line + lineSep);
                }
                br.close();
                s = sb.toString();
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        return s;
    }

    boolean testMakeDirs(String path) {
        File fpath = new File(path);
        if (fpath.exists()) {
            return false;
        }
        fpath.mkdirs();
        return true;
    }

    String join(String[] array, String delim) {
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < array.length; ++i2) {
            if (i2 > 0) {
                sb.append(delim);
            }
            sb.append(array[i2]);
        }
        return sb.toString();
    }

    String strip(String s) {
        return s.replaceFirst("^\\s*(.*?)\\s*$", "$1");
    }
}

