/*
 * Decompiled with CFR 0.152.
 */
package fftexplorer;

import fftexplorer.Complex;
import fftexplorer.FFTExplorer;
import fftexplorer.GraphicControl;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public final class GraphicPanel
extends JPanel {
    FFTExplorer parent;
    GraphicControl gc;
    boolean freqMode;
    boolean antialias;
    BufferedImage image = null;
    int oldxs = -1;
    int oldys = -1;
    int xsize;
    int ysize;
    double vScale = 1.0;
    double hScale = 1.0;
    Complex[] data = null;
    long t = 0L;
    long tl = 0L;
    int lineThickness = 1;
    int mousePressX;
    double xOffset = 0.0;
    boolean updateParent = false;

    public GraphicPanel(FFTExplorer p, GraphicControl gc, boolean freqMode) {
        this.parent = p;
        this.gc = gc;
        this.freqMode = freqMode;
        this.initComponents();
        this.xsize = this.getSize().width;
        this.ysize = this.getSize().height;
    }

    public void setupOffset() {
        this.xOffset = this.freqMode ? this.parent.sv_xFreqOffset : this.parent.sv_xTimeOffset;
        this.updateParent = true;
    }

    public void setData(Complex[] d2) {
        if (d2 != null) {
            this.data = d2;
            this.repaint();
        }
    }

    public void paintComponent(Graphics g2) {
        if (this.isVisible()) {
            Color lineColor = this.parent.sv_traceColor.getColor();
            this.xsize = this.getSize().width;
            this.ysize = this.getSize().height;
            if (this.xsize > 0 && this.ysize > 0) {
                if (this.xsize != this.oldxs || this.ysize != this.oldys) {
                    this.image = new BufferedImage(this.xsize, this.ysize, 1);
                    this.oldxs = this.xsize;
                    this.oldys = this.ysize;
                }
                Graphics2D ig = (Graphics2D)this.image.getGraphics();
                ig.setColor(this.parent.sv_backgroundColor.getColor());
                ig.fillRect(0, 0, this.xsize, this.ysize);
                if (this.antialias) {
                    RenderingHints rh = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    ig.addRenderingHints(rh);
                }
                if (this.freqMode) {
                    this.drawPointsFreq(ig, lineColor);
                } else {
                    this.drawPointsTime(ig, lineColor);
                }
                g2.drawImage(this.image, 0, 0, this);
                ig.dispose();
            }
        }
    }

    private void drawPointsFreq(Graphics2D cg, Color color) {
        if (this.data != null) {
            int width = this.parent.graphicLineWidth;
            double xScale = (double)this.data.length * this.hScale / 2.0;
            cg.setColor(color);
            int pxa = 0;
            int i2 = 0;
            while ((double)i2 < xScale) {
                int j2 = (int)((double)i2 + this.xOffset * xScale);
                double dy = j2 < 0 || j2 > this.data.length / 2 ? 0.0 : this.data[j2].mag() * this.vScale;
                pxa = (int)((double)i2 * (double)this.xsize / xScale);
                int pxb = (int)((double)(i2 + 1) * (double)this.xsize / xScale - (double)pxa);
                pxb = pxb < width ? width : pxb;
                dy = dy < 0.0 ? 0.0 : dy;
                dy = dy > 1.0 ? 1.0 : dy;
                int py = this.scalePoint(dy, this.ysize - 1, 0);
                cg.fillRect(pxa, py, pxb, this.ysize - 1);
                pxa = pxb;
                ++i2;
            }
        }
    }

    private void drawPointsTime(Graphics2D cg, Color color) {
        if (this.data != null) {
            if (this.parent.graphicLineWidth > 1) {
                cg.setStroke(new BasicStroke(this.parent.graphicLineWidth));
            }
            double zpoint = 0.5;
            double xScale = (double)(this.data.length - 1) * this.hScale;
            xScale = xScale < 1.0 ? 1.0 : xScale;
            cg.setColor(color);
            int opx = 0;
            int opy = 0;
            int i2 = 0;
            while ((double)i2 <= xScale) {
                int j2 = (int)((double)i2 + this.xOffset * xScale);
                double dy = j2 < 0 || j2 > this.data.length - 1 ? 0.0 : this.data[j2].re * this.vScale + zpoint;
                double dx = (double)i2 / xScale;
                int px = this.scalePoint(dx, 0, this.xsize);
                int py = this.scalePoint(dy, this.ysize - 1, 0);
                if (i2 > 0) {
                    cg.drawLine(opx, opy, px, py);
                }
                opx = px;
                opy = py;
                ++i2;
            }
        }
    }

    double dispToSpace(double x, double size) {
        return this.parent.ntrp(x, 0.0, size, 0.0, 1.0);
    }

    int scalePoint(double v, int a2, int b2) {
        return (int)(v * (double)(b2 - a2) + (double)a2);
    }

    double xOffsetLimit(double v) {
        v = v < 0.0 ? 0.0 : v;
        v = v > 1.0 / this.hScale - 1.0 ? 1.0 / this.hScale - 1.0 : v;
        return v;
    }

    void adjustOffset() {
        this.xOffset = this.xOffsetLimit(this.xOffset);
        if (this.updateParent) {
            if (this.freqMode) {
                this.parent.sv_xFreqOffset = this.xOffset;
            } else {
                this.parent.sv_xTimeOffset = this.xOffset;
            }
        }
    }

    void handleWheelEvent(MouseWheelEvent evt) {
        int x = evt.getX();
        double sx = this.dispToSpace(x, this.xsize);
        double delta = (this.xOffset + sx) * this.hScale;
        this.gc.handleWheelEvent(evt);
        this.xOffset = delta / this.hScale - sx;
        this.adjustOffset();
    }

    void handleMousePressed(MouseEvent evt) {
        this.mousePressX = evt.getX();
        if (evt.isPopupTrigger()) {
            this.parent.sv_graphicTipFlag = !this.parent.sv_graphicTipFlag;
        }
    }

    void handleMouseDragged(MouseEvent evt) {
        int deltaX = this.mousePressX - evt.getX();
        double offset = this.dispToSpace(deltaX, this.xsize);
        this.xOffset += offset;
        this.adjustOffset();
        this.mousePressX = evt.getX();
    }

    void handleMouseMoved(MouseEvent evt) {
        double x = evt.getX();
        double y = evt.getY();
        double sx = this.dispToSpace(x, this.xsize) + this.xOffset;
        double sub = this.freqMode ? 1.0 : 0.5;
        double sy = (sub - this.dispToSpace(y, this.ysize)) / this.vScale;
        String s = this.freqMode ? "Frequency:" : "Time:";
        s = s + " " + this.parent.getEngFormatString(sx *= (this.freqMode ? this.gc.freqSpan : this.gc.timeSpan) * this.hScale, this.freqMode);
        s = s + ", Amplitude: " + this.parent.formatNum(sy);
        this.parent.setStatus(s);
        if (this.parent.sv_graphicTipFlag) {
            this.setToolTipText("<html>" + s + "<br/>(right-click to hide)</html>");
        } else {
            this.setToolTipText(null);
        }
    }

    void handleMouseExited() {
        this.parent.setStatus("Status/Position");
    }

    private void initComponents() {
        this.setBackground(Color.white);
        this.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.setDoubleBuffered(false);
        this.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent evt) {
                GraphicPanel.this.formMouseWheelMoved(evt);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseExited(MouseEvent evt) {
                GraphicPanel.this.formMouseExited(evt);
            }

            public void mousePressed(MouseEvent evt) {
                GraphicPanel.this.formMousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                GraphicPanel.this.formMouseReleased(evt);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                GraphicPanel.this.formMouseDragged(evt);
            }

            public void mouseMoved(MouseEvent evt) {
                GraphicPanel.this.formMouseMoved(evt);
            }
        });
        this.setLayout(new BorderLayout());
    }

    private void formMouseWheelMoved(MouseWheelEvent evt) {
        this.handleWheelEvent(evt);
    }

    private void formMousePressed(MouseEvent evt) {
        this.handleMousePressed(evt);
    }

    private void formMouseDragged(MouseEvent evt) {
        this.handleMouseDragged(evt);
    }

    private void formMouseMoved(MouseEvent evt) {
        this.handleMouseMoved(evt);
    }

    private void formMouseReleased(MouseEvent evt) {
        this.handleMousePressed(evt);
    }

    private void formMouseExited(MouseEvent evt) {
        this.handleMouseExited();
    }
}

