/*
 * Decompiled with CFR 0.152.
 */
package fftexplorer;

import fftexplorer.FFTExplorer;
import fftexplorer.StringEscapeUnescape;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Calendar;
import javax.swing.JApplet;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import netscape.javascript.JSObject;

public class FFTExplorerApplet
extends JApplet {
    FFTExplorer mainPanel;
    String oldCookie = null;

    public void init() {
        try {
            Thread t = new Thread(){

                public void run() {
                    while (true) {
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        FFTExplorerApplet.this.writeCookie();
                    }
                }
            };
            t.start();
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    try {
                        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    FFTExplorerApplet.this.initComponents();
                    FFTExplorerApplet.this.mainPanel = new FFTExplorer(this, true, null);
                    GridBagConstraints gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.fill = 1;
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.weighty = 1.0;
                    FFTExplorerApplet.this.getContentPane().add((Component)FFTExplorerApplet.this.mainPanel, gridBagConstraints);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            String config = FFTExplorerApplet.this.readCookie();
                            FFTExplorerApplet.this.mainPanel.setConfig(config);
                        }
                    });
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void alert(String data) {
        System.out.println("alert: " + data);
    }

    void writeCookie(String data) {
        if (data != null) {
            data = StringEscapeUnescape.stringToHex(data);
            try {
                if (data != null) {
                    JSObject document;
                    Calendar c2 = Calendar.getInstance();
                    c2.add(2, 1);
                    String expires = "; expires=" + c2.getTime().toString();
                    JSObject browser = JSObject.getWindow(this);
                    if (browser != null && (document = (JSObject)browser.getMember("document")) != null) {
                        String cookie = data + expires;
                        document.setMember("cookie", cookie);
                    }
                }
            }
            catch (Exception e2) {
                System.out.println("writeCookie failed: " + e2);
            }
        }
    }

    public void writeCookie() {
        if (this.mainPanel != null) {
            String data = this.mainPanel.getConfig();
            if (data != null && this.oldCookie != null && !data.equals(this.oldCookie)) {
                this.writeCookie(data);
            }
            this.oldCookie = data;
        }
    }

    public String readCookie() {
        String result = null;
        try {
            String myCookie;
            JSObject browser = JSObject.getWindow(this);
            JSObject document = (JSObject)browser.getMember("document");
            if (document != null && (myCookie = (String)document.getMember("cookie")) != null && myCookie.length() > 0) {
                result = myCookie;
                result = result.replaceFirst("(.*?);.*", "$1");
            }
        }
        catch (Exception e2) {
            System.out.println("readCookie exception: " + e2);
        }
        if (result != null) {
            result = StringEscapeUnescape.hexToString(result);
        }
        return result;
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
    }
}

