/*
 * Decompiled with CFR 0.152.
 */
package fftexplorer;

import fftexplorer.FFTExplorer;
import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JColorChooser;

public class ColorButton {
    Color col;
    JButton button;
    FFTExplorer parent;

    public ColorButton(FFTExplorer p, JButton button, Color col, String tip) {
        this.col = col;
        this.init(p, button, tip);
    }

    public ColorButton(FFTExplorer p, JButton button, String s, String tip) {
        this.col = new Color(Integer.parseInt(s));
        this.init(p, button, tip);
    }

    public ColorButton(FFTExplorer p, JButton button, int c2, String tip) {
        this.col = new Color(c2);
        this.init(p, button, tip);
    }

    void init(FFTExplorer p, JButton button, String tip) {
        this.parent = p;
        this.button = button;
        button.setToolTipText(tip);
        button.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ColorButton.this.handleMouseClicked(evt);
            }
        });
        this.paintButton();
    }

    void paintButton() {
        int rgb = this.col.getRGB();
        String hex = Integer.toHexString(rgb);
        if (hex.length() == 8) {
            hex = hex.substring(2, 8);
        }
        String str = "<html><span style=\"background:#" + hex + ";\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</html>";
        this.button.setText(str);
        this.parent.repaint();
    }

    void handleMouseClicked(MouseEvent evt) {
        Color cc = JColorChooser.showDialog(this.parent, "Choose a color", this.col);
        if (cc != null) {
            this.col = cc;
            this.paintButton();
        }
    }

    public String toString() {
        return "" + this.col.getRGB();
    }

    public void setColor(String s) {
        this.col = new Color(Integer.parseInt(s));
        this.paintButton();
    }

    public void setColor(Color c2) {
        this.col = c2;
        this.paintButton();
    }

    public Color getColor() {
        return this.col;
    }
}

