/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class DataPane
extends JPanel {
    DataProspector parent;
    DataListener listener;
    ResultSet rs = null;
    int topRow = 0;
    int currentRow = 0;
    int rowChanged = -1;
    int columns = 0;
    boolean suspendChanges = false;
    boolean readOnly = false;
    private Vector formItems;
    private JComboBox optionsComboBox;
    private JMenuItem copyWithoutHeaderMenuItem;
    private JScrollPane jScrollPane1;
    private JButton appendButton;
    private JLabel jLabel1;
    private JMenuItem pasteClipboardWithHeaderMenuItem;
    private JButton deleteButton;
    private JPanel mutableFormPanel;
    private JMenuItem pasteCreateTableMenuItem;
    private JButton beginButton1;
    private JPanel tablePanel;
    public JTabbedPane dataTabbedPane;
    private JMenuItem pasteCreateTableNoHeaderMenuItem;
    private JMenuItem editMenuItem;
    private JPanel formPanel;
    private JMenuItem copyWithHeaderMenuItem;
    private JPanel formControlPanel;
    private JButton endButton;
    private JComboBox sqlComboBox;
    private JButton backButton2;
    private JTextField countTextField;
    private JTable dataTable;
    private JButton forwardButton;
    private JMenuItem appendMenuItem;
    private JTextField recordNumTextField;
    private JMenuItem pasteClipboardWithoutHeaderMenuItem;
    private JButton commitButton;
    private JButton executeButton;
    private JMenuItem deleteMenuItem;
    private JPopupMenu popupMenu;
    private JScrollPane formScrollPane;
    private JPanel bottomPanel;

    public DataPane(DataProspector p) {
        this.parent = p;
        this.initComponents();
        this.setupOptionList();
        this.parent.resetFont(this.dataTable);
    }

    private void setupOptionList() {
        String[] options = new String[]{"1 Line", "2 Lines", "4 Lines", "6 Lines", "8 Lines", "12 Lines", "16 Lines"};
        for (int i = 0; i < options.length; ++i) {
            this.optionsComboBox.addItem(options[i]);
        }
    }

    public JComboBox getOptionsBox() {
        return this.optionsComboBox;
    }

    private String formatSQLString(String table) {
        return "select * from " + table + ";";
    }

    private DefaultTableModel defaultTM() {
        return new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"});
    }

    public void setSQLStatement(String table) {
        this.parent.addComboItem(this.sqlComboBox, this.formatSQLString(table));
        this.parent.setSelectedIndex(this.sqlComboBox, 0);
        this.dataTable.setModel(this.defaultTM());
        this.rs = null;
    }

    public void populateTable(String table) {
        this.executeUserSQL(this.formatSQLString(table));
    }

    private void executeSQLString() {
        this.executeUserSQL((String)this.sqlComboBox.getSelectedItem());
    }

    private void executeUserSQL(String s) {
        if (s != null && s.length() > 0) {
            if (s.substring(0, 1).equals(">")) {
                if (this.parent.getConfigurationPanel().executeUpdate(s.substring(1))) {
                    this.parent.addComboItem(this.sqlComboBox, s);
                }
            } else {
                this.rs = null;
                System.gc();
                this.rs = this.parent.getConfigurationPanel().executeQuery(s);
                if (this.rs != null) {
                    this.parent.addComboItem(this.sqlComboBox, s);
                }
                this.processResultSet(0);
            }
        }
    }

    private void processResultSet(int row) {
        this.commitButton.setEnabled(false);
        this.populateTable();
        this.reviseForm(true);
        this.currentRow = row;
        this.dataToForm(this.currentRow);
    }

    private void populateTable() {
        if (this.rs != null) {
            try {
                try {
                    int sl;
                    this.dataTable.setVisible(false);
                    this.dataTable.setModel(new DefaultTableModel((Object[][])null, null));
                    this.dataTable.setVisible(true);
                    System.gc();
                    ResultSetMetaData rsmd = this.rs.getMetaData();
                    this.columns = rsmd.getColumnCount();
                    int[] colWidths = new int[this.columns];
                    Object[] fieldNames = new Object[this.columns];
                    for (int i = 0; i < this.columns; ++i) {
                        String name = rsmd.getColumnName(i + 1);
                        sl = name.length();
                        if (colWidths[i] < sl) {
                            colWidths[i] = sl;
                        }
                        fieldNames[i] = name;
                    }
                    this.rs.last();
                    this.topRow = this.rs.getRow();
                    Object[][] table = new Object[this.topRow][this.columns];
                    for (int i = 0; i < this.topRow; ++i) {
                        this.rs.absolute(i + 1);
                        for (int j = 0; j < this.columns; ++j) {
                            String field = this.rs.getString(j + 1);
                            if (field != null && colWidths[j] < (sl = field.length())) {
                                colWidths[j] = sl;
                            }
                            table[i][j] = field;
                        }
                    }
                    this.dataTable.setVisible(false);
                    this.dataTable.setModel(new DefaultTableModel(table, fieldNames){

                        public boolean isCellEditable(int row, int column) {
                            if (DataPane.this.parent.readOnly) {
                                return false;
                            }
                            return super.isCellEditable(row, column);
                        }
                    });
                    this.listener = new DataListener(this.dataTable);
                    this.parent.clearMessage();
                    this.countTextField.setText("" + this.topRow);
                    this.setColumnWidths(colWidths);
                    this.dataTable.setVisible(true);
                }
                catch (Exception e) {
                    this.parent.putMessage("ProcessResultSet", e);
                }
            }
            catch (OutOfMemoryError e) {
                System.gc();
                this.parent.putMessage("ProcessResultSet", new Exception("Out of Memory."));
            }
        }
    }

    private void setColumnWidths(int[] colWidths) {
        TableColumn column = null;
        Font tf = this.dataTable.getFont();
        FontMetrics fm = this.dataTable.getFontMetrics(tf);
        int charWidth = fm.charWidth('W');
        for (int i = 0; i < colWidths.length; ++i) {
            column = this.dataTable.getColumnModel().getColumn(i);
            if (colWidths[i] <= 0) continue;
            column.setPreferredWidth(colWidths[i] * charWidth);
        }
    }

    public void setupOptions(boolean save) {
        if (save) {
            this.parent.configHandler.putComboBox("sql", this.sqlComboBox);
        } else {
            this.parent.configHandler.getComboBox("sql", this.sqlComboBox);
        }
    }

    public void checkReadOnly() {
        if (this.formItems != null) {
            for (int i = 0; i < this.formItems.size(); ++i) {
                RowItem r = (RowItem)this.formItems.get(i);
                r.textArea.setEditable(!this.parent.readOnly);
                r.textField.setEditable(!this.parent.readOnly);
            }
        }
        this.appendMenuItem.setEnabled(!this.parent.readOnly);
        this.deleteMenuItem.setEnabled(!this.parent.readOnly);
        this.pasteClipboardWithoutHeaderMenuItem.setEnabled(!this.parent.readOnly);
        this.pasteClipboardWithHeaderMenuItem.setEnabled(!this.parent.readOnly);
        this.pasteCreateTableMenuItem.setEnabled(!this.parent.readOnly);
        this.pasteCreateTableNoHeaderMenuItem.setEnabled(!this.parent.readOnly);
        this.appendButton.setEnabled(!this.parent.readOnly);
        this.deleteButton.setEnabled(!this.parent.readOnly);
    }

    private void reviseForm(boolean newForm) {
        if (this.rs == null) {
            return;
        }
        this.mutableFormPanel.removeAll();
        try {
            ResultSetMetaData rsmd = this.rs.getMetaData();
            int cols = rsmd.getColumnCount();
            if (newForm) {
                this.formItems = new Vector();
            }
            GridBagConstraints gridWide = new GridBagConstraints();
            gridWide.fill = 2;
            gridWide.insets = new Insets(0, 4, 0, 4);
            gridWide.weightx = 1.0;
            gridWide.weighty = 0.0;
            gridWide.anchor = 11;
            GridBagConstraints gridNorm = new GridBagConstraints();
            gridNorm.fill = 2;
            gridNorm.insets = new Insets(0, 4, 0, 4);
            gridWide.weighty = 0.0;
            gridNorm.anchor = 11;
            for (int i = 0; i < cols; ++i) {
                RowItem r;
                if (newForm) {
                    r = new RowItem(rsmd.getColumnName(i + 1));
                    this.formItems.add(r);
                } else {
                    r = this.getRowItem(i);
                }
                gridNorm.gridy = i;
                gridWide.gridy = i;
                if (i == cols - 1) {
                    gridWide.weighty = 1.0;
                    gridNorm.weighty = 1.0;
                }
                gridNorm.gridx = 0;
                this.mutableFormPanel.add((Component)r.label, gridNorm);
                gridNorm.gridx = 1;
                String s = (String)this.optionsComboBox.getSelectedItem();
                s = s.split(" ")[0];
                int rows = 1;
                try {
                    rows = Integer.parseInt(s);
                }
                catch (Exception e) {
                    // empty catch block
                }
                int vSize = r.addTextElement(this.mutableFormPanel, gridWide, rows);
                if (i != 0) continue;
                Dimension d = this.formScrollPane.getViewport().getSize();
                d.height = vSize * cols;
                this.formScrollPane.getViewport().setSize(d);
            }
        }
        catch (SQLException e) {
            this.parent.putMessage("PopulateForm", e);
        }
        this.mutableFormPanel.invalidate();
        this.parent.validate();
    }

    private void dataToForm(int row) {
        if (this.rs == null) {
            return;
        }
        try {
            if (row < this.topRow) {
                this.rs.absolute(row + 1);
            }
            ResultSetMetaData rsmd = this.rs.getMetaData();
            int cols = rsmd.getColumnCount();
            for (int i = 0; i < cols; ++i) {
                String field = row < this.topRow ? this.rs.getString(i + 1) : "";
                if (field == null) {
                    field = "";
                }
                this.getRowItem(i).setData(field);
            }
        }
        catch (SQLException e) {
            this.parent.putMessage("PutFormData", e);
        }
        String status = row < this.topRow ? "Record " + (row + 1) + " of " + this.topRow : "New Record";
        this.recordNumTextField.setText(status);
    }

    private void changeRows(int delta) {
        this.updateRecordSet();
        this.currentRow += delta;
        if (this.currentRow < 0) {
            this.currentRow = 0;
            Toolkit.getDefaultToolkit().beep();
        }
        if (this.currentRow >= this.topRow) {
            this.currentRow = this.topRow - 1;
            Toolkit.getDefaultToolkit().beep();
        }
        this.dataToForm(this.currentRow);
    }

    private void appendRecord() {
        this.currentRow = this.topRow;
        this.dataToForm(this.currentRow);
    }

    private void deleteRecord() {
        if (this.parent.readOnly) {
            return;
        }
        int r = JOptionPane.showConfirmDialog(this, "OK to delete Record " + (this.currentRow + 1) + "?", "Confirm: Delete Record", 1);
        if (r == 0) {
            try {
                this.rs.absolute(this.currentRow + 1);
                this.rs.deleteRow();
                if (this.currentRow > 0) {
                    --this.currentRow;
                }
                this.processResultSet(this.currentRow);
            }
            catch (SQLException e) {
                this.parent.putMessage("DeleteRecord", e);
            }
        }
    }

    private RowItem getRowItem(int i) {
        return (RowItem)this.formItems.get(i);
    }

    private void updateRecordSet() {
        this.parent.clearMessage();
        if (this.rowChanged == this.currentRow) {
            this.rowChanged = -1;
            if (this.rs == null) {
                return;
            }
            boolean newRecord = false;
            boolean recChange = false;
            try {
                if (this.currentRow >= this.topRow) {
                    this.rs.moveToInsertRow();
                    newRecord = true;
                } else {
                    this.rs.absolute(this.currentRow + 1);
                }
                for (int i = 0; i < this.formItems.size(); ++i) {
                    String s;
                    boolean colChange = false;
                    RowItem item = this.getRowItem(i);
                    if (item.textAreaChanged) {
                        recChange = true;
                        colChange = true;
                        item.textAreaChanged = false;
                        s = item.textArea.getText();
                        this.rs.updateString(i + 1, s);
                    }
                    if (item.textFieldChanged) {
                        recChange = true;
                        colChange = true;
                        item.textFieldChanged = false;
                        s = item.textField.getText();
                        this.rs.updateString(i + 1, s);
                    }
                    if (colChange || !newRecord) continue;
                    this.rs.updateString(i + 1, "");
                }
                if (recChange) {
                    if (this.currentRow >= this.topRow) {
                        this.rs.insertRow();
                        this.rs.moveToCurrentRow();
                        ++this.topRow;
                    } else {
                        this.rs.updateRow();
                    }
                }
                this.commitButton.setEnabled(false);
            }
            catch (SQLException e) {
                this.parent.putMessage("Update Recordset", e);
            }
        }
    }

    private void handleMenu(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.popupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void editRecordInForm() {
        this.currentRow = this.dataTable.getSelectedRow();
        this.changeRows(0);
        this.dataTabbedPane.setSelectedIndex(1);
    }

    private void deleteRecordsFromMenu() {
        int r;
        if (this.parent.readOnly) {
            return;
        }
        if (this.rs == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        int[] selection = this.dataTable.getSelectedRows();
        if (selection != null && selection.length > 0 && (r = JOptionPane.showConfirmDialog(this, "OK to delete " + selection.length + " record(s)?", "Confirm: Delete Selected Records", 1)) == 0) {
            try {
                for (int i = selection.length - 1; i >= 0; --i) {
                    int row = selection[i];
                    this.rs.absolute(row + 1);
                    this.rs.deleteRow();
                    if (this.currentRow < row) continue;
                    --this.currentRow;
                }
                this.processResultSet(this.currentRow);
            }
            catch (SQLException e) {
                this.parent.putMessage("Delete records", e);
            }
        }
    }

    private void appendRecordFromMenu() {
        if (this.parent.readOnly) {
            return;
        }
        this.suspendChanges = true;
        Object[] blank = new String[this.columns];
        for (int i = 0; i < blank.length; ++i) {
            blank[i] = "";
        }
        ((DefaultTableModel)this.dataTable.getModel()).addRow(blank);
        this.suspendChanges = false;
    }

    private void copySelection(boolean includeHeaderLine) {
        if (this.rs == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        try {
            int i;
            StringBuffer data = new StringBuffer();
            ResultSetMetaData rsmd = this.rs.getMetaData();
            int columns = rsmd.getColumnCount();
            if (includeHeaderLine) {
                StringBuffer headers = new StringBuffer();
                for (i = 0; i < columns; ++i) {
                    String name = rsmd.getColumnName(i + 1);
                    headers.append(name);
                    if (i >= columns - 1) continue;
                    headers.append("\t");
                }
                data.append(headers + "\n");
            }
            int[] selection = this.dataTable.getSelectedRows();
            for (i = 0; i < selection.length; ++i) {
                int row = selection[i];
                StringBuffer record = new StringBuffer();
                for (int col = 0; col < columns; ++col) {
                    String field = (String)this.dataTable.getValueAt(row, col);
                    field = field.replaceAll("\\n", "\\\\n");
                    field = field.replaceAll("\\t", "\\\\t");
                    record.append(field);
                    if (col >= columns - 1) continue;
                    record.append("\t");
                }
                data.append(record + "\n");
            }
            Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection contents = new StringSelection(data.toString());
            clip.setContents(contents, null);
        }
        catch (Exception e) {
            this.parent.putMessage("Copy selection", e);
        }
    }

    private String[] splitFields(String data, String token) {
        int b;
        Vector<String> v = new Vector<String>();
        int a = 0;
        int tlen = token.length();
        while ((b = data.indexOf(token, a)) != -1) {
            v.add(data.substring(a, b));
            a = b + tlen;
        }
        v.add(data.substring(a));
        return v.toArray(new String[v.size()]);
    }

    private String[] splitRecords(String data, String token) {
        int p = data.indexOf(token);
        if (p == -1) {
            for (int i = 0; i < data.length(); ++i) {
                if (data.charAt(i) >= '\u0000') continue;
                token = String.valueOf(data.charAt(i));
                break;
            }
        }
        return data.split(token);
    }

    private void pasteRecords(boolean includeHeaderLine) {
        if (this.parent.readOnly) {
            return;
        }
        if (this.rs == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        try {
            ResultSetMetaData rsmd = this.rs.getMetaData();
            int columns = rsmd.getColumnCount();
            Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable content = clip.getContents(this);
            String data = (String)content.getTransferData(DataFlavor.stringFlavor);
            String recordDelim = "\n";
            String[] records = this.splitRecords(data, recordDelim);
            for (int row = 0; row < records.length; ++row) {
                if (row <= 0 && includeHeaderLine) continue;
                String[] fields = this.splitFields(records[row], "\t");
                if (fields.length != columns) {
                    int r = JOptionPane.showConfirmDialog(this, "Wrong number of fields (" + fields.length + ") in record " + (row + 1) + ", aborting transfer.", "Error: Field Count", 2);
                    return;
                }
                this.rs.moveToInsertRow();
                for (int col = 0; col < fields.length; ++col) {
                    String field = fields[col];
                    field = field.replaceAll("\\\\t", "\t");
                    field = field.replaceAll("\\\\n", "\n");
                    this.rs.updateString(col + 1, field);
                }
                this.rs.insertRow();
                this.rs.moveToCurrentRow();
            }
            this.executeSQLString();
        }
        catch (Exception e) {
            this.parent.putMessage("Paste selection", e);
        }
    }

    private void pasteCreateTable(boolean hasHeader) {
        if (this.parent.readOnly) {
            return;
        }
        String columnDelim = this.parent.configHandler.getSingleValue("ColumnDelim_" + this.parent.driverTag);
        try {
            String tableName;
            int startRec;
            Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable content = clip.getContents(this);
            String data = (String)content.getTransferData(DataFlavor.stringFlavor);
            String recordDelim = "\n";
            String[] records = this.splitRecords(data, recordDelim);
            int rows = records.length;
            int n = startRec = hasHeader ? 1 : 0;
            if (records.length > 0) {
                String[] topRow = this.splitFields(records[0], "\t");
                int columns = topRow.length;
                tableName = JOptionPane.showInputDialog("Enter name for new table with " + (rows - startRec) + " rows and " + columns + " columns:");
                if (tableName != null && tableName.length() > 0) {
                    StringBuffer sb = new StringBuffer();
                    tableName = columnDelim + tableName + columnDelim;
                    sb.append("create table " + tableName + " (");
                    for (int i = 0; i < columns; ++i) {
                        String hf;
                        if (hasHeader) {
                            hf = topRow[i];
                            hf = hf.replaceAll("\\s", "_");
                        } else {
                            hf = "Col_" + i;
                        }
                        sb.append(columnDelim + hf + columnDelim);
                        sb.append(" text not null");
                        if (i >= columns - 1) continue;
                        sb.append(",");
                    }
                    sb.append(")");
                    this.parent.getConfigurationPanel().executeUpdate(sb.toString());
                    for (int row = startRec; row < rows; ++row) {
                        sb = new StringBuffer();
                        sb.append("insert into " + tableName + " values (");
                        String[] fields = this.splitFields(records[row], "\t");
                        for (int col = 0; col < columns; ++col) {
                            String field = col < fields.length ? fields[col] : "";
                            field = field.replaceAll("\\'", "\\\\'");
                            sb.append("'" + field + "'");
                            if (col >= columns - 1) continue;
                            sb.append(",");
                        }
                        sb.append(")");
                        this.parent.getConfigurationPanel().executeUpdate(sb.toString());
                    }
                }
            } else {
                throw new Exception("Clipboard doesn't contain a table.");
            }
            this.populateTable(tableName);
        }
        catch (Exception e) {
            this.parent.putMessage("Paste Create Table", e);
        }
    }

    private void initComponents() {
        this.popupMenu = new JPopupMenu();
        this.editMenuItem = new JMenuItem();
        this.appendMenuItem = new JMenuItem();
        this.copyWithHeaderMenuItem = new JMenuItem();
        this.copyWithoutHeaderMenuItem = new JMenuItem();
        this.pasteClipboardWithHeaderMenuItem = new JMenuItem();
        this.pasteClipboardWithoutHeaderMenuItem = new JMenuItem();
        this.pasteCreateTableMenuItem = new JMenuItem();
        this.pasteCreateTableNoHeaderMenuItem = new JMenuItem();
        this.deleteMenuItem = new JMenuItem();
        this.bottomPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.executeButton = new JButton();
        this.sqlComboBox = new JComboBox();
        this.countTextField = new JTextField();
        this.dataTabbedPane = new JTabbedPane();
        this.tablePanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.dataTable = new JTable();
        this.formPanel = new JPanel();
        this.formControlPanel = new JPanel();
        this.deleteButton = new JButton();
        this.beginButton1 = new JButton();
        this.backButton2 = new JButton();
        this.recordNumTextField = new JTextField();
        this.forwardButton = new JButton();
        this.endButton = new JButton();
        this.appendButton = new JButton();
        this.commitButton = new JButton();
        this.optionsComboBox = new JComboBox();
        this.formScrollPane = new JScrollPane();
        this.mutableFormPanel = new JPanel();
        this.editMenuItem.setText("Show record in form");
        this.editMenuItem.setToolTipText("Jump to this record in form display");
        this.editMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataPane.this.editMenuItemActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.editMenuItem);
        this.appendMenuItem.setText("Append new record");
        this.appendMenuItem.setToolTipText("Append a blank record to the current table");
        this.appendMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataPane.this.appendMenuItemActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.appendMenuItem);
        this.copyWithHeaderMenuItem.setText("Copy data with header");
        this.copyWithHeaderMenuItem.setToolTipText("Copy selected records to system clipboard with header row");
        this.copyWithHeaderMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataPane.this.copyWithHeaderMenuItemActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.copyWithHeaderMenuItem);
        this.copyWithoutHeaderMenuItem.setText("Copy data without header");
        this.copyWithoutHeaderMenuItem.setToolTipText("Copy selected records to system clipboard without header row");
        this.copyWithoutHeaderMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataPane.this.copyWithoutHeaderMenuItemActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.copyWithoutHeaderMenuItem);
        this.pasteClipboardWithHeaderMenuItem.setText("Paste data with header");
        this.pasteClipboardWithHeaderMenuItem.setToolTipText("Paste system clipboard data that includes a header line (it is discarded)");
        this.pasteClipboardWithHeaderMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataPane.this.pasteClipboardWithHeaderMenuItemActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.pasteClipboardWithHeaderMenuItem);
        this.pasteClipboardWithoutHeaderMenuItem.setText("Paste data without header");
        this.pasteClipboardWithoutHeaderMenuItem.setToolTipText("Paste system clipboard data that has no header line");
        this.pasteClipboardWithoutHeaderMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataPane.this.pasteClipboardWithoutHeaderMenuItemActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.pasteClipboardWithoutHeaderMenuItem);
        this.pasteCreateTableMenuItem.setText("Paste data with header into new table ...");
        this.pasteCreateTableMenuItem.setToolTipText("Paste clipboard contents including header into new table");
        this.pasteCreateTableMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataPane.this.pasteCreateTableMenuItemActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.pasteCreateTableMenuItem);
        this.pasteCreateTableNoHeaderMenuItem.setText("Paste data without header into new table ...");
        this.pasteCreateTableNoHeaderMenuItem.setToolTipText("Paste clipboard contents without header into new table");
        this.pasteCreateTableNoHeaderMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataPane.this.pasteCreateTableNoHeaderMenuItemActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.pasteCreateTableNoHeaderMenuItem);
        this.deleteMenuItem.setText("Delete selected record(s) ...");
        this.deleteMenuItem.setToolTipText("Delete records from database (with confirmation)");
        this.deleteMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataPane.this.deleteMenuItemActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.deleteMenuItem);
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder("Data"));
        this.setMaximumSize(new Dimension(263, 100));
        this.bottomPanel.setLayout(new GridBagLayout());
        this.jLabel1.setText("SQL:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.bottomPanel.add((Component)this.jLabel1, gridBagConstraints);
        this.executeButton.setText("Execute");
        this.executeButton.setToolTipText("Press to execute SQL");
        this.executeButton.setDefaultCapable(false);
        this.executeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataPane.this.executeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.bottomPanel.add((Component)this.executeButton, gridBagConstraints);
        this.sqlComboBox.setEditable(true);
        this.sqlComboBox.setToolTipText("Use prefix \">\" for non-query SQL statements");
        this.sqlComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataPane.this.sqlComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.bottomPanel.add((Component)this.sqlComboBox, gridBagConstraints);
        this.countTextField.setEditable(false);
        this.countTextField.setText("0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.bottomPanel.add((Component)this.countTextField, gridBagConstraints);
        this.add((Component)this.bottomPanel, "South");
        this.dataTabbedPane.setTabPlacement(3);
        this.tablePanel.setLayout(new BorderLayout());
        this.tablePanel.setBorder(new TitledBorder("Table"));
        this.jScrollPane1.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                DataPane.this.jScrollPane1MousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                DataPane.this.jScrollPane1MouseReleased(evt);
            }
        });
        this.dataTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.dataTable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                DataPane.this.dataTableMousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                DataPane.this.dataTableMouseReleased(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.dataTable);
        this.tablePanel.add((Component)this.jScrollPane1, "Center");
        this.dataTabbedPane.addTab("Table", this.tablePanel);
        this.formPanel.setLayout(new BorderLayout());
        this.formPanel.setBorder(new TitledBorder("Form"));
        this.formControlPanel.setLayout(new GridBagLayout());
        this.deleteButton.setText("Delete");
        this.deleteButton.setToolTipText("Delete current record");
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataPane.this.deleteButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.formControlPanel.add((Component)this.deleteButton, gridBagConstraints);
        this.beginButton1.setText("<<");
        this.beginButton1.setToolTipText("Jump to first record");
        this.beginButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataPane.this.beginButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.formControlPanel.add((Component)this.beginButton1, gridBagConstraints);
        this.backButton2.setText("<");
        this.backButton2.setToolTipText("Back one record");
        this.backButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataPane.this.backButton2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.formControlPanel.add((Component)this.backButton2, gridBagConstraints);
        this.recordNumTextField.setEditable(false);
        this.recordNumTextField.setHorizontalAlignment(0);
        this.recordNumTextField.setText("0");
        this.recordNumTextField.setPreferredSize(new Dimension(4, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.formControlPanel.add((Component)this.recordNumTextField, gridBagConstraints);
        this.forwardButton.setText(">");
        this.forwardButton.setToolTipText("Forward one record");
        this.forwardButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataPane.this.forwardButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.formControlPanel.add((Component)this.forwardButton, gridBagConstraints);
        this.endButton.setText(">>");
        this.endButton.setToolTipText("Jump to last record");
        this.endButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataPane.this.endButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.formControlPanel.add((Component)this.endButton, gridBagConstraints);
        this.appendButton.setText("*");
        this.appendButton.setToolTipText("Append a new record");
        this.appendButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataPane.this.appendButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.formControlPanel.add((Component)this.appendButton, gridBagConstraints);
        this.commitButton.setText("Commit");
        this.commitButton.setToolTipText("Commit changes to database");
        this.commitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataPane.this.commitButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.formControlPanel.add((Component)this.commitButton, gridBagConstraints);
        this.optionsComboBox.setToolTipText("Choose number of editing lines");
        this.optionsComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataPane.this.optionsComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.formControlPanel.add((Component)this.optionsComboBox, gridBagConstraints);
        this.formPanel.add((Component)this.formControlPanel, "South");
        this.formScrollPane.setHorizontalScrollBarPolicy(31);
        this.formScrollPane.setPreferredSize(new Dimension(200, 1000));
        this.mutableFormPanel.setLayout(new GridBagLayout());
        this.formScrollPane.setViewportView(this.mutableFormPanel);
        this.formPanel.add((Component)this.formScrollPane, "Center");
        this.dataTabbedPane.addTab("Form", this.formPanel);
        this.add((Component)this.dataTabbedPane, "Center");
    }

    private void pasteCreateTableNoHeaderMenuItemActionPerformed(ActionEvent evt) {
        this.pasteCreateTable(false);
    }

    private void pasteCreateTableMenuItemActionPerformed(ActionEvent evt) {
        this.pasteCreateTable(true);
    }

    private void jScrollPane1MouseReleased(MouseEvent evt) {
        this.handleMenu(evt);
    }

    private void jScrollPane1MousePressed(MouseEvent evt) {
        this.handleMenu(evt);
    }

    private void pasteClipboardWithHeaderMenuItemActionPerformed(ActionEvent evt) {
        this.pasteRecords(true);
    }

    private void pasteClipboardWithoutHeaderMenuItemActionPerformed(ActionEvent evt) {
        this.pasteRecords(false);
    }

    private void copyWithHeaderMenuItemActionPerformed(ActionEvent evt) {
        this.copySelection(true);
    }

    private void copyWithoutHeaderMenuItemActionPerformed(ActionEvent evt) {
        this.copySelection(false);
    }

    private void appendMenuItemActionPerformed(ActionEvent evt) {
        this.appendRecordFromMenu();
    }

    private void deleteMenuItemActionPerformed(ActionEvent evt) {
        this.deleteRecordsFromMenu();
    }

    private void editMenuItemActionPerformed(ActionEvent evt) {
        this.editRecordInForm();
    }

    private void dataTableMouseReleased(MouseEvent evt) {
        this.handleMenu(evt);
    }

    private void dataTableMousePressed(MouseEvent evt) {
        this.handleMenu(evt);
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        this.deleteRecord();
    }

    private void appendButtonActionPerformed(ActionEvent evt) {
        this.appendRecord();
    }

    private void commitButtonActionPerformed(ActionEvent evt) {
        this.updateRecordSet();
    }

    private void endButtonActionPerformed(ActionEvent evt) {
        this.currentRow = this.topRow - 1;
        this.changeRows(0);
    }

    private void forwardButtonActionPerformed(ActionEvent evt) {
        this.changeRows(1);
    }

    private void backButton2ActionPerformed(ActionEvent evt) {
        this.changeRows(-1);
    }

    private void beginButton1ActionPerformed(ActionEvent evt) {
        this.currentRow = 0;
        this.changeRows(0);
    }

    private void optionsComboBoxActionPerformed(ActionEvent evt) {
        this.reviseForm(false);
    }

    private void sqlComboBoxActionPerformed(ActionEvent evt) {
        if (evt.getActionCommand().equalsIgnoreCase("comboboxchanged")) {
            this.executeSQLString();
        }
    }

    private void executeButtonActionPerformed(ActionEvent evt) {
        this.executeSQLString();
    }

    class DocumentHandler
    implements DocumentListener {
        RowItem parent;
        boolean isTextArea;

        DocumentHandler(RowItem ri) {
            this.parent = ri;
        }

        public void insertUpdate(DocumentEvent evt) {
            this.parent.documentChanged(evt);
        }

        public void removeUpdate(DocumentEvent evt) {
            this.parent.documentChanged(evt);
        }

        public void changedUpdate(DocumentEvent evt) {
            this.parent.documentChanged(evt);
        }
    }

    class RowItem {
        public JLabel label;
        public JTextField textField;
        public JTextArea textArea;
        public JScrollPane scrollPane;
        public boolean textAreaChanged = false;
        public boolean textFieldChanged = false;
        public boolean suspendChanges = false;
        int rows;

        RowItem(String lbl) {
            this.label = new JLabel(lbl);
            this.textField = new JTextField("");
            this.textField.setEditable(!DataPane.this.parent.readOnly);
            DataPane.this.parent.resetFont(this.textField);
            this.textField.setBackground(new Color(255, 255, 255));
            this.textField.addActionListener(new ActionListener(this){
                private final /* synthetic */ RowItem this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent evt) {
                    RowItem.access$000(this.this$1, evt);
                }
            });
            this.textArea = new JTextArea("");
            this.textArea.setEditable(!DataPane.this.parent.readOnly);
            DataPane.this.parent.resetFont(this.textArea);
            this.textArea.setWrapStyleWord(true);
            this.textArea.setLineWrap(true);
            this.textArea.setRows(4);
            this.scrollPane = new JScrollPane(this.textArea, 20, 31);
            this.textField.getDocument().addDocumentListener(new DocumentHandler(this));
            this.textArea.getDocument().addDocumentListener(new DocumentHandler(this));
        }

        private void textFieldActionPerformed(ActionEvent evt) {
            if (!DataPane.this.parent.readOnly) {
                DataPane.this.updateRecordSet();
            }
        }

        public void setData(String data) {
            this.suspendChanges = true;
            this.textArea.setText(data);
            this.textArea.setCaretPosition(0);
            this.textField.setText(data);
            this.suspendChanges = false;
        }

        public int addTextElement(JPanel jp, GridBagConstraints gb, int rows) {
            this.rows = rows;
            int height = 0;
            if (rows == 1) {
                jp.add((Component)this.textField, gb);
                height = this.textField.getSize().height;
            } else {
                this.textArea.setRows(rows);
                jp.add((Component)this.scrollPane, gb);
                height = this.textArea.getSize().height;
            }
            return height;
        }

        private void documentChanged(DocumentEvent evt) {
            if (!this.suspendChanges) {
                if (this.rows > 1) {
                    this.textAreaChanged = true;
                } else {
                    this.textFieldChanged = true;
                }
                DataPane.this.rowChanged = DataPane.this.currentRow;
                DataPane.this.commitButton.setEnabled(true);
            }
        }

        static /* synthetic */ void access$000(RowItem x0, ActionEvent x1) {
            x0.textFieldActionPerformed(x1);
        }
    }

    class DataListener
    implements TableModelListener {
        TableModel model;

        DataListener(JTable t) {
            this.model = t.getModel();
            this.model.addTableModelListener(this);
        }

        public void tableChanged(TableModelEvent evt) {
            if (DataPane.this.suspendChanges) {
                return;
            }
            int row = evt.getFirstRow();
            int column = evt.getColumn();
            String columnName = this.model.getColumnName(column);
            Object data = this.model.getValueAt(row, column);
            if (DataPane.this.rs != null && data != null) {
                try {
                    if (row >= DataPane.this.topRow) {
                        DataPane.this.rs.moveToInsertRow();
                    } else {
                        DataPane.this.rs.absolute(row + 1);
                    }
                    if (row >= DataPane.this.topRow) {
                        for (int i = 0; i < DataPane.this.columns; ++i) {
                            String v = this.model.getValueAt(row, i).toString();
                            DataPane.this.rs.updateString(i + 1, v);
                        }
                    } else {
                        String v = data.toString();
                        DataPane.this.rs.updateString(column + 1, v);
                    }
                    if (row >= DataPane.this.topRow) {
                        DataPane.this.rs.insertRow();
                        DataPane.this.rs.moveToCurrentRow();
                        ++DataPane.this.topRow;
                    } else {
                        DataPane.this.rs.updateRow();
                    }
                }
                catch (SQLException e) {
                    DataPane.this.parent.putMessage("Dataset update error: ", e);
                }
            }
        }
    }
}

