/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;

public class ConfigurationHandler {
    String path;
    TreeMap map;
    String delim = "\t";
    final int maxListItems = 32;
    DataProspector parent;

    public ConfigurationHandler(String pth, DataProspector p) {
        this.parent = p;
        this.path = pth;
        this.map = new TreeMap();
    }

    public String[] get(String key) {
        return (String[])this.map.get(key);
    }

    public String getSingleValue(String key) {
        String[] vals = (String[])this.map.get(key);
        if (vals != null && vals.length > 0) {
            return vals[0];
        }
        return null;
    }

    public void put(String key, String[] values) {
        if (values != null && values.length > 0 && values[0] != null) {
            this.map.put(key, values);
        }
    }

    public void putSingleValue(String key, String value) {
        if (value != null) {
            this.map.put(key, new String[]{value});
        }
    }

    public void putSingleInt(String key, int v) {
        this.map.put(key, new String[]{"" + v});
    }

    public int getSingleInt(String key) {
        String[] vals = (String[])this.map.get(key);
        int v = 0;
        if (vals != null && vals.length > 0) {
            String s = vals[0];
            try {
                v = Integer.parseInt(s);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return v;
    }

    public void putComboBox(String key, JComboBox box) {
        Vector<String> v = new Vector<String>();
        int len = box.getItemCount();
        for (int i = 0; i < len && i < 32; ++i) {
            String field = (String)box.getItemAt(i);
            if ((field = field.trim()).length() <= 0) continue;
            v.add(field);
        }
        this.put(key, v.toArray(new String[0]));
    }

    public void getComboBox(String key, JComboBox box) {
        ActionListener[] al = this.parent.removeActionListeners(box);
        String[] values = this.get(key);
        if (values != null && values.length > 0) {
            box.removeAllItems();
            for (int i = 0; i < values.length && i < 32; ++i) {
                String field = values[i];
                if ((field = field.trim()).length() <= 0) continue;
                box.addItem(field);
            }
        }
        this.parent.restoreActionListeners(box, al);
    }

    public void putCheckBox(String key, JCheckBox box) {
        String s = box.isSelected() ? "1" : "0";
        this.putSingleValue(key, s);
    }

    public void getCheckBox(String key, JCheckBox box) {
        String s = this.getSingleValue(key);
        box.setSelected(s != null && s.equals("1"));
    }

    private void arrayToMap(String[] array) {
        this.map.clear();
        for (int i = 0; i < array.length; ++i) {
            String[] pair = array[i].split("=");
            if (pair.length == 1) {
                pair = new String[]{pair[0], ""};
            }
            if (pair.length != 2) continue;
            pair[0].trim();
            pair[1].trim();
            String[] values = pair[1].split(this.delim);
            this.put(pair[0], values);
        }
    }

    private void fileToMap(String[] defaults) {
        try {
            String line;
            this.map.clear();
            this.arrayToMap(defaults);
            BufferedReader in = new BufferedReader(new FileReader(this.path));
            while ((line = in.readLine()) != null) {
                String[] pair = line.split("=");
                if (pair.length != 2) continue;
                pair[0].trim();
                pair[1].trim();
                String[] values = pair[1].split(this.delim);
                this.put(pair[0], values);
            }
            in.close();
        }
        catch (IOException e) {
            System.err.println("Error: No configuration file.\n(this is normal for the first program run)");
        }
    }

    private String join(String[] data, String delim) {
        StringBuffer result = new StringBuffer();
        int len = data.length;
        for (int i = 0; i < len; ++i) {
            result.append(data[i]);
            if (i >= len - 1) continue;
            result.append(delim);
        }
        return result.toString();
    }

    private void mapToFile() {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(this.path));
            Iterator it = this.map.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                String[] values = this.get(key);
                String joinedVals = this.join(values, this.delim);
                out.write(key + "=" + joinedVals);
                out.newLine();
            }
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeConfig() {
        this.mapToFile();
    }

    public void readConfig(String[] defaults) {
        this.fileToMap(defaults);
    }
}

