#!/usr/bin/env python3

import cadquery as cq
import math

# client area

def save(shape,name):
    cq.exporters.export(shape,name)
    
def gen_handle_plane(printable,ha,hb,w,ex,inside=False):
    a = (
    cq.Workplane("XZ")
    .moveTo(-w,-ha)
    .lineTo(-w,ha)
    .radiusArc((w,ha),w)
    .lineTo(w,-ha)
    )
    if inside or not printable:
            b = (
                a.radiusArc((-w,-ha),w)
            )
    else:
        # for 3D printing, the external loop must descend to the print surface
            b = (
                a.lineTo(w,-hb)
                .lineTo(-w,-hb)
                .lineTo(-w,-ha)
            )
    return (
        b.close()
        .extrude(ex)
        .translate((0,ex/2,0))
    )

def gen_handle(radius,height,printable):
    ha = 20
    hb = height/2
    wa = 12
    wb = 22
    ex = 12
    fi = 2
    inside = gen_handle_plane(printable,ha,ha,wa,ex, True)
    outside = gen_handle_plane(printable,ha,hb,wb,ex)
    return (
        (outside-inside)
        .translate((-radius-wa+0.2,0,height/2))
        .edges().fillet(fi)
    )

def gen_cup(r,h,w,handle,fi):
    outside = cq.Workplane("XY").circle(r).extrude(h)
    inside = cq.Workplane("XY").circle(r-w).extrude(h).translate((0,0,w))
    return (
        (outside+handle-inside).edges().fillet(fi)
    )

def gen_label(label):
    return ( 
        cq.Workplane("XY").box(60, 20, 10)
        .faces(">Z") 
        .workplane() 
        .text(label,
            16, -1,
            cut=False,
            font="Sans")
        .rotate((0,0,0),(0,1,0),180)
        .translate((0,0,5))
     )

# if printable, avoid overhangs

printable = True

# dimensions in mm

# thickness of cup wall
wall = 3 

# cup height
height = 100

# enter desired volume here : ml
desired_volume = 600 # ml

# calculate internal radius ir
# ir = sqrt(v / (height * pi))
# for desired volume

ir = math.sqrt(desired_volume * 1000/((height-wall)*math.pi))

# acquire external radius
radius = ir+wall

# compute internal volume, including
# cubic mm to ml conversion
volume_ml = (radius-wall)**2 * math.pi * (height-wall) * 0.001

print(f'cup height: {height:.2f} mm, radius: {radius:.2f} mm, volume: {volume_ml:.2f} ml')

text = f'{volume_ml:.0f}ml'
label = gen_label(text)

# the handle is rather difficult

handle = gen_handle(radius,height,printable)

cup = gen_cup(radius,height,wall, handle,1.4) - label

#cup
save(cup,'cup_generic.stl')
