#!/usr/bin/env python

import cadquery as cq
import os

def labeled_arrow(plane,label,label_angle):
    sl = 100 # shaft length
    r = 0.8 # shaft radius
    cr = 3 * r # arrowhead base radius
    ch = 8 * r # arrowhead height
    shaft = cq.Workplane().circle(r).extrude(sl-ch).translate((0,0,-sl/2))
    head = cq.Solid.makeCone(cr,0,ch).translate((0,0,sl/2-ch))
    tag = cq.Workplane().text(label,12,1).translate((0,0,sl/2+sl/30)).rotate((0,0,0),(0,0,1),label_angle)
    # assemble arrow, rotate to desired plane
    return (shaft+head+tag).rotate((0,0,0),plane,90)

arrowX = labeled_arrow((0,1,0),"X",90)
arrowY = labeled_arrow((-1,0,0),"Y",-180)
arrowZ = labeled_arrow((0,0,1),"Z",-90)

ch = .8 # color high intensity
cl = 0.1 # color low intensity

rose = cq.Assembly(name="CompassRose")

rose.add(arrowX,color=cq.Color(ch,cl,cl), name="X axis arrow")
rose.add(arrowY,color=cq.Color(cl,ch,cl), name="Y axis arrow")
rose.add(arrowZ,color=cq.Color(cl,cl,ch), name="Z axis arrow")

if 'JPY_PARENT_PID' in os.environ:
    show(rose)
else:
    rose.save("rose.gltf")
