#!/usr/bin/env python

import cadquery as cq
import os

# the client area

dx,dy,dz = 74,16,3

base = cq.Workplane().rect(dx,dy).extrude(dz)
#base
tower = ( cq.Workplane("XZ")
          .lineTo(-8,dz)
          .threePointArc((-6,dz+1.01),(-5,dz+3))
          .lineTo(-5,43)
          .lineTo(-3.25,43)
          .lineTo(-3.25,46.5)
          .threePointArc((-3.8,51.5),(0,53))
          .lineTo(0,dz)
          .close()
          .revolve(360,(0,0),(0,1), clean=True)
        )
#base+tower

mount = ( cq.Workplane("YZ")
         .moveTo(-8,0)
         .lineTo(-8,9)
         .threePointArc((0,17),(8,9))
         .lineTo(8,0)
         .close()
         .extrude(3)
         .faces(">X")
         .workplane()
         .moveTo(0,9)
         .hole(4.4)
         #.extrude(3)
        )
ma = mount.translate((-37,0,0))
mb = mount.translate((34,0,0))
bikemount = base + tower + ma + mb

if 'JPY_PARENT_PID' in os.environ:
    bikemount
else:
    cq.exporters.export(bikemount,'cadquery_bike_mirror_mount.stl')
    cq.exporters.export(bikemount,'cadquery_bike_mirror_mount.vrml')

