/***************************************************************************
 *   Copyright (C) 2011 by Paul Lutus                                      *
 *   lutusp@arachnoid.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/*
 * BiquadDesignerFrame.java
 *
 * Created on Mar 21, 2011, 1:53:24 PM
 */
package biquaddesigner;

import javax.swing.*;
import java.awt.*;
import java.io.*;

/**
 *
 * @author lutusp
 */
public class BiQuadDesigner extends javax.swing.JFrame {

    BiQuadDesignerPanel designer_panel;
    String app_name, VERSION, user_dir,file_sep,data_path,init_path,program_name;
    ConfigManager config_mgr;

    /** Creates new form BiquadDesignerFrame */
    public BiQuadDesigner(String[] args) {
        app_name = getClass().getSimpleName();
        VERSION = "1.7";
        initComponents();
        designer_panel = new BiQuadDesignerPanel(this, args);
        add(designer_panel, BorderLayout.CENTER);
        user_dir = System.getProperty("user.home");
        file_sep = System.getProperty("file.separator");
        data_path = user_dir + file_sep + "." + app_name;
        File f = new File(data_path);
        if (!f.exists()) {
            f.mkdirs();
        }
        init_path = data_path + file_sep + app_name + ".ini";
        program_name = app_name + " " + VERSION;
        setTitle(program_name);
        setIconImage(new ImageIcon(getClass().getResource(app_name + "_icon.png")).getImage());
        config_mgr = new ConfigManager(designer_panel, init_path);
        pack();
    }

    public void close() {
        config_mgr.write_config_file();
        System.exit(0);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
        setLocationByPlatform(true);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                formWindowClosing(evt);
            }
        });

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing
        close();
    }//GEN-LAST:event_formWindowClosing

    /**
     * @param args the command line arguments
     */
    public static void main(final String args[]) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            java.awt.EventQueue.invokeLater(new Runnable() {

                public void run() {
                    new BiQuadDesigner(args).setVisible(true);
                }
            });
        } catch (Exception e) {
            System.out.println("BiQuadDesigner frame: " + e);
            e.printStackTrace();
        }
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables
}
