/*
 * Decompiled with CFR 0.152.
 */
package biquaddesigner;

import biquaddesigner.ControlInterface;
import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Robot;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

public final class ComboBoxTextController
implements ControlInterface {
    JComboBox box;
    String value;
    List<String> tooltips = null;
    String prompt = null;

    public ComboBoxTextController(JComboBox b, List<String> data, String sel, List<String> tips, String prompt) {
        this.setup(b, data, sel, tips, prompt);
    }

    public ComboBoxTextController(JComboBox b, List<String> data, String sel) {
        this.setup(b, data, sel, null, null);
    }

    private void setup(JComboBox b, List<String> data, String sel, List<String> tips, String prompt) {
        this.box = b;
        this.tooltips = new ArrayList<String>();
        this.prompt = prompt;
        this.populate_combobox(data, sel, tips);
        this.box.setRenderer(new ToolTipComboBoxRenderer());
        this.box.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                ComboBoxTextController.this.mouse_wheel_event(evt);
            }
        });
        this.box.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ComboBoxTextController.this.item_state_changed(evt);
            }
        });
        this.set_box_tooltip();
    }

    public void populate_combobox(List<String> data, String sel, List<String> tips) {
        int i;
        if (tips != null) {
            for (i = tips.size() - 1; i >= 0; --i) {
                this.tooltips.add(tips.get(i));
            }
        }
        this.box.removeAllItems();
        for (i = data.size() - 1; i >= 0; --i) {
            this.box.addItem(data.get(i));
        }
        this.set_value(sel);
    }

    private void mouse_wheel_event(MouseWheelEvent evt) {
        if (this.box.isEnabled()) {
            double n = evt.getWheelRotation() > 0 ? 1.0 : -1.0;
            n = evt.isShiftDown() ? n * 10.0 : n;
            n = evt.isControlDown() ? n * 10.0 : n;
            n = evt.isAltDown() ? n * 10.0 : n;
            int v = this.box.getSelectedIndex();
            v = (int)((double)v + n * (double)Math.abs(v) / 20.0);
            v = this.check_range(v);
            this.box.setSelectedIndex(v);
            this.set_box_tooltip();
        }
    }

    private int check_range(int v) {
        int top = this.box.getItemCount();
        v = Math.min(top - 1, v);
        v = Math.max(0, v);
        return v;
    }

    private void item_state_changed(ItemEvent evt) {
        this.set_box_tooltip();
        try {
            String s;
            this.value = s = (String)this.box.getSelectedItem();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void set_box_tooltip() {
        int top = this.box.getItemCount();
        int i = this.box.getSelectedIndex();
        if (i >= 0 && i < top && this.tooltips != null && i < this.tooltips.size()) {
            String tip = this.tooltips.get(i);
            if (this.prompt != null) {
                tip = this.prompt + ": " + tip;
            }
            this.box.setToolTipText(tip);
            try {
                PointerInfo a = MouseInfo.getPointerInfo();
                Point b = a.getLocation();
                Robot r = new Robot();
                r.mouseMove(b.x, b.y - 1);
                r.mouseMove(b.x, b.y);
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
    }

    public String get_value() {
        return this.value;
    }

    public int get_index() {
        return this.box.getSelectedIndex();
    }

    @Override
    public void set_value(String s) {
        try {
            this.box.setSelectedItem(s);
            String r = (String)this.box.getSelectedItem();
            if (!r.equals(s)) {
                this.box.setSelectedIndex(0);
                s = (String)this.box.getSelectedItem();
            }
            this.value = s;
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public String toString() {
        return this.value;
    }

    class ToolTipComboBoxRenderer
    extends BasicComboBoxRenderer {
        ToolTipComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean is_selected, boolean has_focus) {
            if (is_selected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
                if (index >= 0 && ComboBoxTextController.this.tooltips != null && index < ComboBoxTextController.this.tooltips.size()) {
                    list.setToolTipText(ComboBoxTextController.this.tooltips.get(index));
                }
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setFont(list.getFont());
            this.setText(value == null ? "" : value.toString());
            return this;
        }
    }
}

