/*
 * Decompiled with CFR 0.152.
 */
package biquaddesigner;

import biquaddesigner.BiQuadDesignerPanel;
import biquaddesigner.ConfigManager;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.UIManager;

public class BiQuadDesigner
extends JFrame {
    BiQuadDesignerPanel designer_panel;
    String app_name = this.getClass().getSimpleName();
    String VERSION = "1.7";
    String user_dir;
    String file_sep;
    String data_path;
    String init_path;
    String program_name;
    ConfigManager config_mgr;

    public BiQuadDesigner(String[] args) {
        this.initComponents();
        this.designer_panel = new BiQuadDesignerPanel(this, args);
        this.add((Component)this.designer_panel, "Center");
        this.user_dir = System.getProperty("user.home");
        this.file_sep = System.getProperty("file.separator");
        this.data_path = this.user_dir + this.file_sep + "." + this.app_name;
        File f = new File(this.data_path);
        if (!f.exists()) {
            f.mkdirs();
        }
        this.init_path = this.data_path + this.file_sep + this.app_name + ".ini";
        this.program_name = this.app_name + " " + this.VERSION;
        this.setTitle(this.program_name);
        this.setIconImage(new ImageIcon(this.getClass().getResource(this.app_name + "_icon.png")).getImage());
        this.config_mgr = new ConfigManager(this.designer_panel, this.init_path);
        this.pack();
    }

    public void close() {
        this.config_mgr.write_config_file();
        System.exit(0);
    }

    private void initComponents() {
        this.setDefaultCloseOperation(0);
        this.setLocationByPlatform(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                BiQuadDesigner.this.formWindowClosing(evt);
            }
        });
        this.pack();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.close();
    }

    public static void main(final String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    new BiQuadDesigner(args).setVisible(true);
                }
            });
        }
        catch (Exception e) {
            System.out.println("BiQuadDesigner frame: " + e);
            e.printStackTrace();
        }
    }
}

